/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import software.xdev.brevo.model.GetAccountAllOfMarketingAutomation;
import software.xdev.brevo.model.GetAccountAllOfPlan;
import software.xdev.brevo.model.GetAccountAllOfRelay;
import software.xdev.brevo.model.GetExtendedClientAllOfAddress;

@JsonPropertyOrder(value={"email", "firstName", "lastName", "companyName", "address", "plan", "relay", "marketingAutomation"})
@JsonTypeName(value="getAccount")
public class GetAccount {
    public static final String JSON_PROPERTY_EMAIL = "email";
    @Nonnull
    private String email;
    public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
    @Nonnull
    private String firstName;
    public static final String JSON_PROPERTY_LAST_NAME = "lastName";
    @Nonnull
    private String lastName;
    public static final String JSON_PROPERTY_COMPANY_NAME = "companyName";
    @Nonnull
    private String companyName;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    @Nonnull
    private GetExtendedClientAllOfAddress address;
    public static final String JSON_PROPERTY_PLAN = "plan";
    @Nonnull
    private List<GetAccountAllOfPlan> plan = new ArrayList<GetAccountAllOfPlan>();
    public static final String JSON_PROPERTY_RELAY = "relay";
    @Nonnull
    private GetAccountAllOfRelay relay;
    public static final String JSON_PROPERTY_MARKETING_AUTOMATION = "marketingAutomation";
    @Nullable
    private GetAccountAllOfMarketingAutomation marketingAutomation;

    public GetAccount email(@Nonnull String email) {
        this.email = email;
        return this;
    }

    @Nonnull
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEmail(@Nonnull String email) {
        this.email = email;
    }

    public GetAccount firstName(@Nonnull String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFirstName() {
        return this.firstName;
    }

    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFirstName(@Nonnull String firstName) {
        this.firstName = firstName;
    }

    public GetAccount lastName(@Nonnull String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLastName() {
        return this.lastName;
    }

    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLastName(@Nonnull String lastName) {
        this.lastName = lastName;
    }

    public GetAccount companyName(@Nonnull String companyName) {
        this.companyName = companyName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="companyName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCompanyName() {
        return this.companyName;
    }

    @JsonProperty(value="companyName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCompanyName(@Nonnull String companyName) {
        this.companyName = companyName;
    }

    public GetAccount address(@Nonnull GetExtendedClientAllOfAddress address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GetExtendedClientAllOfAddress getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress(@Nonnull GetExtendedClientAllOfAddress address) {
        this.address = address;
    }

    public GetAccount plan(@Nonnull List<GetAccountAllOfPlan> plan) {
        this.plan = plan;
        return this;
    }

    public GetAccount addPlanItem(GetAccountAllOfPlan planItem) {
        if (this.plan == null) {
            this.plan = new ArrayList<GetAccountAllOfPlan>();
        }
        this.plan.add(planItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="plan")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<GetAccountAllOfPlan> getPlan() {
        return this.plan;
    }

    @JsonProperty(value="plan")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPlan(@Nonnull List<GetAccountAllOfPlan> plan) {
        this.plan = plan;
    }

    public GetAccount relay(@Nonnull GetAccountAllOfRelay relay) {
        this.relay = relay;
        return this;
    }

    @Nonnull
    @JsonProperty(value="relay")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GetAccountAllOfRelay getRelay() {
        return this.relay;
    }

    @JsonProperty(value="relay")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRelay(@Nonnull GetAccountAllOfRelay relay) {
        this.relay = relay;
    }

    public GetAccount marketingAutomation(@Nullable GetAccountAllOfMarketingAutomation marketingAutomation) {
        this.marketingAutomation = marketingAutomation;
        return this;
    }

    @Nullable
    @JsonProperty(value="marketingAutomation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GetAccountAllOfMarketingAutomation getMarketingAutomation() {
        return this.marketingAutomation;
    }

    @JsonProperty(value="marketingAutomation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMarketingAutomation(@Nullable GetAccountAllOfMarketingAutomation marketingAutomation) {
        this.marketingAutomation = marketingAutomation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetAccount getAccount = (GetAccount)o;
        return Objects.equals(this.email, getAccount.email) && Objects.equals(this.firstName, getAccount.firstName) && Objects.equals(this.lastName, getAccount.lastName) && Objects.equals(this.companyName, getAccount.companyName) && Objects.equals(this.address, getAccount.address) && Objects.equals(this.plan, getAccount.plan) && Objects.equals(this.relay, getAccount.relay) && Objects.equals(this.marketingAutomation, getAccount.marketingAutomation);
    }

    public int hashCode() {
        return Objects.hash(this.email, this.firstName, this.lastName, this.companyName, this.address, this.plan, this.relay, this.marketingAutomation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetAccount {\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    companyName: ").append(this.toIndentedString(this.companyName)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    plan: ").append(this.toIndentedString(this.plan)).append("\n");
        sb.append("    relay: ").append(this.toIndentedString(this.relay)).append("\n");
        sb.append("    marketingAutomation: ").append(this.toIndentedString(this.marketingAutomation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getEmail() != null) {
            try {
                joiner.add(String.format("%semail%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEmail()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getFirstName() != null) {
            try {
                joiner.add(String.format("%sfirstName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getFirstName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getLastName() != null) {
            try {
                joiner.add(String.format("%slastName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLastName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getCompanyName() != null) {
            try {
                joiner.add(String.format("%scompanyName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCompanyName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getAddress() != null) {
            joiner.add(this.getAddress().toUrlQueryString((String)prefix + JSON_PROPERTY_ADDRESS + suffix));
        }
        if (this.getPlan() != null) {
            for (int i = 0; i < this.getPlan().size(); ++i) {
                if (this.getPlan().get(i) == null) continue;
                joiner.add(this.getPlan().get(i).toUrlQueryString(String.format("%splan%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getRelay() != null) {
            joiner.add(this.getRelay().toUrlQueryString((String)prefix + JSON_PROPERTY_RELAY + suffix));
        }
        if (this.getMarketingAutomation() != null) {
            joiner.add(this.getMarketingAutomation().toUrlQueryString((String)prefix + JSON_PROPERTY_MARKETING_AUTOMATION + suffix));
        }
        return joiner.toString();
    }
}

