/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import software.xdev.brevo.model.EventContactPropertiesValue;
import software.xdev.brevo.model.EventEventPropertiesValue;
import software.xdev.brevo.model.EventIdentifiers;

@JsonPropertyOrder(value={"event_name", "event_date", "identifiers", "contact_properties", "event_properties"})
@JsonTypeName(value="event")
public class Event {
    public static final String JSON_PROPERTY_EVENT_NAME = "event_name";
    @Nonnull
    private String eventName;
    public static final String JSON_PROPERTY_EVENT_DATE = "event_date";
    @Nullable
    private String eventDate;
    public static final String JSON_PROPERTY_IDENTIFIERS = "identifiers";
    @Nonnull
    private EventIdentifiers identifiers;
    public static final String JSON_PROPERTY_CONTACT_PROPERTIES = "contact_properties";
    @Nullable
    private Map<String, EventContactPropertiesValue> contactProperties = new HashMap<String, EventContactPropertiesValue>();
    public static final String JSON_PROPERTY_EVENT_PROPERTIES = "event_properties";
    @Nullable
    private Map<String, EventEventPropertiesValue> eventProperties = new HashMap<String, EventEventPropertiesValue>();

    public Event eventName(@Nonnull String eventName) {
        this.eventName = eventName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="event_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEventName() {
        return this.eventName;
    }

    @JsonProperty(value="event_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEventName(@Nonnull String eventName) {
        this.eventName = eventName;
    }

    public Event eventDate(@Nullable String eventDate) {
        this.eventDate = eventDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="event_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEventDate() {
        return this.eventDate;
    }

    @JsonProperty(value="event_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEventDate(@Nullable String eventDate) {
        this.eventDate = eventDate;
    }

    public Event identifiers(@Nonnull EventIdentifiers identifiers) {
        this.identifiers = identifiers;
        return this;
    }

    @Nonnull
    @JsonProperty(value="identifiers")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EventIdentifiers getIdentifiers() {
        return this.identifiers;
    }

    @JsonProperty(value="identifiers")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifiers(@Nonnull EventIdentifiers identifiers) {
        this.identifiers = identifiers;
    }

    public Event contactProperties(@Nullable Map<String, EventContactPropertiesValue> contactProperties) {
        this.contactProperties = contactProperties;
        return this;
    }

    public Event putContactPropertiesItem(String key, EventContactPropertiesValue contactPropertiesItem) {
        if (this.contactProperties == null) {
            this.contactProperties = new HashMap<String, EventContactPropertiesValue>();
        }
        this.contactProperties.put(key, contactPropertiesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="contact_properties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, EventContactPropertiesValue> getContactProperties() {
        return this.contactProperties;
    }

    @JsonProperty(value="contact_properties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContactProperties(@Nullable Map<String, EventContactPropertiesValue> contactProperties) {
        this.contactProperties = contactProperties;
    }

    public Event eventProperties(@Nullable Map<String, EventEventPropertiesValue> eventProperties) {
        this.eventProperties = eventProperties;
        return this;
    }

    public Event putEventPropertiesItem(String key, EventEventPropertiesValue eventPropertiesItem) {
        if (this.eventProperties == null) {
            this.eventProperties = new HashMap<String, EventEventPropertiesValue>();
        }
        this.eventProperties.put(key, eventPropertiesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="event_properties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, EventEventPropertiesValue> getEventProperties() {
        return this.eventProperties;
    }

    @JsonProperty(value="event_properties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEventProperties(@Nullable Map<String, EventEventPropertiesValue> eventProperties) {
        this.eventProperties = eventProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        return Objects.equals(this.eventName, event.eventName) && Objects.equals(this.eventDate, event.eventDate) && Objects.equals(this.identifiers, event.identifiers) && Objects.equals(this.contactProperties, event.contactProperties) && Objects.equals(this.eventProperties, event.eventProperties);
    }

    public int hashCode() {
        return Objects.hash(this.eventName, this.eventDate, this.identifiers, this.contactProperties, this.eventProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Event {\n");
        sb.append("    eventName: ").append(this.toIndentedString(this.eventName)).append("\n");
        sb.append("    eventDate: ").append(this.toIndentedString(this.eventDate)).append("\n");
        sb.append("    identifiers: ").append(this.toIndentedString(this.identifiers)).append("\n");
        sb.append("    contactProperties: ").append(this.toIndentedString(this.contactProperties)).append("\n");
        sb.append("    eventProperties: ").append(this.toIndentedString(this.eventProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getEventName() != null) {
            try {
                joiner.add(String.format("%sevent_name%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEventName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getEventDate() != null) {
            try {
                joiner.add(String.format("%sevent_date%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEventDate()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getIdentifiers() != null) {
            joiner.add(this.getIdentifiers().toUrlQueryString((String)prefix + JSON_PROPERTY_IDENTIFIERS + suffix));
        }
        if (this.getContactProperties() != null) {
            for (String _key : this.getContactProperties().keySet()) {
                if (this.getContactProperties().get(_key) == null) continue;
                joiner.add(this.getContactProperties().get(_key).toUrlQueryString(String.format("%scontact_properties%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        if (this.getEventProperties() != null) {
            for (String _key : this.getEventProperties().keySet()) {
                if (this.getEventProperties().get(_key) == null) continue;
                joiner.add(this.getEventProperties().get(_key).toUrlQueryString(String.format("%sevent_properties%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

