/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"code", "message"})
@JsonTypeName(value="errorModel")
public class ErrorModel {
    public static final String JSON_PROPERTY_CODE = "code";
    @Nonnull
    private CodeEnum code;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    @Nonnull
    private String message;

    public ErrorModel code(@Nonnull CodeEnum code) {
        this.code = code;
        return this;
    }

    @Nonnull
    @JsonProperty(value="code")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CodeEnum getCode() {
        return this.code;
    }

    @JsonProperty(value="code")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCode(@Nonnull CodeEnum code) {
        this.code = code;
    }

    public ErrorModel message(@Nonnull String message) {
        this.message = message;
        return this;
    }

    @Nonnull
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMessage(@Nonnull String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorModel errorModel = (ErrorModel)o;
        return Objects.equals((Object)this.code, (Object)errorModel.code) && Objects.equals(this.message, errorModel.message);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.code, this.message});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ErrorModel {\n");
        sb.append("    code: ").append(this.toIndentedString((Object)this.code)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getCode() != null) {
            try {
                joiner.add(String.format("%scode%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getCode()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getMessage() != null) {
            try {
                joiner.add(String.format("%smessage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getMessage()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }

    public static enum CodeEnum {
        INVALID_PARAMETER(String.valueOf("invalid_parameter")),
        MISSING_PARAMETER(String.valueOf("missing_parameter")),
        OUT_OF_RANGE(String.valueOf("out_of_range")),
        CAMPAIGN_PROCESSING(String.valueOf("campaign_processing")),
        CAMPAIGN_SENT(String.valueOf("campaign_sent")),
        DOCUMENT_NOT_FOUND(String.valueOf("document_not_found")),
        NOT_ENOUGH_CREDITS(String.valueOf("not_enough_credits")),
        PERMISSION_DENIED(String.valueOf("permission_denied")),
        DUPLICATE_PARAMETER(String.valueOf("duplicate_parameter")),
        DUPLICATE_REQUEST(String.valueOf("duplicate_request")),
        METHOD_NOT_ALLOWED(String.valueOf("method_not_allowed")),
        UNAUTHORIZED(String.valueOf("unauthorized")),
        ACCOUNT_UNDER_VALIDATION(String.valueOf("account_under_validation")),
        NOT_ACCEPTABLE(String.valueOf("not_acceptable")),
        BAD_REQUEST(String.valueOf("bad_request")),
        UNPROCESSABLE_ENTITY(String.valueOf("unprocessable_entity"));

        private String value;

        private CodeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CodeEnum fromValue(String value) {
            for (CodeEnum b : CodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

