/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import software.xdev.brevo.model.TaskReminder;

@JsonPropertyOrder(value={"name", "duration", "taskTypeId", "date", "notes", "done", "assignToId", "contactsIds", "dealsIds", "companiesIds", "reminder"})
@JsonTypeName(value="_crm_tasks_post_request")
public class CrmTasksPostRequest {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_DURATION = "duration";
    @Nullable
    private Long duration;
    public static final String JSON_PROPERTY_TASK_TYPE_ID = "taskTypeId";
    @Nonnull
    private String taskTypeId;
    public static final String JSON_PROPERTY_DATE = "date";
    @Nonnull
    private OffsetDateTime date;
    public static final String JSON_PROPERTY_NOTES = "notes";
    @Nullable
    private String notes;
    public static final String JSON_PROPERTY_DONE = "done";
    @Nullable
    private Boolean done;
    public static final String JSON_PROPERTY_ASSIGN_TO_ID = "assignToId";
    @Nullable
    private String assignToId;
    public static final String JSON_PROPERTY_CONTACTS_IDS = "contactsIds";
    @Nullable
    private List<Integer> contactsIds = new ArrayList<Integer>();
    public static final String JSON_PROPERTY_DEALS_IDS = "dealsIds";
    @Nullable
    private List<String> dealsIds = new ArrayList<String>();
    public static final String JSON_PROPERTY_COMPANIES_IDS = "companiesIds";
    @Nullable
    private List<String> companiesIds = new ArrayList<String>();
    public static final String JSON_PROPERTY_REMINDER = "reminder";
    @Nullable
    private TaskReminder reminder;

    public CrmTasksPostRequest name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public CrmTasksPostRequest duration(@Nullable Long duration) {
        this.duration = duration;
        return this;
    }

    @Nullable
    @JsonProperty(value="duration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getDuration() {
        return this.duration;
    }

    @JsonProperty(value="duration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDuration(@Nullable Long duration) {
        this.duration = duration;
    }

    public CrmTasksPostRequest taskTypeId(@Nonnull String taskTypeId) {
        this.taskTypeId = taskTypeId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="taskTypeId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTaskTypeId() {
        return this.taskTypeId;
    }

    @JsonProperty(value="taskTypeId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTaskTypeId(@Nonnull String taskTypeId) {
        this.taskTypeId = taskTypeId;
    }

    public CrmTasksPostRequest date(@Nonnull OffsetDateTime date) {
        this.date = date;
        return this;
    }

    @Nonnull
    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getDate() {
        return this.date;
    }

    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDate(@Nonnull OffsetDateTime date) {
        this.date = date;
    }

    public CrmTasksPostRequest notes(@Nullable String notes) {
        this.notes = notes;
        return this;
    }

    @Nullable
    @JsonProperty(value="notes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNotes() {
        return this.notes;
    }

    @JsonProperty(value="notes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNotes(@Nullable String notes) {
        this.notes = notes;
    }

    public CrmTasksPostRequest done(@Nullable Boolean done) {
        this.done = done;
        return this;
    }

    @Nullable
    @JsonProperty(value="done")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDone() {
        return this.done;
    }

    @JsonProperty(value="done")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDone(@Nullable Boolean done) {
        this.done = done;
    }

    public CrmTasksPostRequest assignToId(@Nullable String assignToId) {
        this.assignToId = assignToId;
        return this;
    }

    @Nullable
    @JsonProperty(value="assignToId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAssignToId() {
        return this.assignToId;
    }

    @JsonProperty(value="assignToId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssignToId(@Nullable String assignToId) {
        this.assignToId = assignToId;
    }

    public CrmTasksPostRequest contactsIds(@Nullable List<Integer> contactsIds) {
        this.contactsIds = contactsIds;
        return this;
    }

    public CrmTasksPostRequest addContactsIdsItem(Integer contactsIdsItem) {
        if (this.contactsIds == null) {
            this.contactsIds = new ArrayList<Integer>();
        }
        this.contactsIds.add(contactsIdsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="contactsIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Integer> getContactsIds() {
        return this.contactsIds;
    }

    @JsonProperty(value="contactsIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContactsIds(@Nullable List<Integer> contactsIds) {
        this.contactsIds = contactsIds;
    }

    public CrmTasksPostRequest dealsIds(@Nullable List<String> dealsIds) {
        this.dealsIds = dealsIds;
        return this;
    }

    public CrmTasksPostRequest addDealsIdsItem(String dealsIdsItem) {
        if (this.dealsIds == null) {
            this.dealsIds = new ArrayList<String>();
        }
        this.dealsIds.add(dealsIdsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="dealsIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDealsIds() {
        return this.dealsIds;
    }

    @JsonProperty(value="dealsIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDealsIds(@Nullable List<String> dealsIds) {
        this.dealsIds = dealsIds;
    }

    public CrmTasksPostRequest companiesIds(@Nullable List<String> companiesIds) {
        this.companiesIds = companiesIds;
        return this;
    }

    public CrmTasksPostRequest addCompaniesIdsItem(String companiesIdsItem) {
        if (this.companiesIds == null) {
            this.companiesIds = new ArrayList<String>();
        }
        this.companiesIds.add(companiesIdsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="companiesIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCompaniesIds() {
        return this.companiesIds;
    }

    @JsonProperty(value="companiesIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompaniesIds(@Nullable List<String> companiesIds) {
        this.companiesIds = companiesIds;
    }

    public CrmTasksPostRequest reminder(@Nullable TaskReminder reminder) {
        this.reminder = reminder;
        return this;
    }

    @Nullable
    @JsonProperty(value="reminder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TaskReminder getReminder() {
        return this.reminder;
    }

    @JsonProperty(value="reminder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReminder(@Nullable TaskReminder reminder) {
        this.reminder = reminder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrmTasksPostRequest crmTasksPostRequest = (CrmTasksPostRequest)o;
        return Objects.equals(this.name, crmTasksPostRequest.name) && Objects.equals(this.duration, crmTasksPostRequest.duration) && Objects.equals(this.taskTypeId, crmTasksPostRequest.taskTypeId) && Objects.equals(this.date, crmTasksPostRequest.date) && Objects.equals(this.notes, crmTasksPostRequest.notes) && Objects.equals(this.done, crmTasksPostRequest.done) && Objects.equals(this.assignToId, crmTasksPostRequest.assignToId) && Objects.equals(this.contactsIds, crmTasksPostRequest.contactsIds) && Objects.equals(this.dealsIds, crmTasksPostRequest.dealsIds) && Objects.equals(this.companiesIds, crmTasksPostRequest.companiesIds) && Objects.equals(this.reminder, crmTasksPostRequest.reminder);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.duration, this.taskTypeId, this.date, this.notes, this.done, this.assignToId, this.contactsIds, this.dealsIds, this.companiesIds, this.reminder);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CrmTasksPostRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    taskTypeId: ").append(this.toIndentedString(this.taskTypeId)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    done: ").append(this.toIndentedString(this.done)).append("\n");
        sb.append("    assignToId: ").append(this.toIndentedString(this.assignToId)).append("\n");
        sb.append("    contactsIds: ").append(this.toIndentedString(this.contactsIds)).append("\n");
        sb.append("    dealsIds: ").append(this.toIndentedString(this.dealsIds)).append("\n");
        sb.append("    companiesIds: ").append(this.toIndentedString(this.companiesIds)).append("\n");
        sb.append("    reminder: ").append(this.toIndentedString(this.reminder)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            try {
                joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDuration() != null) {
            try {
                joiner.add(String.format("%sduration%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDuration()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getTaskTypeId() != null) {
            try {
                joiner.add(String.format("%staskTypeId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTaskTypeId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDate() != null) {
            try {
                joiner.add(String.format("%sdate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDate()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getNotes() != null) {
            try {
                joiner.add(String.format("%snotes%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getNotes()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDone() != null) {
            try {
                joiner.add(String.format("%sdone%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDone()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getAssignToId() != null) {
            try {
                joiner.add(String.format("%sassignToId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAssignToId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getContactsIds() != null) {
            for (i = 0; i < this.getContactsIds().size(); ++i) {
                try {
                    joiner.add(String.format("%scontactsIds%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getContactsIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getDealsIds() != null) {
            for (i = 0; i < this.getDealsIds().size(); ++i) {
                try {
                    joiner.add(String.format("%sdealsIds%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getDealsIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getCompaniesIds() != null) {
            for (i = 0; i < this.getCompaniesIds().size(); ++i) {
                try {
                    joiner.add(String.format("%scompaniesIds%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getCompaniesIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getReminder() != null) {
            joiner.add(this.getReminder().toUrlQueryString((String)prefix + JSON_PROPERTY_REMINDER + suffix));
        }
        return joiner.toString();
    }
}

