/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"name", "attributes", "linkedContactsIds", "linkedCompaniesIds"})
@JsonTypeName(value="_crm_deals_post_request")
public class CrmDealsPostRequest {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    @Nullable
    private Object attributes;
    public static final String JSON_PROPERTY_LINKED_CONTACTS_IDS = "linkedContactsIds";
    @Nullable
    private List<Long> linkedContactsIds = new ArrayList<Long>();
    public static final String JSON_PROPERTY_LINKED_COMPANIES_IDS = "linkedCompaniesIds";
    @Nullable
    private List<String> linkedCompaniesIds = new ArrayList<String>();

    public CrmDealsPostRequest name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public CrmDealsPostRequest attributes(@Nullable Object attributes) {
        this.attributes = attributes;
        return this;
    }

    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttributes(@Nullable Object attributes) {
        this.attributes = attributes;
    }

    public CrmDealsPostRequest linkedContactsIds(@Nullable List<Long> linkedContactsIds) {
        this.linkedContactsIds = linkedContactsIds;
        return this;
    }

    public CrmDealsPostRequest addLinkedContactsIdsItem(Long linkedContactsIdsItem) {
        if (this.linkedContactsIds == null) {
            this.linkedContactsIds = new ArrayList<Long>();
        }
        this.linkedContactsIds.add(linkedContactsIdsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="linkedContactsIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Long> getLinkedContactsIds() {
        return this.linkedContactsIds;
    }

    @JsonProperty(value="linkedContactsIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinkedContactsIds(@Nullable List<Long> linkedContactsIds) {
        this.linkedContactsIds = linkedContactsIds;
    }

    public CrmDealsPostRequest linkedCompaniesIds(@Nullable List<String> linkedCompaniesIds) {
        this.linkedCompaniesIds = linkedCompaniesIds;
        return this;
    }

    public CrmDealsPostRequest addLinkedCompaniesIdsItem(String linkedCompaniesIdsItem) {
        if (this.linkedCompaniesIds == null) {
            this.linkedCompaniesIds = new ArrayList<String>();
        }
        this.linkedCompaniesIds.add(linkedCompaniesIdsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="linkedCompaniesIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getLinkedCompaniesIds() {
        return this.linkedCompaniesIds;
    }

    @JsonProperty(value="linkedCompaniesIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinkedCompaniesIds(@Nullable List<String> linkedCompaniesIds) {
        this.linkedCompaniesIds = linkedCompaniesIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrmDealsPostRequest crmDealsPostRequest = (CrmDealsPostRequest)o;
        return Objects.equals(this.name, crmDealsPostRequest.name) && Objects.equals(this.attributes, crmDealsPostRequest.attributes) && Objects.equals(this.linkedContactsIds, crmDealsPostRequest.linkedContactsIds) && Objects.equals(this.linkedCompaniesIds, crmDealsPostRequest.linkedCompaniesIds);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.attributes, this.linkedContactsIds, this.linkedCompaniesIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CrmDealsPostRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    linkedContactsIds: ").append(this.toIndentedString(this.linkedContactsIds)).append("\n");
        sb.append("    linkedCompaniesIds: ").append(this.toIndentedString(this.linkedCompaniesIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            try {
                joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getAttributes() != null) {
            try {
                joiner.add(String.format("%sattributes%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAttributes()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getLinkedContactsIds() != null) {
            for (i = 0; i < this.getLinkedContactsIds().size(); ++i) {
                try {
                    joiner.add(String.format("%slinkedContactsIds%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getLinkedContactsIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getLinkedCompaniesIds() != null) {
            for (i = 0; i < this.getLinkedCompaniesIds().size(); ++i) {
                try {
                    joiner.add(String.format("%slinkedCompaniesIds%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getLinkedCompaniesIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }
}

