/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"name", "attributes", "linkedContactIds", "linkedCompaniesIds"})
@JsonTypeName(value="_crm_deals__id__patch_request")
public class CrmDealsIdPatchRequest {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nullable
    private String name;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    @Nullable
    private Object attributes;
    public static final String JSON_PROPERTY_LINKED_CONTACT_IDS = "linkedContactIds";
    @Nullable
    private List<Long> linkedContactIds = new ArrayList<Long>();
    public static final String JSON_PROPERTY_LINKED_COMPANIES_IDS = "linkedCompaniesIds";
    @Nullable
    private List<String> linkedCompaniesIds = new ArrayList<String>();

    public CrmDealsIdPatchRequest name(@Nullable String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(@Nullable String name) {
        this.name = name;
    }

    public CrmDealsIdPatchRequest attributes(@Nullable Object attributes) {
        this.attributes = attributes;
        return this;
    }

    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttributes(@Nullable Object attributes) {
        this.attributes = attributes;
    }

    public CrmDealsIdPatchRequest linkedContactIds(@Nullable List<Long> linkedContactIds) {
        this.linkedContactIds = linkedContactIds;
        return this;
    }

    public CrmDealsIdPatchRequest addLinkedContactIdsItem(Long linkedContactIdsItem) {
        if (this.linkedContactIds == null) {
            this.linkedContactIds = new ArrayList<Long>();
        }
        this.linkedContactIds.add(linkedContactIdsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="linkedContactIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Long> getLinkedContactIds() {
        return this.linkedContactIds;
    }

    @JsonProperty(value="linkedContactIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinkedContactIds(@Nullable List<Long> linkedContactIds) {
        this.linkedContactIds = linkedContactIds;
    }

    public CrmDealsIdPatchRequest linkedCompaniesIds(@Nullable List<String> linkedCompaniesIds) {
        this.linkedCompaniesIds = linkedCompaniesIds;
        return this;
    }

    public CrmDealsIdPatchRequest addLinkedCompaniesIdsItem(String linkedCompaniesIdsItem) {
        if (this.linkedCompaniesIds == null) {
            this.linkedCompaniesIds = new ArrayList<String>();
        }
        this.linkedCompaniesIds.add(linkedCompaniesIdsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="linkedCompaniesIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getLinkedCompaniesIds() {
        return this.linkedCompaniesIds;
    }

    @JsonProperty(value="linkedCompaniesIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinkedCompaniesIds(@Nullable List<String> linkedCompaniesIds) {
        this.linkedCompaniesIds = linkedCompaniesIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrmDealsIdPatchRequest crmDealsIdPatchRequest = (CrmDealsIdPatchRequest)o;
        return Objects.equals(this.name, crmDealsIdPatchRequest.name) && Objects.equals(this.attributes, crmDealsIdPatchRequest.attributes) && Objects.equals(this.linkedContactIds, crmDealsIdPatchRequest.linkedContactIds) && Objects.equals(this.linkedCompaniesIds, crmDealsIdPatchRequest.linkedCompaniesIds);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.attributes, this.linkedContactIds, this.linkedCompaniesIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CrmDealsIdPatchRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    linkedContactIds: ").append(this.toIndentedString(this.linkedContactIds)).append("\n");
        sb.append("    linkedCompaniesIds: ").append(this.toIndentedString(this.linkedCompaniesIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            try {
                joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getAttributes() != null) {
            try {
                joiner.add(String.format("%sattributes%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAttributes()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getLinkedContactIds() != null) {
            for (i = 0; i < this.getLinkedContactIds().size(); ++i) {
                try {
                    joiner.add(String.format("%slinkedContactIds%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getLinkedContactIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getLinkedCompaniesIds() != null) {
            for (i = 0; i < this.getLinkedCompaniesIds().size(); ++i) {
                try {
                    joiner.add(String.format("%slinkedCompaniesIds%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getLinkedCompaniesIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }
}

