/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"label", "attributeType", "description", "optionsLabels", "objectType"})
@JsonTypeName(value="_crm_attributes_post_request")
public class CrmAttributesPostRequest {
    public static final String JSON_PROPERTY_LABEL = "label";
    @Nonnull
    private String label;
    public static final String JSON_PROPERTY_ATTRIBUTE_TYPE = "attributeType";
    @Nonnull
    private AttributeTypeEnum attributeType;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nullable
    private String description;
    public static final String JSON_PROPERTY_OPTIONS_LABELS = "optionsLabels";
    @Nullable
    private List<String> optionsLabels = new ArrayList<String>();
    public static final String JSON_PROPERTY_OBJECT_TYPE = "objectType";
    @Nonnull
    private ObjectTypeEnum objectType;

    public CrmAttributesPostRequest label(@Nonnull String label) {
        this.label = label;
        return this;
    }

    @Nonnull
    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLabel() {
        return this.label;
    }

    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLabel(@Nonnull String label) {
        this.label = label;
    }

    public CrmAttributesPostRequest attributeType(@Nonnull AttributeTypeEnum attributeType) {
        this.attributeType = attributeType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="attributeType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AttributeTypeEnum getAttributeType() {
        return this.attributeType;
    }

    @JsonProperty(value="attributeType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAttributeType(@Nonnull AttributeTypeEnum attributeType) {
        this.attributeType = attributeType;
    }

    public CrmAttributesPostRequest description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public CrmAttributesPostRequest optionsLabels(@Nullable List<String> optionsLabels) {
        this.optionsLabels = optionsLabels;
        return this;
    }

    public CrmAttributesPostRequest addOptionsLabelsItem(String optionsLabelsItem) {
        if (this.optionsLabels == null) {
            this.optionsLabels = new ArrayList<String>();
        }
        this.optionsLabels.add(optionsLabelsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="optionsLabels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getOptionsLabels() {
        return this.optionsLabels;
    }

    @JsonProperty(value="optionsLabels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOptionsLabels(@Nullable List<String> optionsLabels) {
        this.optionsLabels = optionsLabels;
    }

    public CrmAttributesPostRequest objectType(@Nonnull ObjectTypeEnum objectType) {
        this.objectType = objectType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="objectType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ObjectTypeEnum getObjectType() {
        return this.objectType;
    }

    @JsonProperty(value="objectType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setObjectType(@Nonnull ObjectTypeEnum objectType) {
        this.objectType = objectType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrmAttributesPostRequest crmAttributesPostRequest = (CrmAttributesPostRequest)o;
        return Objects.equals(this.label, crmAttributesPostRequest.label) && Objects.equals((Object)this.attributeType, (Object)crmAttributesPostRequest.attributeType) && Objects.equals(this.description, crmAttributesPostRequest.description) && Objects.equals(this.optionsLabels, crmAttributesPostRequest.optionsLabels) && Objects.equals((Object)this.objectType, (Object)crmAttributesPostRequest.objectType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.label, this.attributeType, this.description, this.optionsLabels, this.objectType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CrmAttributesPostRequest {\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    attributeType: ").append(this.toIndentedString((Object)this.attributeType)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    optionsLabels: ").append(this.toIndentedString(this.optionsLabels)).append("\n");
        sb.append("    objectType: ").append(this.toIndentedString((Object)this.objectType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getLabel() != null) {
            try {
                joiner.add(String.format("%slabel%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLabel()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getAttributeType() != null) {
            try {
                joiner.add(String.format("%sattributeType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getAttributeType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDescription() != null) {
            try {
                joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDescription()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getOptionsLabels() != null) {
            for (int i = 0; i < this.getOptionsLabels().size(); ++i) {
                try {
                    joiner.add(String.format("%soptionsLabels%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getOptionsLabels().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getObjectType() != null) {
            try {
                joiner.add(String.format("%sobjectType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getObjectType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }

    public static enum AttributeTypeEnum {
        TEXT(String.valueOf("text")),
        USER(String.valueOf("user")),
        NUMBER(String.valueOf("number")),
        SINGLE_SELECT(String.valueOf("single-select")),
        DATE(String.valueOf("date")),
        BOOLEAN(String.valueOf("boolean")),
        MULTI_CHOICE(String.valueOf("multi-choice"));

        private String value;

        private AttributeTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AttributeTypeEnum fromValue(String value) {
            for (AttributeTypeEnum b : AttributeTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ObjectTypeEnum {
        COMPANIES(String.valueOf("companies")),
        DEALS(String.valueOf("deals"));

        private String value;

        private ObjectTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ObjectTypeEnum fromValue(String value) {
            for (ObjectTypeEnum b : ObjectTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

