/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"name", "language", "category", "mediaUrl", "bodyText", "headerText", "source"})
@JsonTypeName(value="createWhatsAppTemplate")
public class CreateWhatsAppTemplate {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    @Nonnull
    private String language;
    public static final String JSON_PROPERTY_CATEGORY = "category";
    @Nonnull
    private CategoryEnum category;
    public static final String JSON_PROPERTY_MEDIA_URL = "mediaUrl";
    @Nullable
    private String mediaUrl;
    public static final String JSON_PROPERTY_BODY_TEXT = "bodyText";
    @Nonnull
    private String bodyText;
    public static final String JSON_PROPERTY_HEADER_TEXT = "headerText";
    @Nullable
    private String headerText;
    public static final String JSON_PROPERTY_SOURCE = "source";
    @Nullable
    private SourceEnum source;

    public CreateWhatsAppTemplate name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public CreateWhatsAppTemplate language(@Nonnull String language) {
        this.language = language;
        return this;
    }

    @Nonnull
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLanguage(@Nonnull String language) {
        this.language = language;
    }

    public CreateWhatsAppTemplate category(@Nonnull CategoryEnum category) {
        this.category = category;
        return this;
    }

    @Nonnull
    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CategoryEnum getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCategory(@Nonnull CategoryEnum category) {
        this.category = category;
    }

    public CreateWhatsAppTemplate mediaUrl(@Nullable String mediaUrl) {
        this.mediaUrl = mediaUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="mediaUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMediaUrl() {
        return this.mediaUrl;
    }

    @JsonProperty(value="mediaUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMediaUrl(@Nullable String mediaUrl) {
        this.mediaUrl = mediaUrl;
    }

    public CreateWhatsAppTemplate bodyText(@Nonnull String bodyText) {
        this.bodyText = bodyText;
        return this;
    }

    @Nonnull
    @JsonProperty(value="bodyText")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getBodyText() {
        return this.bodyText;
    }

    @JsonProperty(value="bodyText")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBodyText(@Nonnull String bodyText) {
        this.bodyText = bodyText;
    }

    public CreateWhatsAppTemplate headerText(@Nullable String headerText) {
        this.headerText = headerText;
        return this;
    }

    @Nullable
    @JsonProperty(value="headerText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHeaderText() {
        return this.headerText;
    }

    @JsonProperty(value="headerText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHeaderText(@Nullable String headerText) {
        this.headerText = headerText;
    }

    public CreateWhatsAppTemplate source(@Nullable SourceEnum source) {
        this.source = source;
        return this;
    }

    @Nullable
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SourceEnum getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSource(@Nullable SourceEnum source) {
        this.source = source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateWhatsAppTemplate createWhatsAppTemplate = (CreateWhatsAppTemplate)o;
        return Objects.equals(this.name, createWhatsAppTemplate.name) && Objects.equals(this.language, createWhatsAppTemplate.language) && Objects.equals((Object)this.category, (Object)createWhatsAppTemplate.category) && Objects.equals(this.mediaUrl, createWhatsAppTemplate.mediaUrl) && Objects.equals(this.bodyText, createWhatsAppTemplate.bodyText) && Objects.equals(this.headerText, createWhatsAppTemplate.headerText) && Objects.equals((Object)this.source, (Object)createWhatsAppTemplate.source);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.language, this.category, this.mediaUrl, this.bodyText, this.headerText, this.source});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateWhatsAppTemplate {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    mediaUrl: ").append(this.toIndentedString(this.mediaUrl)).append("\n");
        sb.append("    bodyText: ").append(this.toIndentedString(this.bodyText)).append("\n");
        sb.append("    headerText: ").append(this.toIndentedString(this.headerText)).append("\n");
        sb.append("    source: ").append(this.toIndentedString((Object)this.source)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            try {
                joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getLanguage() != null) {
            try {
                joiner.add(String.format("%slanguage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLanguage()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getCategory() != null) {
            try {
                joiner.add(String.format("%scategory%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getCategory()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getMediaUrl() != null) {
            try {
                joiner.add(String.format("%smediaUrl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getMediaUrl()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getBodyText() != null) {
            try {
                joiner.add(String.format("%sbodyText%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getBodyText()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getHeaderText() != null) {
            try {
                joiner.add(String.format("%sheaderText%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getHeaderText()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getSource() != null) {
            try {
                joiner.add(String.format("%ssource%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getSource()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }

    public static enum CategoryEnum {
        MARKETING(String.valueOf("MARKETING")),
        UTILITY(String.valueOf("UTILITY"));

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum SourceEnum {
        AUTOMATION(String.valueOf("Automation")),
        CONVERSATIONS(String.valueOf("Conversations"));

        private String value;

        private SourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SourceEnum fromValue(String value) {
            for (SourceEnum b : SourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

