/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"url", "description", "events", "type", "channel", "domain", "batched", "auth", "headers"})
@JsonTypeName(value="createWebhook")
public class CreateWebhook {
    public static final String JSON_PROPERTY_URL = "url";
    @Nonnull
    private String url;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nullable
    private String description;
    public static final String JSON_PROPERTY_EVENTS = "events";
    @Nonnull
    private List<EventsEnum> events = new ArrayList<EventsEnum>();
    public static final String JSON_PROPERTY_TYPE = "type";
    @Nullable
    private TypeEnum type = TypeEnum.TRANSACTIONAL;
    public static final String JSON_PROPERTY_CHANNEL = "channel";
    @Nullable
    private ChannelEnum channel = ChannelEnum.EMAIL;
    public static final String JSON_PROPERTY_DOMAIN = "domain";
    @Nullable
    private String domain;
    public static final String JSON_PROPERTY_BATCHED = "batched";
    @Nullable
    private Boolean batched;
    public static final String JSON_PROPERTY_AUTH = "auth";
    @Nullable
    private Object auth;
    public static final String JSON_PROPERTY_HEADERS = "headers";
    @Nullable
    private List<Object> headers = new ArrayList<Object>();

    public CreateWebhook url(@Nonnull String url) {
        this.url = url;
        return this;
    }

    @Nonnull
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUrl(@Nonnull String url) {
        this.url = url;
    }

    public CreateWebhook description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public CreateWebhook events(@Nonnull List<EventsEnum> events) {
        this.events = events;
        return this;
    }

    public CreateWebhook addEventsItem(EventsEnum eventsItem) {
        if (this.events == null) {
            this.events = new ArrayList<EventsEnum>();
        }
        this.events.add(eventsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="events")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<EventsEnum> getEvents() {
        return this.events;
    }

    @JsonProperty(value="events")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEvents(@Nonnull List<EventsEnum> events) {
        this.events = events;
    }

    public CreateWebhook type(@Nullable TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(@Nullable TypeEnum type) {
        this.type = type;
    }

    public CreateWebhook channel(@Nullable ChannelEnum channel) {
        this.channel = channel;
        return this;
    }

    @Nullable
    @JsonProperty(value="channel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChannelEnum getChannel() {
        return this.channel;
    }

    @JsonProperty(value="channel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChannel(@Nullable ChannelEnum channel) {
        this.channel = channel;
    }

    public CreateWebhook domain(@Nullable String domain) {
        this.domain = domain;
        return this;
    }

    @Nullable
    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomain(@Nullable String domain) {
        this.domain = domain;
    }

    public CreateWebhook batched(@Nullable Boolean batched) {
        this.batched = batched;
        return this;
    }

    @Nullable
    @JsonProperty(value="batched")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getBatched() {
        return this.batched;
    }

    @JsonProperty(value="batched")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBatched(@Nullable Boolean batched) {
        this.batched = batched;
    }

    public CreateWebhook auth(@Nullable Object auth) {
        this.auth = auth;
        return this;
    }

    @Nullable
    @JsonProperty(value="auth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getAuth() {
        return this.auth;
    }

    @JsonProperty(value="auth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuth(@Nullable Object auth) {
        this.auth = auth;
    }

    public CreateWebhook headers(@Nullable List<Object> headers) {
        this.headers = headers;
        return this;
    }

    public CreateWebhook addHeadersItem(Object headersItem) {
        if (this.headers == null) {
            this.headers = new ArrayList<Object>();
        }
        this.headers.add(headersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Object> getHeaders() {
        return this.headers;
    }

    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHeaders(@Nullable List<Object> headers) {
        this.headers = headers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateWebhook createWebhook = (CreateWebhook)o;
        return Objects.equals(this.url, createWebhook.url) && Objects.equals(this.description, createWebhook.description) && Objects.equals(this.events, createWebhook.events) && Objects.equals((Object)this.type, (Object)createWebhook.type) && Objects.equals((Object)this.channel, (Object)createWebhook.channel) && Objects.equals(this.domain, createWebhook.domain) && Objects.equals(this.batched, createWebhook.batched) && Objects.equals(this.auth, createWebhook.auth) && Objects.equals(this.headers, createWebhook.headers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.url, this.description, this.events, this.type, this.channel, this.domain, this.batched, this.auth, this.headers});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateWebhook {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    channel: ").append(this.toIndentedString((Object)this.channel)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    batched: ").append(this.toIndentedString(this.batched)).append("\n");
        sb.append("    auth: ").append(this.toIndentedString(this.auth)).append("\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getUrl() != null) {
            try {
                joiner.add(String.format("%surl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUrl()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDescription() != null) {
            try {
                joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDescription()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getEvents() != null) {
            for (i = 0; i < this.getEvents().size(); ++i) {
                try {
                    joiner.add(String.format("%sevents%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf((Object)this.getEvents().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getType() != null) {
            try {
                joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getChannel() != null) {
            try {
                joiner.add(String.format("%schannel%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getChannel()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDomain() != null) {
            try {
                joiner.add(String.format("%sdomain%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDomain()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getBatched() != null) {
            try {
                joiner.add(String.format("%sbatched%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getBatched()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getAuth() != null) {
            try {
                joiner.add(String.format("%sauth%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAuth()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getHeaders() != null) {
            for (i = 0; i < this.getHeaders().size(); ++i) {
                try {
                    joiner.add(String.format("%sheaders%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getHeaders().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }

    public static enum TypeEnum {
        TRANSACTIONAL(String.valueOf("transactional")),
        MARKETING(String.valueOf("marketing")),
        INBOUND(String.valueOf("inbound"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ChannelEnum {
        SMS(String.valueOf("sms")),
        EMAIL(String.valueOf("email"));

        private String value;

        private ChannelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ChannelEnum fromValue(String value) {
            for (ChannelEnum b : ChannelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum EventsEnum {
        SENT(String.valueOf("sent")),
        HARD_BOUNCE(String.valueOf("hardBounce")),
        SOFT_BOUNCE(String.valueOf("softBounce")),
        BLOCKED(String.valueOf("blocked")),
        SPAM(String.valueOf("spam")),
        DELIVERED(String.valueOf("delivered")),
        REQUEST(String.valueOf("request")),
        CLICK(String.valueOf("click")),
        INVALID(String.valueOf("invalid")),
        DEFERRED(String.valueOf("deferred")),
        OPENED(String.valueOf("opened")),
        UNIQUE_OPENED(String.valueOf("uniqueOpened")),
        UNSUBSCRIBED(String.valueOf("unsubscribed")),
        LIST_ADDITION(String.valueOf("listAddition")),
        CONTACT_UPDATED(String.valueOf("contactUpdated")),
        CONTACT_DELETED(String.valueOf("contactDeleted")),
        INBOUND_EMAIL_PROCESSED(String.valueOf("inboundEmailProcessed"));

        private String value;

        private EventsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EventsEnum fromValue(String value) {
            for (EventsEnum b : EventsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

