/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"name", "upgradeStrategy", "downgradeStrategy", "tierOrder"})
@JsonTypeName(value="createTierGroupRequest")
public class CreateTierGroupRequest {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_UPGRADE_STRATEGY = "upgradeStrategy";
    @Nullable
    private UpgradeStrategyEnum upgradeStrategy = UpgradeStrategyEnum.REAL_TIME;
    public static final String JSON_PROPERTY_DOWNGRADE_STRATEGY = "downgradeStrategy";
    @Nullable
    private DowngradeStrategyEnum downgradeStrategy = DowngradeStrategyEnum.REAL_TIME;
    public static final String JSON_PROPERTY_TIER_ORDER = "tierOrder";
    @Nullable
    private List<String> tierOrder = new ArrayList<String>();

    public CreateTierGroupRequest name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public CreateTierGroupRequest upgradeStrategy(@Nullable UpgradeStrategyEnum upgradeStrategy) {
        this.upgradeStrategy = upgradeStrategy;
        return this;
    }

    @Nullable
    @JsonProperty(value="upgradeStrategy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UpgradeStrategyEnum getUpgradeStrategy() {
        return this.upgradeStrategy;
    }

    @JsonProperty(value="upgradeStrategy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpgradeStrategy(@Nullable UpgradeStrategyEnum upgradeStrategy) {
        this.upgradeStrategy = upgradeStrategy;
    }

    public CreateTierGroupRequest downgradeStrategy(@Nullable DowngradeStrategyEnum downgradeStrategy) {
        this.downgradeStrategy = downgradeStrategy;
        return this;
    }

    @Nullable
    @JsonProperty(value="downgradeStrategy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DowngradeStrategyEnum getDowngradeStrategy() {
        return this.downgradeStrategy;
    }

    @JsonProperty(value="downgradeStrategy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDowngradeStrategy(@Nullable DowngradeStrategyEnum downgradeStrategy) {
        this.downgradeStrategy = downgradeStrategy;
    }

    public CreateTierGroupRequest tierOrder(@Nullable List<String> tierOrder) {
        this.tierOrder = tierOrder;
        return this;
    }

    public CreateTierGroupRequest addTierOrderItem(String tierOrderItem) {
        if (this.tierOrder == null) {
            this.tierOrder = new ArrayList<String>();
        }
        this.tierOrder.add(tierOrderItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tierOrder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTierOrder() {
        return this.tierOrder;
    }

    @JsonProperty(value="tierOrder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTierOrder(@Nullable List<String> tierOrder) {
        this.tierOrder = tierOrder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTierGroupRequest createTierGroupRequest = (CreateTierGroupRequest)o;
        return Objects.equals(this.name, createTierGroupRequest.name) && Objects.equals((Object)this.upgradeStrategy, (Object)createTierGroupRequest.upgradeStrategy) && Objects.equals((Object)this.downgradeStrategy, (Object)createTierGroupRequest.downgradeStrategy) && Objects.equals(this.tierOrder, createTierGroupRequest.tierOrder);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.upgradeStrategy, this.downgradeStrategy, this.tierOrder});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateTierGroupRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    upgradeStrategy: ").append(this.toIndentedString((Object)this.upgradeStrategy)).append("\n");
        sb.append("    downgradeStrategy: ").append(this.toIndentedString((Object)this.downgradeStrategy)).append("\n");
        sb.append("    tierOrder: ").append(this.toIndentedString(this.tierOrder)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            try {
                joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getUpgradeStrategy() != null) {
            try {
                joiner.add(String.format("%supgradeStrategy%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getUpgradeStrategy()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDowngradeStrategy() != null) {
            try {
                joiner.add(String.format("%sdowngradeStrategy%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getDowngradeStrategy()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getTierOrder() != null) {
            for (int i = 0; i < this.getTierOrder().size(); ++i) {
                try {
                    joiner.add(String.format("%stierOrder%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getTierOrder().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }

    public static enum UpgradeStrategyEnum {
        REAL_TIME(String.valueOf("real_time")),
        MEMBERSHIP_ANNIVERSARY(String.valueOf("membership_anniversary")),
        TIER_ANNIVERSARY(String.valueOf("tier_anniversary"));

        private String value;

        private UpgradeStrategyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static UpgradeStrategyEnum fromValue(String value) {
            for (UpgradeStrategyEnum b : UpgradeStrategyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum DowngradeStrategyEnum {
        REAL_TIME(String.valueOf("real_time")),
        MEMBERSHIP_ANNIVERSARY(String.valueOf("membership_anniversary")),
        TIER_ANNIVERSARY(String.valueOf("tier_anniversary"));

        private String value;

        private DowngradeStrategyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DowngradeStrategyEnum fromValue(String value) {
            for (DowngradeStrategyEnum b : DowngradeStrategyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

