/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import software.xdev.brevo.model.CreateSenderIpsInner;

@JsonPropertyOrder(value={"name", "email", "ips"})
@JsonTypeName(value="createSender")
public class CreateSender {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_EMAIL = "email";
    @Nonnull
    private String email;
    public static final String JSON_PROPERTY_IPS = "ips";
    @Nullable
    private List<CreateSenderIpsInner> ips = new ArrayList<CreateSenderIpsInner>();

    public CreateSender name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public CreateSender email(@Nonnull String email) {
        this.email = email;
        return this;
    }

    @Nonnull
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEmail(@Nonnull String email) {
        this.email = email;
    }

    public CreateSender ips(@Nullable List<CreateSenderIpsInner> ips) {
        this.ips = ips;
        return this;
    }

    public CreateSender addIpsItem(CreateSenderIpsInner ipsItem) {
        if (this.ips == null) {
            this.ips = new ArrayList<CreateSenderIpsInner>();
        }
        this.ips.add(ipsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="ips")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<CreateSenderIpsInner> getIps() {
        return this.ips;
    }

    @JsonProperty(value="ips")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIps(@Nullable List<CreateSenderIpsInner> ips) {
        this.ips = ips;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateSender createSender = (CreateSender)o;
        return Objects.equals(this.name, createSender.name) && Objects.equals(this.email, createSender.email) && Objects.equals(this.ips, createSender.ips);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.email, this.ips);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateSender {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    ips: ").append(this.toIndentedString(this.ips)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            try {
                joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getEmail() != null) {
            try {
                joiner.add(String.format("%semail%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEmail()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getIps() != null) {
            for (int i = 0; i < this.getIps().size(); ++i) {
                if (this.getIps().get(i) == null) continue;
                joiner.add(this.getIps().get(i).toUrlQueryString(String.format("%sips%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

