/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"amount", "balanceDefinitionId", "contactId", "dueAt", "expiresAt", "meta", "source"})
@JsonTypeName(value="createOrderPayload")
public class CreateOrderPayload {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    @Nonnull
    private BigDecimal amount;
    public static final String JSON_PROPERTY_BALANCE_DEFINITION_ID = "balanceDefinitionId";
    @Nonnull
    private String balanceDefinitionId;
    public static final String JSON_PROPERTY_CONTACT_ID = "contactId";
    @Nonnull
    private Integer contactId;
    public static final String JSON_PROPERTY_DUE_AT = "dueAt";
    @Nonnull
    private String dueAt;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    @Nullable
    private String expiresAt;
    public static final String JSON_PROPERTY_META = "meta";
    @Nullable
    private Map<String, Object> meta = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_SOURCE = "source";
    @Nonnull
    private String source;

    public CreateOrderPayload amount(@Nonnull BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmount(@Nonnull BigDecimal amount) {
        this.amount = amount;
    }

    public CreateOrderPayload balanceDefinitionId(@Nonnull String balanceDefinitionId) {
        this.balanceDefinitionId = balanceDefinitionId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="balanceDefinitionId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getBalanceDefinitionId() {
        return this.balanceDefinitionId;
    }

    @JsonProperty(value="balanceDefinitionId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBalanceDefinitionId(@Nonnull String balanceDefinitionId) {
        this.balanceDefinitionId = balanceDefinitionId;
    }

    public CreateOrderPayload contactId(@Nonnull Integer contactId) {
        this.contactId = contactId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="contactId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getContactId() {
        return this.contactId;
    }

    @JsonProperty(value="contactId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContactId(@Nonnull Integer contactId) {
        this.contactId = contactId;
    }

    public CreateOrderPayload dueAt(@Nonnull String dueAt) {
        this.dueAt = dueAt;
        return this;
    }

    @Nonnull
    @JsonProperty(value="dueAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDueAt() {
        return this.dueAt;
    }

    @JsonProperty(value="dueAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDueAt(@Nonnull String dueAt) {
        this.dueAt = dueAt;
    }

    public CreateOrderPayload expiresAt(@Nullable String expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiresAt(@Nullable String expiresAt) {
        this.expiresAt = expiresAt;
    }

    public CreateOrderPayload meta(@Nullable Map<String, Object> meta) {
        this.meta = meta;
        return this;
    }

    public CreateOrderPayload putMetaItem(String key, Object metaItem) {
        if (this.meta == null) {
            this.meta = new HashMap<String, Object>();
        }
        this.meta.put(key, metaItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="meta")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getMeta() {
        return this.meta;
    }

    @JsonProperty(value="meta")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setMeta(@Nullable Map<String, Object> meta) {
        this.meta = meta;
    }

    public CreateOrderPayload source(@Nonnull String source) {
        this.source = source;
        return this;
    }

    @Nonnull
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSource(@Nonnull String source) {
        this.source = source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateOrderPayload createOrderPayload = (CreateOrderPayload)o;
        return Objects.equals(this.amount, createOrderPayload.amount) && Objects.equals(this.balanceDefinitionId, createOrderPayload.balanceDefinitionId) && Objects.equals(this.contactId, createOrderPayload.contactId) && Objects.equals(this.dueAt, createOrderPayload.dueAt) && Objects.equals(this.expiresAt, createOrderPayload.expiresAt) && Objects.equals(this.meta, createOrderPayload.meta) && Objects.equals(this.source, createOrderPayload.source);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.balanceDefinitionId, this.contactId, this.dueAt, this.expiresAt, this.meta, this.source);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateOrderPayload {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    balanceDefinitionId: ").append(this.toIndentedString(this.balanceDefinitionId)).append("\n");
        sb.append("    contactId: ").append(this.toIndentedString(this.contactId)).append("\n");
        sb.append("    dueAt: ").append(this.toIndentedString(this.dueAt)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getAmount() != null) {
            try {
                joiner.add(String.format("%samount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAmount()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getBalanceDefinitionId() != null) {
            try {
                joiner.add(String.format("%sbalanceDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getBalanceDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getContactId() != null) {
            try {
                joiner.add(String.format("%scontactId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getContactId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDueAt() != null) {
            try {
                joiner.add(String.format("%sdueAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDueAt()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getExpiresAt() != null) {
            try {
                joiner.add(String.format("%sexpiresAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getExpiresAt()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getMeta() != null) {
            for (String _key : this.getMeta().keySet()) {
                try {
                    joiner.add(String.format("%smeta%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getMeta().get(_key), URLEncoder.encode(String.valueOf(this.getMeta().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getSource() != null) {
            try {
                joiner.add(String.format("%ssource%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSource()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

