/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"email", "attributes", "includeListIds", "excludeListIds", "templateId", "redirectionUrl"})
@JsonTypeName(value="createDoiContact")
public class CreateDoiContact {
    public static final String JSON_PROPERTY_EMAIL = "email";
    @Nonnull
    private String email;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    @Nullable
    private Map<String, Object> attributes = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_INCLUDE_LIST_IDS = "includeListIds";
    @Nonnull
    private List<Long> includeListIds = new ArrayList<Long>();
    public static final String JSON_PROPERTY_EXCLUDE_LIST_IDS = "excludeListIds";
    @Nullable
    private List<Long> excludeListIds = new ArrayList<Long>();
    public static final String JSON_PROPERTY_TEMPLATE_ID = "templateId";
    @Nonnull
    private Long templateId;
    public static final String JSON_PROPERTY_REDIRECTION_URL = "redirectionUrl";
    @Nonnull
    private String redirectionUrl;

    public CreateDoiContact email(@Nonnull String email) {
        this.email = email;
        return this;
    }

    @Nonnull
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEmail(@Nonnull String email) {
        this.email = email;
    }

    public CreateDoiContact attributes(@Nullable Map<String, Object> attributes) {
        this.attributes = attributes;
        return this;
    }

    public CreateDoiContact putAttributesItem(String key, Object attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttributes(@Nullable Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public CreateDoiContact includeListIds(@Nonnull List<Long> includeListIds) {
        this.includeListIds = includeListIds;
        return this;
    }

    public CreateDoiContact addIncludeListIdsItem(Long includeListIdsItem) {
        if (this.includeListIds == null) {
            this.includeListIds = new ArrayList<Long>();
        }
        this.includeListIds.add(includeListIdsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="includeListIds")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Long> getIncludeListIds() {
        return this.includeListIds;
    }

    @JsonProperty(value="includeListIds")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIncludeListIds(@Nonnull List<Long> includeListIds) {
        this.includeListIds = includeListIds;
    }

    public CreateDoiContact excludeListIds(@Nullable List<Long> excludeListIds) {
        this.excludeListIds = excludeListIds;
        return this;
    }

    public CreateDoiContact addExcludeListIdsItem(Long excludeListIdsItem) {
        if (this.excludeListIds == null) {
            this.excludeListIds = new ArrayList<Long>();
        }
        this.excludeListIds.add(excludeListIdsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="excludeListIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Long> getExcludeListIds() {
        return this.excludeListIds;
    }

    @JsonProperty(value="excludeListIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExcludeListIds(@Nullable List<Long> excludeListIds) {
        this.excludeListIds = excludeListIds;
    }

    public CreateDoiContact templateId(@Nonnull Long templateId) {
        this.templateId = templateId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="templateId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getTemplateId() {
        return this.templateId;
    }

    @JsonProperty(value="templateId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTemplateId(@Nonnull Long templateId) {
        this.templateId = templateId;
    }

    public CreateDoiContact redirectionUrl(@Nonnull String redirectionUrl) {
        this.redirectionUrl = redirectionUrl;
        return this;
    }

    @Nonnull
    @JsonProperty(value="redirectionUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRedirectionUrl() {
        return this.redirectionUrl;
    }

    @JsonProperty(value="redirectionUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRedirectionUrl(@Nonnull String redirectionUrl) {
        this.redirectionUrl = redirectionUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateDoiContact createDoiContact = (CreateDoiContact)o;
        return Objects.equals(this.email, createDoiContact.email) && Objects.equals(this.attributes, createDoiContact.attributes) && Objects.equals(this.includeListIds, createDoiContact.includeListIds) && Objects.equals(this.excludeListIds, createDoiContact.excludeListIds) && Objects.equals(this.templateId, createDoiContact.templateId) && Objects.equals(this.redirectionUrl, createDoiContact.redirectionUrl);
    }

    public int hashCode() {
        return Objects.hash(this.email, this.attributes, this.includeListIds, this.excludeListIds, this.templateId, this.redirectionUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateDoiContact {\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    includeListIds: ").append(this.toIndentedString(this.includeListIds)).append("\n");
        sb.append("    excludeListIds: ").append(this.toIndentedString(this.excludeListIds)).append("\n");
        sb.append("    templateId: ").append(this.toIndentedString(this.templateId)).append("\n");
        sb.append("    redirectionUrl: ").append(this.toIndentedString(this.redirectionUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getEmail() != null) {
            try {
                joiner.add(String.format("%semail%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEmail()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getAttributes() != null) {
            for (String _key : this.getAttributes().keySet()) {
                try {
                    joiner.add(String.format("%sattributes%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getAttributes().get(_key), URLEncoder.encode(String.valueOf(this.getAttributes().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getIncludeListIds() != null) {
            for (int i = 0; i < this.getIncludeListIds().size(); ++i) {
                try {
                    joiner.add(String.format("%sincludeListIds%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getIncludeListIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getExcludeListIds() != null) {
            for (int i = 0; i < this.getExcludeListIds().size(); ++i) {
                try {
                    joiner.add(String.format("%sexcludeListIds%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getExcludeListIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getTemplateId() != null) {
            try {
                joiner.add(String.format("%stemplateId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTemplateId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getRedirectionUrl() != null) {
            try {
                joiner.add(String.format("%sredirectionUrl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRedirectionUrl()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

