/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"name", "defaultCoupon", "expirationDate", "remainingDaysAlert", "remainingCouponsAlert"})
@JsonTypeName(value="createCouponCollection_request")
public class CreateCouponCollectionRequest {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_DEFAULT_COUPON = "defaultCoupon";
    @Nonnull
    private String defaultCoupon;
    public static final String JSON_PROPERTY_EXPIRATION_DATE = "expirationDate";
    @Nullable
    private OffsetDateTime expirationDate;
    public static final String JSON_PROPERTY_REMAINING_DAYS_ALERT = "remainingDaysAlert";
    @Nullable
    private Integer remainingDaysAlert;
    public static final String JSON_PROPERTY_REMAINING_COUPONS_ALERT = "remainingCouponsAlert";
    @Nullable
    private Integer remainingCouponsAlert;

    public CreateCouponCollectionRequest name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public CreateCouponCollectionRequest defaultCoupon(@Nonnull String defaultCoupon) {
        this.defaultCoupon = defaultCoupon;
        return this;
    }

    @Nonnull
    @JsonProperty(value="defaultCoupon")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDefaultCoupon() {
        return this.defaultCoupon;
    }

    @JsonProperty(value="defaultCoupon")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDefaultCoupon(@Nonnull String defaultCoupon) {
        this.defaultCoupon = defaultCoupon;
    }

    public CreateCouponCollectionRequest expirationDate(@Nullable OffsetDateTime expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="expirationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExpirationDate() {
        return this.expirationDate;
    }

    @JsonProperty(value="expirationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpirationDate(@Nullable OffsetDateTime expirationDate) {
        this.expirationDate = expirationDate;
    }

    public CreateCouponCollectionRequest remainingDaysAlert(@Nullable Integer remainingDaysAlert) {
        this.remainingDaysAlert = remainingDaysAlert;
        return this;
    }

    @Nullable
    @JsonProperty(value="remainingDaysAlert")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRemainingDaysAlert() {
        return this.remainingDaysAlert;
    }

    @JsonProperty(value="remainingDaysAlert")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRemainingDaysAlert(@Nullable Integer remainingDaysAlert) {
        this.remainingDaysAlert = remainingDaysAlert;
    }

    public CreateCouponCollectionRequest remainingCouponsAlert(@Nullable Integer remainingCouponsAlert) {
        this.remainingCouponsAlert = remainingCouponsAlert;
        return this;
    }

    @Nullable
    @JsonProperty(value="remainingCouponsAlert")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRemainingCouponsAlert() {
        return this.remainingCouponsAlert;
    }

    @JsonProperty(value="remainingCouponsAlert")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRemainingCouponsAlert(@Nullable Integer remainingCouponsAlert) {
        this.remainingCouponsAlert = remainingCouponsAlert;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateCouponCollectionRequest createCouponCollectionRequest = (CreateCouponCollectionRequest)o;
        return Objects.equals(this.name, createCouponCollectionRequest.name) && Objects.equals(this.defaultCoupon, createCouponCollectionRequest.defaultCoupon) && Objects.equals(this.expirationDate, createCouponCollectionRequest.expirationDate) && Objects.equals(this.remainingDaysAlert, createCouponCollectionRequest.remainingDaysAlert) && Objects.equals(this.remainingCouponsAlert, createCouponCollectionRequest.remainingCouponsAlert);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.defaultCoupon, this.expirationDate, this.remainingDaysAlert, this.remainingCouponsAlert);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateCouponCollectionRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    defaultCoupon: ").append(this.toIndentedString(this.defaultCoupon)).append("\n");
        sb.append("    expirationDate: ").append(this.toIndentedString(this.expirationDate)).append("\n");
        sb.append("    remainingDaysAlert: ").append(this.toIndentedString(this.remainingDaysAlert)).append("\n");
        sb.append("    remainingCouponsAlert: ").append(this.toIndentedString(this.remainingCouponsAlert)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            try {
                joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDefaultCoupon() != null) {
            try {
                joiner.add(String.format("%sdefaultCoupon%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDefaultCoupon()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getExpirationDate() != null) {
            try {
                joiner.add(String.format("%sexpirationDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getExpirationDate()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getRemainingDaysAlert() != null) {
            try {
                joiner.add(String.format("%sremainingDaysAlert%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRemainingDaysAlert()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getRemainingCouponsAlert() != null) {
            try {
                joiner.add(String.format("%sremainingCouponsAlert%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRemainingCouponsAlert()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

