/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"groupName", "subAccountIds"})
@JsonTypeName(value="_corporate_group__id__put_request")
public class CorporateGroupIdPutRequest {
    public static final String JSON_PROPERTY_GROUP_NAME = "groupName";
    @Nullable
    private String groupName;
    public static final String JSON_PROPERTY_SUB_ACCOUNT_IDS = "subAccountIds";
    @Nullable
    private List<Long> subAccountIds = new ArrayList<Long>();

    public CorporateGroupIdPutRequest groupName(@Nullable String groupName) {
        this.groupName = groupName;
        return this;
    }

    @Nullable
    @JsonProperty(value="groupName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGroupName() {
        return this.groupName;
    }

    @JsonProperty(value="groupName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroupName(@Nullable String groupName) {
        this.groupName = groupName;
    }

    public CorporateGroupIdPutRequest subAccountIds(@Nullable List<Long> subAccountIds) {
        this.subAccountIds = subAccountIds;
        return this;
    }

    public CorporateGroupIdPutRequest addSubAccountIdsItem(Long subAccountIdsItem) {
        if (this.subAccountIds == null) {
            this.subAccountIds = new ArrayList<Long>();
        }
        this.subAccountIds.add(subAccountIdsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="subAccountIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Long> getSubAccountIds() {
        return this.subAccountIds;
    }

    @JsonProperty(value="subAccountIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubAccountIds(@Nullable List<Long> subAccountIds) {
        this.subAccountIds = subAccountIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CorporateGroupIdPutRequest corporateGroupIdPutRequest = (CorporateGroupIdPutRequest)o;
        return Objects.equals(this.groupName, corporateGroupIdPutRequest.groupName) && Objects.equals(this.subAccountIds, corporateGroupIdPutRequest.subAccountIds);
    }

    public int hashCode() {
        return Objects.hash(this.groupName, this.subAccountIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CorporateGroupIdPutRequest {\n");
        sb.append("    groupName: ").append(this.toIndentedString(this.groupName)).append("\n");
        sb.append("    subAccountIds: ").append(this.toIndentedString(this.subAccountIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getGroupName() != null) {
            try {
                joiner.add(String.format("%sgroupName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getGroupName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getSubAccountIds() != null) {
            for (int i = 0; i < this.getSubAccountIds().size(); ++i) {
                try {
                    joiner.add(String.format("%ssubAccountIds%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getSubAccountIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }
}

