/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"id", "conversionSource", "ordersCount", "revenue", "averageBasket"})
public class ConversionSourceMetrics {
    public static final String JSON_PROPERTY_ID = "id";
    @Nonnull
    private String id;
    public static final String JSON_PROPERTY_CONVERSION_SOURCE = "conversionSource";
    @Nonnull
    private ConversionSourceEnum conversionSource;
    public static final String JSON_PROPERTY_ORDERS_COUNT = "ordersCount";
    @Nonnull
    private BigDecimal ordersCount;
    public static final String JSON_PROPERTY_REVENUE = "revenue";
    @Nonnull
    private Float revenue;
    public static final String JSON_PROPERTY_AVERAGE_BASKET = "averageBasket";
    @Nonnull
    private Float averageBasket;

    public ConversionSourceMetrics id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(@Nonnull String id) {
        this.id = id;
    }

    public ConversionSourceMetrics conversionSource(@Nonnull ConversionSourceEnum conversionSource) {
        this.conversionSource = conversionSource;
        return this;
    }

    @Nonnull
    @JsonProperty(value="conversionSource")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ConversionSourceEnum getConversionSource() {
        return this.conversionSource;
    }

    @JsonProperty(value="conversionSource")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setConversionSource(@Nonnull ConversionSourceEnum conversionSource) {
        this.conversionSource = conversionSource;
    }

    public ConversionSourceMetrics ordersCount(@Nonnull BigDecimal ordersCount) {
        this.ordersCount = ordersCount;
        return this;
    }

    @Nonnull
    @JsonProperty(value="ordersCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getOrdersCount() {
        return this.ordersCount;
    }

    @JsonProperty(value="ordersCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOrdersCount(@Nonnull BigDecimal ordersCount) {
        this.ordersCount = ordersCount;
    }

    public ConversionSourceMetrics revenue(@Nonnull Float revenue) {
        this.revenue = revenue;
        return this;
    }

    @Nonnull
    @JsonProperty(value="revenue")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Float getRevenue() {
        return this.revenue;
    }

    @JsonProperty(value="revenue")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRevenue(@Nonnull Float revenue) {
        this.revenue = revenue;
    }

    public ConversionSourceMetrics averageBasket(@Nonnull Float averageBasket) {
        this.averageBasket = averageBasket;
        return this;
    }

    @Nonnull
    @JsonProperty(value="averageBasket")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Float getAverageBasket() {
        return this.averageBasket;
    }

    @JsonProperty(value="averageBasket")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAverageBasket(@Nonnull Float averageBasket) {
        this.averageBasket = averageBasket;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversionSourceMetrics conversionSourceMetrics = (ConversionSourceMetrics)o;
        return Objects.equals(this.id, conversionSourceMetrics.id) && Objects.equals((Object)this.conversionSource, (Object)conversionSourceMetrics.conversionSource) && Objects.equals(this.ordersCount, conversionSourceMetrics.ordersCount) && Objects.equals(this.revenue, conversionSourceMetrics.revenue) && Objects.equals(this.averageBasket, conversionSourceMetrics.averageBasket);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.conversionSource, this.ordersCount, this.revenue, this.averageBasket});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversionSourceMetrics {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    conversionSource: ").append(this.toIndentedString((Object)this.conversionSource)).append("\n");
        sb.append("    ordersCount: ").append(this.toIndentedString(this.ordersCount)).append("\n");
        sb.append("    revenue: ").append(this.toIndentedString(this.revenue)).append("\n");
        sb.append("    averageBasket: ").append(this.toIndentedString(this.averageBasket)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            try {
                joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getConversionSource() != null) {
            try {
                joiner.add(String.format("%sconversionSource%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getConversionSource()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getOrdersCount() != null) {
            try {
                joiner.add(String.format("%sordersCount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getOrdersCount()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getRevenue() != null) {
            try {
                joiner.add(String.format("%srevenue%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRevenue()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getAverageBasket() != null) {
            try {
                joiner.add(String.format("%saverageBasket%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAverageBasket()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }

    public static enum ConversionSourceEnum {
        EMAIL_CAMPAIGN(String.valueOf("email_campaign")),
        SMS_CAMPAIGN(String.valueOf("sms_campaign")),
        AUTOMATION_WORKFLOW_EMAIL(String.valueOf("automation_workflow_email")),
        AUTOMATION_WORKFLOW_SMS(String.valueOf("automation_workflow_sms"));

        private String value;

        private ConversionSourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ConversionSourceEnum fromValue(String value) {
            for (ConversionSourceEnum b : ConversionSourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

