/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"name", "attributes", "countryCode", "linkedContactsIds", "linkedDealsIds"})
@JsonTypeName(value="_companies__id__patch_request")
public class CompaniesIdPatchRequest {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nullable
    private String name;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    @Nullable
    private Object attributes;
    public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
    @Nullable
    private Long countryCode;
    public static final String JSON_PROPERTY_LINKED_CONTACTS_IDS = "linkedContactsIds";
    @Nullable
    private List<Long> linkedContactsIds = new ArrayList<Long>();
    public static final String JSON_PROPERTY_LINKED_DEALS_IDS = "linkedDealsIds";
    @Nullable
    private List<String> linkedDealsIds = new ArrayList<String>();

    public CompaniesIdPatchRequest name(@Nullable String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(@Nullable String name) {
        this.name = name;
    }

    public CompaniesIdPatchRequest attributes(@Nullable Object attributes) {
        this.attributes = attributes;
        return this;
    }

    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttributes(@Nullable Object attributes) {
        this.attributes = attributes;
    }

    public CompaniesIdPatchRequest countryCode(@Nullable Long countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Nullable
    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getCountryCode() {
        return this.countryCode;
    }

    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountryCode(@Nullable Long countryCode) {
        this.countryCode = countryCode;
    }

    public CompaniesIdPatchRequest linkedContactsIds(@Nullable List<Long> linkedContactsIds) {
        this.linkedContactsIds = linkedContactsIds;
        return this;
    }

    public CompaniesIdPatchRequest addLinkedContactsIdsItem(Long linkedContactsIdsItem) {
        if (this.linkedContactsIds == null) {
            this.linkedContactsIds = new ArrayList<Long>();
        }
        this.linkedContactsIds.add(linkedContactsIdsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="linkedContactsIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Long> getLinkedContactsIds() {
        return this.linkedContactsIds;
    }

    @JsonProperty(value="linkedContactsIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinkedContactsIds(@Nullable List<Long> linkedContactsIds) {
        this.linkedContactsIds = linkedContactsIds;
    }

    public CompaniesIdPatchRequest linkedDealsIds(@Nullable List<String> linkedDealsIds) {
        this.linkedDealsIds = linkedDealsIds;
        return this;
    }

    public CompaniesIdPatchRequest addLinkedDealsIdsItem(String linkedDealsIdsItem) {
        if (this.linkedDealsIds == null) {
            this.linkedDealsIds = new ArrayList<String>();
        }
        this.linkedDealsIds.add(linkedDealsIdsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="linkedDealsIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getLinkedDealsIds() {
        return this.linkedDealsIds;
    }

    @JsonProperty(value="linkedDealsIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinkedDealsIds(@Nullable List<String> linkedDealsIds) {
        this.linkedDealsIds = linkedDealsIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompaniesIdPatchRequest companiesIdPatchRequest = (CompaniesIdPatchRequest)o;
        return Objects.equals(this.name, companiesIdPatchRequest.name) && Objects.equals(this.attributes, companiesIdPatchRequest.attributes) && Objects.equals(this.countryCode, companiesIdPatchRequest.countryCode) && Objects.equals(this.linkedContactsIds, companiesIdPatchRequest.linkedContactsIds) && Objects.equals(this.linkedDealsIds, companiesIdPatchRequest.linkedDealsIds);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.attributes, this.countryCode, this.linkedContactsIds, this.linkedDealsIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CompaniesIdPatchRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    linkedContactsIds: ").append(this.toIndentedString(this.linkedContactsIds)).append("\n");
        sb.append("    linkedDealsIds: ").append(this.toIndentedString(this.linkedDealsIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            try {
                joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getAttributes() != null) {
            try {
                joiner.add(String.format("%sattributes%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAttributes()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getCountryCode() != null) {
            try {
                joiner.add(String.format("%scountryCode%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCountryCode()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getLinkedContactsIds() != null) {
            for (i = 0; i < this.getLinkedContactsIds().size(); ++i) {
                try {
                    joiner.add(String.format("%slinkedContactsIds%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getLinkedContactsIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getLinkedDealsIds() != null) {
            for (i = 0; i < this.getLinkedDealsIds().size(); ++i) {
                try {
                    joiner.add(String.format("%slinkedDealsIds%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getLinkedDealsIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }
}

