/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"currency", "specificAmount"})
@JsonTypeName(value="cart")
public class Cart {
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    @Nonnull
    private CurrencyEnum currency;
    public static final String JSON_PROPERTY_SPECIFIC_AMOUNT = "specificAmount";
    @Nonnull
    private Long specificAmount;

    public Cart currency(@Nonnull CurrencyEnum currency) {
        this.currency = currency;
        return this;
    }

    @Nonnull
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CurrencyEnum getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCurrency(@Nonnull CurrencyEnum currency) {
        this.currency = currency;
    }

    public Cart specificAmount(@Nonnull Long specificAmount) {
        this.specificAmount = specificAmount;
        return this;
    }

    @Nonnull
    @JsonProperty(value="specificAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getSpecificAmount() {
        return this.specificAmount;
    }

    @JsonProperty(value="specificAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSpecificAmount(@Nonnull Long specificAmount) {
        this.specificAmount = specificAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cart cart = (Cart)o;
        return Objects.equals((Object)this.currency, (Object)cart.currency) && Objects.equals(this.specificAmount, cart.specificAmount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.currency, this.specificAmount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Cart {\n");
        sb.append("    currency: ").append(this.toIndentedString((Object)this.currency)).append("\n");
        sb.append("    specificAmount: ").append(this.toIndentedString(this.specificAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getCurrency() != null) {
            try {
                joiner.add(String.format("%scurrency%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getCurrency()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getSpecificAmount() != null) {
            try {
                joiner.add(String.format("%sspecificAmount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSpecificAmount()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }

    public static enum CurrencyEnum {
        EUR(String.valueOf("EUR"));

        private String value;

        private CurrencyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CurrencyEnum fromValue(String value) {
            for (CurrencyEnum b : CurrencyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

