/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.client;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collections;
import java.util.Map;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.Configuration;

public abstract class BaseApi {
    protected ApiClient apiClient;

    public BaseApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BaseApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void invokeAPI(String url, String method) throws ApiException {
        this.invokeAPI(url, method, null, null, Collections.emptyMap());
    }

    public void invokeAPI(String url, String method, Map<String, String> additionalHeaders) throws ApiException {
        this.invokeAPI(url, method, null, null, additionalHeaders);
    }

    public void invokeAPI(String url, String method, Object request) throws ApiException {
        this.invokeAPI(url, method, request, null, Collections.emptyMap());
    }

    public void invokeAPI(String url, String method, Object request, Map<String, String> additionalHeaders) throws ApiException {
        this.invokeAPI(url, method, request, null, additionalHeaders);
    }

    public <T> T invokeAPI(String url, String method, TypeReference<T> returnType) throws ApiException {
        return this.invokeAPI(url, method, null, returnType, Collections.emptyMap());
    }

    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType) throws ApiException {
        return this.invokeAPI(url, method, request, returnType, Collections.emptyMap());
    }

    public abstract <T> T invokeAPI(String var1, String var2, Object var3, TypeReference<T> var4, Map<String, String> var5) throws ApiException;
}

