/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;
import software.xdev.brevo.model.CreateModel;
import software.xdev.brevo.model.CreateWhatsAppCampaign;
import software.xdev.brevo.model.CreateWhatsAppTemplate;
import software.xdev.brevo.model.GetWhatsAppConfig;
import software.xdev.brevo.model.GetWhatsappCampaignOverview;
import software.xdev.brevo.model.GetWhatsappCampaigns;
import software.xdev.brevo.model.GetWhatsappTemplates;
import software.xdev.brevo.model.UpdateWhatsAppCampaign;

public class WhatsAppCampaignsApi
extends BaseApi {
    public WhatsAppCampaignsApi() {
        super(Configuration.getDefaultApiClient());
    }

    public WhatsAppCampaignsApi(ApiClient apiClient) {
        super(apiClient);
    }

    public CreateModel createWhatsAppCampaign(@Nonnull CreateWhatsAppCampaign createWhatsAppCampaign) throws ApiException {
        return this.createWhatsAppCampaign(createWhatsAppCampaign, Collections.emptyMap());
    }

    public CreateModel createWhatsAppCampaign(@Nonnull CreateWhatsAppCampaign createWhatsAppCampaign, Map<String, String> additionalHeaders) throws ApiException {
        CreateWhatsAppCampaign localVarPostBody = createWhatsAppCampaign;
        if (createWhatsAppCampaign == null) {
            throw new ApiException(400, "Missing the required parameter 'createWhatsAppCampaign' when calling createWhatsAppCampaign");
        }
        String localVarPath = "/whatsappCampaigns";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CreateModel> localVarReturnType = new TypeReference<CreateModel>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CreateModel createWhatsAppTemplate(@Nonnull CreateWhatsAppTemplate createWhatsAppTemplate) throws ApiException {
        return this.createWhatsAppTemplate(createWhatsAppTemplate, Collections.emptyMap());
    }

    public CreateModel createWhatsAppTemplate(@Nonnull CreateWhatsAppTemplate createWhatsAppTemplate, Map<String, String> additionalHeaders) throws ApiException {
        CreateWhatsAppTemplate localVarPostBody = createWhatsAppTemplate;
        if (createWhatsAppTemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'createWhatsAppTemplate' when calling createWhatsAppTemplate");
        }
        String localVarPath = "/whatsappCampaigns/template";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CreateModel> localVarReturnType = new TypeReference<CreateModel>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteWhatsAppCampaign(@Nonnull Long campaignId) throws ApiException {
        this.deleteWhatsAppCampaign(campaignId, Collections.emptyMap());
    }

    public void deleteWhatsAppCampaign(@Nonnull Long campaignId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (campaignId == null) {
            throw new ApiException(400, "Missing the required parameter 'campaignId' when calling deleteWhatsAppCampaign");
        }
        String localVarPath = "/whatsappCampaigns/{campaignId}".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(campaignId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public GetWhatsappCampaignOverview getWhatsAppCampaign(@Nonnull Long campaignId) throws ApiException {
        return this.getWhatsAppCampaign(campaignId, Collections.emptyMap());
    }

    public GetWhatsappCampaignOverview getWhatsAppCampaign(@Nonnull Long campaignId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (campaignId == null) {
            throw new ApiException(400, "Missing the required parameter 'campaignId' when calling getWhatsAppCampaign");
        }
        String localVarPath = "/whatsappCampaigns/{campaignId}".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(campaignId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetWhatsappCampaignOverview> localVarReturnType = new TypeReference<GetWhatsappCampaignOverview>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetWhatsappCampaigns getWhatsAppCampaigns(@Nullable String startDate, @Nullable String endDate, @Nullable Long limit, @Nullable Long offset, @Nullable String sort) throws ApiException {
        return this.getWhatsAppCampaigns(startDate, endDate, limit, offset, sort, Collections.emptyMap());
    }

    public GetWhatsappCampaigns getWhatsAppCampaigns(@Nullable String startDate, @Nullable String endDate, @Nullable Long limit, @Nullable Long offset, @Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/whatsappCampaigns";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetWhatsappCampaigns> localVarReturnType = new TypeReference<GetWhatsappCampaigns>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetWhatsAppConfig getWhatsAppConfig() throws ApiException {
        return this.getWhatsAppConfig(Collections.emptyMap());
    }

    public GetWhatsAppConfig getWhatsAppConfig(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/whatsappCampaigns/config";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetWhatsAppConfig> localVarReturnType = new TypeReference<GetWhatsAppConfig>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetWhatsappTemplates getWhatsAppTemplates(@Nullable String startDate, @Nullable String endDate, @Nullable Long limit, @Nullable Long offset, @Nullable String sort, @Nullable String source) throws ApiException {
        return this.getWhatsAppTemplates(startDate, endDate, limit, offset, sort, source, Collections.emptyMap());
    }

    public GetWhatsappTemplates getWhatsAppTemplates(@Nullable String startDate, @Nullable String endDate, @Nullable Long limit, @Nullable Long offset, @Nullable String sort, @Nullable String source, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/whatsappCampaigns/template-list";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("source", source));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetWhatsappTemplates> localVarReturnType = new TypeReference<GetWhatsappTemplates>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void sendWhatsAppTemplateApproval(@Nonnull Long templateId) throws ApiException {
        this.sendWhatsAppTemplateApproval(templateId, Collections.emptyMap());
    }

    public void sendWhatsAppTemplateApproval(@Nonnull Long templateId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling sendWhatsAppTemplateApproval");
        }
        String localVarPath = "/whatsappCampaigns/template/approval/{templateId}".replaceAll("\\{templateId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(templateId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void updateWhatsAppCampaign(@Nonnull Long campaignId, @Nonnull UpdateWhatsAppCampaign updateWhatsAppCampaign) throws ApiException {
        this.updateWhatsAppCampaign(campaignId, updateWhatsAppCampaign, Collections.emptyMap());
    }

    public void updateWhatsAppCampaign(@Nonnull Long campaignId, @Nonnull UpdateWhatsAppCampaign updateWhatsAppCampaign, Map<String, String> additionalHeaders) throws ApiException {
        UpdateWhatsAppCampaign localVarPostBody = updateWhatsAppCampaign;
        if (campaignId == null) {
            throw new ApiException(400, "Missing the required parameter 'campaignId' when calling updateWhatsAppCampaign");
        }
        if (updateWhatsAppCampaign == null) {
            throw new ApiException(400, "Missing the required parameter 'updateWhatsAppCampaign' when calling updateWhatsAppCampaign");
        }
        String localVarPath = "/whatsappCampaigns/{campaignId}".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(campaignId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

