/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;
import software.xdev.brevo.model.CreateModel;
import software.xdev.brevo.model.CreateWebhook;
import software.xdev.brevo.model.CreatedProcessId;
import software.xdev.brevo.model.ExportWebhooksHistory;
import software.xdev.brevo.model.GetWebhook;
import software.xdev.brevo.model.GetWebhooks;
import software.xdev.brevo.model.UpdateWebhook;

public class WebhooksApi
extends BaseApi {
    public WebhooksApi() {
        super(Configuration.getDefaultApiClient());
    }

    public WebhooksApi(ApiClient apiClient) {
        super(apiClient);
    }

    public CreateModel createWebhook(@Nonnull CreateWebhook createWebhook) throws ApiException {
        return this.createWebhook(createWebhook, Collections.emptyMap());
    }

    public CreateModel createWebhook(@Nonnull CreateWebhook createWebhook, Map<String, String> additionalHeaders) throws ApiException {
        CreateWebhook localVarPostBody = createWebhook;
        if (createWebhook == null) {
            throw new ApiException(400, "Missing the required parameter 'createWebhook' when calling createWebhook");
        }
        String localVarPath = "/webhooks";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CreateModel> localVarReturnType = new TypeReference<CreateModel>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteWebhook(@Nonnull Long webhookId) throws ApiException {
        this.deleteWebhook(webhookId, Collections.emptyMap());
    }

    public void deleteWebhook(@Nonnull Long webhookId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (webhookId == null) {
            throw new ApiException(400, "Missing the required parameter 'webhookId' when calling deleteWebhook");
        }
        String localVarPath = "/webhooks/{webhookId}".replaceAll("\\{webhookId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(webhookId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public CreatedProcessId exportWebhooksHistory(@Nonnull ExportWebhooksHistory exportWebhooksHistory) throws ApiException {
        return this.exportWebhooksHistory(exportWebhooksHistory, Collections.emptyMap());
    }

    public CreatedProcessId exportWebhooksHistory(@Nonnull ExportWebhooksHistory exportWebhooksHistory, Map<String, String> additionalHeaders) throws ApiException {
        ExportWebhooksHistory localVarPostBody = exportWebhooksHistory;
        if (exportWebhooksHistory == null) {
            throw new ApiException(400, "Missing the required parameter 'exportWebhooksHistory' when calling exportWebhooksHistory");
        }
        String localVarPath = "/webhooks/export";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CreatedProcessId> localVarReturnType = new TypeReference<CreatedProcessId>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetWebhook getWebhook(@Nonnull Long webhookId) throws ApiException {
        return this.getWebhook(webhookId, Collections.emptyMap());
    }

    public GetWebhook getWebhook(@Nonnull Long webhookId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (webhookId == null) {
            throw new ApiException(400, "Missing the required parameter 'webhookId' when calling getWebhook");
        }
        String localVarPath = "/webhooks/{webhookId}".replaceAll("\\{webhookId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(webhookId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetWebhook> localVarReturnType = new TypeReference<GetWebhook>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetWebhooks getWebhooks(@Nullable String type, @Nullable String sort) throws ApiException {
        return this.getWebhooks(type, sort, Collections.emptyMap());
    }

    public GetWebhooks getWebhooks(@Nullable String type, @Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/webhooks";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetWebhooks> localVarReturnType = new TypeReference<GetWebhooks>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void updateWebhook(@Nonnull Long webhookId, @Nonnull UpdateWebhook updateWebhook) throws ApiException {
        this.updateWebhook(webhookId, updateWebhook, Collections.emptyMap());
    }

    public void updateWebhook(@Nonnull Long webhookId, @Nonnull UpdateWebhook updateWebhook, Map<String, String> additionalHeaders) throws ApiException {
        UpdateWebhook localVarPostBody = updateWebhook;
        if (webhookId == null) {
            throw new ApiException(400, "Missing the required parameter 'webhookId' when calling updateWebhook");
        }
        if (updateWebhook == null) {
            throw new ApiException(400, "Missing the required parameter 'updateWebhook' when calling updateWebhook");
        }
        String localVarPath = "/webhooks/{webhookId}".replaceAll("\\{webhookId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(webhookId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

