/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;
import software.xdev.brevo.model.BlockDomain;
import software.xdev.brevo.model.CreateModel;
import software.xdev.brevo.model.CreateSmtpEmail;
import software.xdev.brevo.model.CreateSmtpTemplate;
import software.xdev.brevo.model.DeleteHardbounces;
import software.xdev.brevo.model.GetAggregatedReport;
import software.xdev.brevo.model.GetBlockedDomains;
import software.xdev.brevo.model.GetEmailEventReport;
import software.xdev.brevo.model.GetReports;
import software.xdev.brevo.model.GetScheduledEmailById200Response;
import software.xdev.brevo.model.GetSmtpTemplateOverview;
import software.xdev.brevo.model.GetSmtpTemplates;
import software.xdev.brevo.model.GetTransacBlockedContacts;
import software.xdev.brevo.model.GetTransacEmailContent;
import software.xdev.brevo.model.GetTransacEmailsList;
import software.xdev.brevo.model.SendSmtpEmail;
import software.xdev.brevo.model.SendTestEmail;
import software.xdev.brevo.model.TemplatePreviewModel;
import software.xdev.brevo.model.TemplatePreviewRequestBody;
import software.xdev.brevo.model.UpdateSmtpTemplate;

public class TransactionalEmailsApi
extends BaseApi {
    public TransactionalEmailsApi() {
        super(Configuration.getDefaultApiClient());
    }

    public TransactionalEmailsApi(ApiClient apiClient) {
        super(apiClient);
    }

    public void blockNewDomain(@Nonnull BlockDomain blockDomain) throws ApiException {
        this.blockNewDomain(blockDomain, Collections.emptyMap());
    }

    public void blockNewDomain(@Nonnull BlockDomain blockDomain, Map<String, String> additionalHeaders) throws ApiException {
        BlockDomain localVarPostBody = blockDomain;
        if (blockDomain == null) {
            throw new ApiException(400, "Missing the required parameter 'blockDomain' when calling blockNewDomain");
        }
        String localVarPath = "/smtp/blockedDomains";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public CreateModel createSmtpTemplate(@Nonnull CreateSmtpTemplate createSmtpTemplate) throws ApiException {
        return this.createSmtpTemplate(createSmtpTemplate, Collections.emptyMap());
    }

    public CreateModel createSmtpTemplate(@Nonnull CreateSmtpTemplate createSmtpTemplate, Map<String, String> additionalHeaders) throws ApiException {
        CreateSmtpTemplate localVarPostBody = createSmtpTemplate;
        if (createSmtpTemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'createSmtpTemplate' when calling createSmtpTemplate");
        }
        String localVarPath = "/smtp/templates";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CreateModel> localVarReturnType = new TypeReference<CreateModel>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteBlockedDomain(@Nonnull String domain) throws ApiException {
        this.deleteBlockedDomain(domain, Collections.emptyMap());
    }

    public void deleteBlockedDomain(@Nonnull String domain, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (domain == null) {
            throw new ApiException(400, "Missing the required parameter 'domain' when calling deleteBlockedDomain");
        }
        String localVarPath = "/smtp/blockedDomains/{domain}".replaceAll("\\{domain\\}", this.apiClient.escapeString(this.apiClient.parameterToString(domain)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteHardbounces(@Nullable DeleteHardbounces deleteHardbounces) throws ApiException {
        this.deleteHardbounces(deleteHardbounces, Collections.emptyMap());
    }

    public void deleteHardbounces(@Nullable DeleteHardbounces deleteHardbounces, Map<String, String> additionalHeaders) throws ApiException {
        DeleteHardbounces localVarPostBody = deleteHardbounces;
        String localVarPath = "/smtp/deleteHardbounces";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteScheduledEmailById(@Nonnull String identifier) throws ApiException {
        this.deleteScheduledEmailById(identifier, Collections.emptyMap());
    }

    public void deleteScheduledEmailById(@Nonnull String identifier, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (identifier == null) {
            throw new ApiException(400, "Missing the required parameter 'identifier' when calling deleteScheduledEmailById");
        }
        String localVarPath = "/smtp/email/{identifier}".replaceAll("\\{identifier\\}", this.apiClient.escapeString(this.apiClient.parameterToString(identifier)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteSmtpTemplate(@Nonnull Long templateId) throws ApiException {
        this.deleteSmtpTemplate(templateId, Collections.emptyMap());
    }

    public void deleteSmtpTemplate(@Nonnull Long templateId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling deleteSmtpTemplate");
        }
        String localVarPath = "/smtp/templates/{templateId}".replaceAll("\\{templateId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(templateId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public GetAggregatedReport getAggregatedSmtpReport(@Nullable String startDate, @Nullable String endDate, @Nullable Long days, @Nullable String tag) throws ApiException {
        return this.getAggregatedSmtpReport(startDate, endDate, days, tag, Collections.emptyMap());
    }

    public GetAggregatedReport getAggregatedSmtpReport(@Nullable String startDate, @Nullable String endDate, @Nullable Long days, @Nullable String tag, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/smtp/statistics/aggregatedReport";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("days", days));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tag", tag));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetAggregatedReport> localVarReturnType = new TypeReference<GetAggregatedReport>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetBlockedDomains getBlockedDomains() throws ApiException {
        return this.getBlockedDomains(Collections.emptyMap());
    }

    public GetBlockedDomains getBlockedDomains(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/smtp/blockedDomains";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetBlockedDomains> localVarReturnType = new TypeReference<GetBlockedDomains>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetEmailEventReport getEmailEventReport(@Nullable Long limit, @Nullable Long offset, @Nullable String startDate, @Nullable String endDate, @Nullable Long days, @Nullable String email, @Nullable String event, @Nullable String tags, @Nullable String messageId, @Nullable Long templateId, @Nullable String sort) throws ApiException {
        return this.getEmailEventReport(limit, offset, startDate, endDate, days, email, event, tags, messageId, templateId, sort, Collections.emptyMap());
    }

    public GetEmailEventReport getEmailEventReport(@Nullable Long limit, @Nullable Long offset, @Nullable String startDate, @Nullable String endDate, @Nullable Long days, @Nullable String email, @Nullable String event, @Nullable String tags, @Nullable String messageId, @Nullable Long templateId, @Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/smtp/statistics/events";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("days", days));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("email", email));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("event", event));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tags", tags));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("messageId", messageId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("templateId", templateId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetEmailEventReport> localVarReturnType = new TypeReference<GetEmailEventReport>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetScheduledEmailById200Response getScheduledEmailById(@Nonnull String identifier, @Nullable LocalDate startDate, @Nullable LocalDate endDate, @Nullable String sort, @Nullable String status, @Nullable Long limit, @Nullable Long offset) throws ApiException {
        return this.getScheduledEmailById(identifier, startDate, endDate, sort, status, limit, offset, Collections.emptyMap());
    }

    public GetScheduledEmailById200Response getScheduledEmailById(@Nonnull String identifier, @Nullable LocalDate startDate, @Nullable LocalDate endDate, @Nullable String sort, @Nullable String status, @Nullable Long limit, @Nullable Long offset, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (identifier == null) {
            throw new ApiException(400, "Missing the required parameter 'identifier' when calling getScheduledEmailById");
        }
        String localVarPath = "/smtp/emailStatus/{identifier}".replaceAll("\\{identifier\\}", this.apiClient.escapeString(this.apiClient.parameterToString(identifier)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("status", status));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetScheduledEmailById200Response> localVarReturnType = new TypeReference<GetScheduledEmailById200Response>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetReports getSmtpReport(@Nullable Long limit, @Nullable Long offset, @Nullable String startDate, @Nullable String endDate, @Nullable Long days, @Nullable String tag, @Nullable String sort) throws ApiException {
        return this.getSmtpReport(limit, offset, startDate, endDate, days, tag, sort, Collections.emptyMap());
    }

    public GetReports getSmtpReport(@Nullable Long limit, @Nullable Long offset, @Nullable String startDate, @Nullable String endDate, @Nullable Long days, @Nullable String tag, @Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/smtp/statistics/reports";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("days", days));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tag", tag));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetReports> localVarReturnType = new TypeReference<GetReports>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetSmtpTemplateOverview getSmtpTemplate(@Nonnull Long templateId) throws ApiException {
        return this.getSmtpTemplate(templateId, Collections.emptyMap());
    }

    public GetSmtpTemplateOverview getSmtpTemplate(@Nonnull Long templateId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling getSmtpTemplate");
        }
        String localVarPath = "/smtp/templates/{templateId}".replaceAll("\\{templateId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(templateId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetSmtpTemplateOverview> localVarReturnType = new TypeReference<GetSmtpTemplateOverview>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetSmtpTemplates getSmtpTemplates(@Nullable Boolean templateStatus, @Nullable Long limit, @Nullable Long offset, @Nullable String sort) throws ApiException {
        return this.getSmtpTemplates(templateStatus, limit, offset, sort, Collections.emptyMap());
    }

    public GetSmtpTemplates getSmtpTemplates(@Nullable Boolean templateStatus, @Nullable Long limit, @Nullable Long offset, @Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/smtp/templates";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("templateStatus", templateStatus));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetSmtpTemplates> localVarReturnType = new TypeReference<GetSmtpTemplates>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetTransacBlockedContacts getTransacBlockedContacts(@Nullable String startDate, @Nullable String endDate, @Nullable Long limit, @Nullable Long offset, @Nullable List<String> senders, @Nullable String sort) throws ApiException {
        return this.getTransacBlockedContacts(startDate, endDate, limit, offset, senders, sort, Collections.emptyMap());
    }

    public GetTransacBlockedContacts getTransacBlockedContacts(@Nullable String startDate, @Nullable String endDate, @Nullable Long limit, @Nullable Long offset, @Nullable List<String> senders, @Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/smtp/blockedContacts";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "senders", senders));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetTransacBlockedContacts> localVarReturnType = new TypeReference<GetTransacBlockedContacts>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetTransacEmailContent getTransacEmailContent(@Nonnull String uuid) throws ApiException {
        return this.getTransacEmailContent(uuid, Collections.emptyMap());
    }

    public GetTransacEmailContent getTransacEmailContent(@Nonnull String uuid, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new ApiException(400, "Missing the required parameter 'uuid' when calling getTransacEmailContent");
        }
        String localVarPath = "/smtp/emails/{uuid}".replaceAll("\\{uuid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(uuid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetTransacEmailContent> localVarReturnType = new TypeReference<GetTransacEmailContent>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetTransacEmailsList getTransacEmailsList(@Nullable String email, @Nullable Long templateId, @Nullable String messageId, @Nullable String startDate, @Nullable String endDate, @Nullable String sort, @Nullable Long limit, @Nullable Long offset) throws ApiException {
        return this.getTransacEmailsList(email, templateId, messageId, startDate, endDate, sort, limit, offset, Collections.emptyMap());
    }

    public GetTransacEmailsList getTransacEmailsList(@Nullable String email, @Nullable Long templateId, @Nullable String messageId, @Nullable String startDate, @Nullable String endDate, @Nullable String sort, @Nullable Long limit, @Nullable Long offset, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/smtp/emails";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("email", email));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("templateId", templateId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("messageId", messageId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetTransacEmailsList> localVarReturnType = new TypeReference<GetTransacEmailsList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void sendTestTemplate(@Nonnull Long templateId, @Nonnull SendTestEmail sendTestEmail) throws ApiException {
        this.sendTestTemplate(templateId, sendTestEmail, Collections.emptyMap());
    }

    public void sendTestTemplate(@Nonnull Long templateId, @Nonnull SendTestEmail sendTestEmail, Map<String, String> additionalHeaders) throws ApiException {
        SendTestEmail localVarPostBody = sendTestEmail;
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling sendTestTemplate");
        }
        if (sendTestEmail == null) {
            throw new ApiException(400, "Missing the required parameter 'sendTestEmail' when calling sendTestTemplate");
        }
        String localVarPath = "/smtp/templates/{templateId}/sendTest".replaceAll("\\{templateId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(templateId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public CreateSmtpEmail sendTransacEmail(@Nonnull SendSmtpEmail sendSmtpEmail) throws ApiException {
        return this.sendTransacEmail(sendSmtpEmail, Collections.emptyMap());
    }

    public CreateSmtpEmail sendTransacEmail(@Nonnull SendSmtpEmail sendSmtpEmail, Map<String, String> additionalHeaders) throws ApiException {
        SendSmtpEmail localVarPostBody = sendSmtpEmail;
        if (sendSmtpEmail == null) {
            throw new ApiException(400, "Missing the required parameter 'sendSmtpEmail' when calling sendTransacEmail");
        }
        String localVarPath = "/smtp/email";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CreateSmtpEmail> localVarReturnType = new TypeReference<CreateSmtpEmail>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void smtpBlockedContactsEmailDelete(@Nonnull String email) throws ApiException {
        this.smtpBlockedContactsEmailDelete(email, Collections.emptyMap());
    }

    public void smtpBlockedContactsEmailDelete(@Nonnull String email, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (email == null) {
            throw new ApiException(400, "Missing the required parameter 'email' when calling smtpBlockedContactsEmailDelete");
        }
        String localVarPath = "/smtp/blockedContacts/{email}".replaceAll("\\{email\\}", this.apiClient.escapeString(this.apiClient.parameterToString(email)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void smtpLogIdentifierDelete(@Nonnull String identifier) throws ApiException {
        this.smtpLogIdentifierDelete(identifier, Collections.emptyMap());
    }

    public void smtpLogIdentifierDelete(@Nonnull String identifier, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (identifier == null) {
            throw new ApiException(400, "Missing the required parameter 'identifier' when calling smtpLogIdentifierDelete");
        }
        String localVarPath = "/smtp/log/{identifier}".replaceAll("\\{identifier\\}", this.apiClient.escapeString(this.apiClient.parameterToString(identifier)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public TemplatePreviewModel templatePreview(@Nullable TemplatePreviewRequestBody templatePreviewRequestBody) throws ApiException {
        return this.templatePreview(templatePreviewRequestBody, Collections.emptyMap());
    }

    public TemplatePreviewModel templatePreview(@Nullable TemplatePreviewRequestBody templatePreviewRequestBody, Map<String, String> additionalHeaders) throws ApiException {
        TemplatePreviewRequestBody localVarPostBody = templatePreviewRequestBody;
        if (templatePreviewRequestBody == null) {
            throw new ApiException(400, "Missing the required parameter 'templatePreviewRequestBody' when calling templatePreview");
        }
        String localVarPath = "/smtp/template/preview";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<TemplatePreviewModel> localVarReturnType = new TypeReference<TemplatePreviewModel>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void updateSmtpTemplate(@Nonnull Long templateId, @Nonnull UpdateSmtpTemplate updateSmtpTemplate) throws ApiException {
        this.updateSmtpTemplate(templateId, updateSmtpTemplate, Collections.emptyMap());
    }

    public void updateSmtpTemplate(@Nonnull Long templateId, @Nonnull UpdateSmtpTemplate updateSmtpTemplate, Map<String, String> additionalHeaders) throws ApiException {
        UpdateSmtpTemplate localVarPostBody = updateSmtpTemplate;
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling updateSmtpTemplate");
        }
        if (updateSmtpTemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'updateSmtpTemplate' when calling updateSmtpTemplate");
        }
        String localVarPath = "/smtp/templates/{templateId}".replaceAll("\\{templateId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(templateId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

