/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.UUID;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;
import software.xdev.brevo.model.CreateTierGroupRequest;
import software.xdev.brevo.model.LoyaltyTierPage;
import software.xdev.brevo.model.Tier;
import software.xdev.brevo.model.TierForContact;
import software.xdev.brevo.model.TierGroup;
import software.xdev.brevo.model.TierGroupPage;
import software.xdev.brevo.model.TierRequest;
import software.xdev.brevo.model.TierRequestPutPayload;
import software.xdev.brevo.model.UpdateTierGroupRequest;

public class TierApi
extends BaseApi {
    public TierApi() {
        super(Configuration.getDefaultApiClient());
    }

    public TierApi(ApiClient apiClient) {
        super(apiClient);
    }

    public TierForContact addSubscriptionToTier(@Nonnull UUID pid, @Nonnull UUID cid, @Nonnull UUID tid) throws ApiException {
        return this.addSubscriptionToTier(pid, cid, tid, Collections.emptyMap());
    }

    public TierForContact addSubscriptionToTier(@Nonnull UUID pid, @Nonnull UUID cid, @Nonnull UUID tid, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling addSubscriptionToTier");
        }
        if (cid == null) {
            throw new ApiException(400, "Missing the required parameter 'cid' when calling addSubscriptionToTier");
        }
        if (tid == null) {
            throw new ApiException(400, "Missing the required parameter 'tid' when calling addSubscriptionToTier");
        }
        String localVarPath = "/loyalty/tier/programs/{pid}/contacts/{cid}/tiers/{tid}".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid))).replaceAll("\\{cid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(cid))).replaceAll("\\{tid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(tid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<TierForContact> localVarReturnType = new TypeReference<TierForContact>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Tier createTierForTierGroup(@Nonnull UUID pid, @Nonnull UUID gid, @Nonnull TierRequest tierRequest) throws ApiException {
        return this.createTierForTierGroup(pid, gid, tierRequest, Collections.emptyMap());
    }

    public Tier createTierForTierGroup(@Nonnull UUID pid, @Nonnull UUID gid, @Nonnull TierRequest tierRequest, Map<String, String> additionalHeaders) throws ApiException {
        TierRequest localVarPostBody = tierRequest;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling createTierForTierGroup");
        }
        if (gid == null) {
            throw new ApiException(400, "Missing the required parameter 'gid' when calling createTierForTierGroup");
        }
        if (tierRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'tierRequest' when calling createTierForTierGroup");
        }
        String localVarPath = "/loyalty/tier/programs/{pid}/tier-groups/{gid}/tiers".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid))).replaceAll("\\{gid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(gid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<Tier> localVarReturnType = new TypeReference<Tier>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public TierGroup createTierGroup(@Nonnull UUID pid, @Nonnull CreateTierGroupRequest createTierGroupRequest) throws ApiException {
        return this.createTierGroup(pid, createTierGroupRequest, Collections.emptyMap());
    }

    public TierGroup createTierGroup(@Nonnull UUID pid, @Nonnull CreateTierGroupRequest createTierGroupRequest, Map<String, String> additionalHeaders) throws ApiException {
        CreateTierGroupRequest localVarPostBody = createTierGroupRequest;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling createTierGroup");
        }
        if (createTierGroupRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'createTierGroupRequest' when calling createTierGroup");
        }
        String localVarPath = "/loyalty/tier/programs/{pid}/tier-groups".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<TierGroup> localVarReturnType = new TypeReference<TierGroup>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public String deleteTier(@Nonnull UUID pid, @Nonnull UUID tid) throws ApiException {
        return this.deleteTier(pid, tid, Collections.emptyMap());
    }

    public String deleteTier(@Nonnull UUID pid, @Nonnull UUID tid, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling deleteTier");
        }
        if (tid == null) {
            throw new ApiException(400, "Missing the required parameter 'tid' when calling deleteTier");
        }
        String localVarPath = "/loyalty/tier/programs/{pid}/tiers/{tid}".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid))).replaceAll("\\{tid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(tid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<String> localVarReturnType = new TypeReference<String>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public String deleteTierGroup(@Nonnull UUID pid, @Nonnull UUID gid) throws ApiException {
        return this.deleteTierGroup(pid, gid, Collections.emptyMap());
    }

    public String deleteTierGroup(@Nonnull UUID pid, @Nonnull UUID gid, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling deleteTierGroup");
        }
        if (gid == null) {
            throw new ApiException(400, "Missing the required parameter 'gid' when calling deleteTierGroup");
        }
        String localVarPath = "/loyalty/tier/programs/{pid}/tier-groups/{gid}".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid))).replaceAll("\\{gid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(gid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"aplication/json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<String> localVarReturnType = new TypeReference<String>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public TierGroupPage getListOfTierGroups(@Nonnull UUID pid, @Nullable String version) throws ApiException {
        return this.getListOfTierGroups(pid, version, Collections.emptyMap());
    }

    public TierGroupPage getListOfTierGroups(@Nonnull UUID pid, @Nullable String version, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling getListOfTierGroups");
        }
        String localVarPath = "/loyalty/tier/programs/{pid}/tier-groups".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("version", version));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<TierGroupPage> localVarReturnType = new TypeReference<TierGroupPage>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public LoyaltyTierPage getLoyaltyProgramTier(@Nonnull UUID pid, @Nullable String version) throws ApiException {
        return this.getLoyaltyProgramTier(pid, version, Collections.emptyMap());
    }

    public LoyaltyTierPage getLoyaltyProgramTier(@Nonnull UUID pid, @Nullable String version, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling getLoyaltyProgramTier");
        }
        String localVarPath = "/loyalty/tier/programs/{pid}/tiers".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("version", version));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<LoyaltyTierPage> localVarReturnType = new TypeReference<LoyaltyTierPage>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public TierGroup getTierGroup(@Nonnull UUID pid, @Nonnull UUID gid, @Nullable String version) throws ApiException {
        return this.getTierGroup(pid, gid, version, Collections.emptyMap());
    }

    public TierGroup getTierGroup(@Nonnull UUID pid, @Nonnull UUID gid, @Nullable String version, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling getTierGroup");
        }
        if (gid == null) {
            throw new ApiException(400, "Missing the required parameter 'gid' when calling getTierGroup");
        }
        String localVarPath = "/loyalty/tier/programs/{pid}/tier-groups/{gid}".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid))).replaceAll("\\{gid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(gid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("version", version));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<TierGroup> localVarReturnType = new TypeReference<TierGroup>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Tier updateTier(@Nonnull UUID pid, @Nonnull UUID tid, @Nonnull TierRequestPutPayload tierRequestPutPayload) throws ApiException {
        return this.updateTier(pid, tid, tierRequestPutPayload, Collections.emptyMap());
    }

    public Tier updateTier(@Nonnull UUID pid, @Nonnull UUID tid, @Nonnull TierRequestPutPayload tierRequestPutPayload, Map<String, String> additionalHeaders) throws ApiException {
        TierRequestPutPayload localVarPostBody = tierRequestPutPayload;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling updateTier");
        }
        if (tid == null) {
            throw new ApiException(400, "Missing the required parameter 'tid' when calling updateTier");
        }
        if (tierRequestPutPayload == null) {
            throw new ApiException(400, "Missing the required parameter 'tierRequestPutPayload' when calling updateTier");
        }
        String localVarPath = "/loyalty/tier/programs/{pid}/tiers/{tid}".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid))).replaceAll("\\{tid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(tid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<Tier> localVarReturnType = new TypeReference<Tier>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public TierGroup updateTierGroup(@Nonnull UUID pid, @Nonnull UUID gid, @Nonnull UpdateTierGroupRequest updateTierGroupRequest) throws ApiException {
        return this.updateTierGroup(pid, gid, updateTierGroupRequest, Collections.emptyMap());
    }

    public TierGroup updateTierGroup(@Nonnull UUID pid, @Nonnull UUID gid, @Nonnull UpdateTierGroupRequest updateTierGroupRequest, Map<String, String> additionalHeaders) throws ApiException {
        UpdateTierGroupRequest localVarPostBody = updateTierGroupRequest;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling updateTierGroup");
        }
        if (gid == null) {
            throw new ApiException(400, "Missing the required parameter 'gid' when calling updateTierGroup");
        }
        if (updateTierGroupRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateTierGroupRequest' when calling updateTierGroup");
        }
        String localVarPath = "/loyalty/tier/programs/{pid}/tier-groups/{gid}".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid))).replaceAll("\\{gid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(gid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<TierGroup> localVarReturnType = new TypeReference<TierGroup>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

