/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;
import software.xdev.brevo.model.CrmTasksIdPatchRequest;
import software.xdev.brevo.model.CrmTasksPost201Response;
import software.xdev.brevo.model.CrmTasksPostRequest;
import software.xdev.brevo.model.Task;
import software.xdev.brevo.model.TaskList;
import software.xdev.brevo.model.TaskTypes;

public class TasksApi
extends BaseApi {
    public TasksApi() {
        super(Configuration.getDefaultApiClient());
    }

    public TasksApi(ApiClient apiClient) {
        super(apiClient);
    }

    public TaskList crmTasksGet(@Nullable String filterType, @Nullable String filterStatus, @Nullable String filterDate, @Nullable String filterAssignTo, @Nullable String filterContacts, @Nullable String filterDeals, @Nullable String filterCompanies, @Nullable Integer dateFrom, @Nullable Integer dateTo, @Nullable Long offset, @Nullable Long limit, @Nullable String sort, @Nullable String sortBy) throws ApiException {
        return this.crmTasksGet(filterType, filterStatus, filterDate, filterAssignTo, filterContacts, filterDeals, filterCompanies, dateFrom, dateTo, offset, limit, sort, sortBy, Collections.emptyMap());
    }

    public TaskList crmTasksGet(@Nullable String filterType, @Nullable String filterStatus, @Nullable String filterDate, @Nullable String filterAssignTo, @Nullable String filterContacts, @Nullable String filterDeals, @Nullable String filterCompanies, @Nullable Integer dateFrom, @Nullable Integer dateTo, @Nullable Long offset, @Nullable Long limit, @Nullable String sort, @Nullable String sortBy, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/crm/tasks";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("filter[type]", filterType));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("filter[status]", filterStatus));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("filter[date]", filterDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("filter[assignTo]", filterAssignTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("filter[contacts]", filterContacts));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("filter[deals]", filterDeals));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("filter[companies]", filterCompanies));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("dateFrom", dateFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("dateTo", dateTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<TaskList> localVarReturnType = new TypeReference<TaskList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void crmTasksIdDelete(@Nonnull String id) throws ApiException {
        this.crmTasksIdDelete(id, Collections.emptyMap());
    }

    public void crmTasksIdDelete(@Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling crmTasksIdDelete");
        }
        String localVarPath = "/crm/tasks/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public Task crmTasksIdGet(@Nonnull String id) throws ApiException {
        return this.crmTasksIdGet(id, Collections.emptyMap());
    }

    public Task crmTasksIdGet(@Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling crmTasksIdGet");
        }
        String localVarPath = "/crm/tasks/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<Task> localVarReturnType = new TypeReference<Task>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void crmTasksIdPatch(@Nonnull String id, @Nonnull CrmTasksIdPatchRequest crmTasksIdPatchRequest) throws ApiException {
        this.crmTasksIdPatch(id, crmTasksIdPatchRequest, Collections.emptyMap());
    }

    public void crmTasksIdPatch(@Nonnull String id, @Nonnull CrmTasksIdPatchRequest crmTasksIdPatchRequest, Map<String, String> additionalHeaders) throws ApiException {
        CrmTasksIdPatchRequest localVarPostBody = crmTasksIdPatchRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling crmTasksIdPatch");
        }
        if (crmTasksIdPatchRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'crmTasksIdPatchRequest' when calling crmTasksIdPatch");
        }
        String localVarPath = "/crm/tasks/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public CrmTasksPost201Response crmTasksPost(@Nonnull CrmTasksPostRequest crmTasksPostRequest) throws ApiException {
        return this.crmTasksPost(crmTasksPostRequest, Collections.emptyMap());
    }

    public CrmTasksPost201Response crmTasksPost(@Nonnull CrmTasksPostRequest crmTasksPostRequest, Map<String, String> additionalHeaders) throws ApiException {
        CrmTasksPostRequest localVarPostBody = crmTasksPostRequest;
        if (crmTasksPostRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'crmTasksPostRequest' when calling crmTasksPost");
        }
        String localVarPath = "/crm/tasks";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CrmTasksPost201Response> localVarReturnType = new TypeReference<CrmTasksPost201Response>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public TaskTypes crmTasktypesGet() throws ApiException {
        return this.crmTasktypesGet(Collections.emptyMap());
    }

    public TaskTypes crmTasktypesGet(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/crm/tasktypes";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<TaskTypes> localVarReturnType = new TypeReference<TaskTypes>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

