/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;
import software.xdev.brevo.model.CreateModel;
import software.xdev.brevo.model.CreateSmsCampaign;
import software.xdev.brevo.model.CreatedProcessId;
import software.xdev.brevo.model.GetSmsCampaign;
import software.xdev.brevo.model.GetSmsCampaigns;
import software.xdev.brevo.model.RequestSmsRecipientExport;
import software.xdev.brevo.model.SendReport;
import software.xdev.brevo.model.SendTestSms;
import software.xdev.brevo.model.UpdateCampaignStatus;
import software.xdev.brevo.model.UpdateSmsCampaign;

public class SmsCampaignsApi
extends BaseApi {
    public SmsCampaignsApi() {
        super(Configuration.getDefaultApiClient());
    }

    public SmsCampaignsApi(ApiClient apiClient) {
        super(apiClient);
    }

    public CreateModel createSmsCampaign(@Nonnull CreateSmsCampaign createSmsCampaign) throws ApiException {
        return this.createSmsCampaign(createSmsCampaign, Collections.emptyMap());
    }

    public CreateModel createSmsCampaign(@Nonnull CreateSmsCampaign createSmsCampaign, Map<String, String> additionalHeaders) throws ApiException {
        CreateSmsCampaign localVarPostBody = createSmsCampaign;
        if (createSmsCampaign == null) {
            throw new ApiException(400, "Missing the required parameter 'createSmsCampaign' when calling createSmsCampaign");
        }
        String localVarPath = "/smsCampaigns";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CreateModel> localVarReturnType = new TypeReference<CreateModel>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteSmsCampaign(@Nonnull Long campaignId) throws ApiException {
        this.deleteSmsCampaign(campaignId, Collections.emptyMap());
    }

    public void deleteSmsCampaign(@Nonnull Long campaignId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (campaignId == null) {
            throw new ApiException(400, "Missing the required parameter 'campaignId' when calling deleteSmsCampaign");
        }
        String localVarPath = "/smsCampaigns/{campaignId}".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(campaignId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public GetSmsCampaign getSmsCampaign(@Nonnull Long campaignId) throws ApiException {
        return this.getSmsCampaign(campaignId, Collections.emptyMap());
    }

    public GetSmsCampaign getSmsCampaign(@Nonnull Long campaignId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (campaignId == null) {
            throw new ApiException(400, "Missing the required parameter 'campaignId' when calling getSmsCampaign");
        }
        String localVarPath = "/smsCampaigns/{campaignId}".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(campaignId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetSmsCampaign> localVarReturnType = new TypeReference<GetSmsCampaign>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetSmsCampaigns getSmsCampaigns(@Nullable String status, @Nullable String startDate, @Nullable String endDate, @Nullable Long limit, @Nullable Long offset, @Nullable String sort) throws ApiException {
        return this.getSmsCampaigns(status, startDate, endDate, limit, offset, sort, Collections.emptyMap());
    }

    public GetSmsCampaigns getSmsCampaigns(@Nullable String status, @Nullable String startDate, @Nullable String endDate, @Nullable Long limit, @Nullable Long offset, @Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/smsCampaigns";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("status", status));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetSmsCampaigns> localVarReturnType = new TypeReference<GetSmsCampaigns>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CreatedProcessId requestSmsRecipientExport(@Nonnull Long campaignId, @Nullable RequestSmsRecipientExport recipientExport) throws ApiException {
        return this.requestSmsRecipientExport(campaignId, recipientExport, Collections.emptyMap());
    }

    public CreatedProcessId requestSmsRecipientExport(@Nonnull Long campaignId, @Nullable RequestSmsRecipientExport recipientExport, Map<String, String> additionalHeaders) throws ApiException {
        RequestSmsRecipientExport localVarPostBody = recipientExport;
        if (campaignId == null) {
            throw new ApiException(400, "Missing the required parameter 'campaignId' when calling requestSmsRecipientExport");
        }
        String localVarPath = "/smsCampaigns/{campaignId}/exportRecipients".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(campaignId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CreatedProcessId> localVarReturnType = new TypeReference<CreatedProcessId>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void sendSmsCampaignNow(@Nonnull Long campaignId) throws ApiException {
        this.sendSmsCampaignNow(campaignId, Collections.emptyMap());
    }

    public void sendSmsCampaignNow(@Nonnull Long campaignId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (campaignId == null) {
            throw new ApiException(400, "Missing the required parameter 'campaignId' when calling sendSmsCampaignNow");
        }
        String localVarPath = "/smsCampaigns/{campaignId}/sendNow".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(campaignId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void sendSmsReport(@Nonnull Long campaignId, @Nonnull SendReport sendReport) throws ApiException {
        this.sendSmsReport(campaignId, sendReport, Collections.emptyMap());
    }

    public void sendSmsReport(@Nonnull Long campaignId, @Nonnull SendReport sendReport, Map<String, String> additionalHeaders) throws ApiException {
        SendReport localVarPostBody = sendReport;
        if (campaignId == null) {
            throw new ApiException(400, "Missing the required parameter 'campaignId' when calling sendSmsReport");
        }
        if (sendReport == null) {
            throw new ApiException(400, "Missing the required parameter 'sendReport' when calling sendSmsReport");
        }
        String localVarPath = "/smsCampaigns/{campaignId}/sendReport".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(campaignId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void sendTestSms(@Nonnull Long campaignId, @Nonnull SendTestSms sendTestSms) throws ApiException {
        this.sendTestSms(campaignId, sendTestSms, Collections.emptyMap());
    }

    public void sendTestSms(@Nonnull Long campaignId, @Nonnull SendTestSms sendTestSms, Map<String, String> additionalHeaders) throws ApiException {
        SendTestSms localVarPostBody = sendTestSms;
        if (campaignId == null) {
            throw new ApiException(400, "Missing the required parameter 'campaignId' when calling sendTestSms");
        }
        if (sendTestSms == null) {
            throw new ApiException(400, "Missing the required parameter 'sendTestSms' when calling sendTestSms");
        }
        String localVarPath = "/smsCampaigns/{campaignId}/sendTest".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(campaignId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void updateSmsCampaign(@Nonnull Long campaignId, @Nonnull UpdateSmsCampaign updateSmsCampaign) throws ApiException {
        this.updateSmsCampaign(campaignId, updateSmsCampaign, Collections.emptyMap());
    }

    public void updateSmsCampaign(@Nonnull Long campaignId, @Nonnull UpdateSmsCampaign updateSmsCampaign, Map<String, String> additionalHeaders) throws ApiException {
        UpdateSmsCampaign localVarPostBody = updateSmsCampaign;
        if (campaignId == null) {
            throw new ApiException(400, "Missing the required parameter 'campaignId' when calling updateSmsCampaign");
        }
        if (updateSmsCampaign == null) {
            throw new ApiException(400, "Missing the required parameter 'updateSmsCampaign' when calling updateSmsCampaign");
        }
        String localVarPath = "/smsCampaigns/{campaignId}".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(campaignId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void updateSmsCampaignStatus(@Nonnull Long campaignId, @Nonnull UpdateCampaignStatus status) throws ApiException {
        this.updateSmsCampaignStatus(campaignId, status, Collections.emptyMap());
    }

    public void updateSmsCampaignStatus(@Nonnull Long campaignId, @Nonnull UpdateCampaignStatus status, Map<String, String> additionalHeaders) throws ApiException {
        UpdateCampaignStatus localVarPostBody = status;
        if (campaignId == null) {
            throw new ApiException(400, "Missing the required parameter 'campaignId' when calling updateSmsCampaignStatus");
        }
        if (status == null) {
            throw new ApiException(400, "Missing the required parameter 'status' when calling updateSmsCampaignStatus");
        }
        String localVarPath = "/smsCampaigns/{campaignId}/status".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(campaignId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

