/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.UUID;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;
import software.xdev.brevo.model.MainAttributeRewardPayload;
import software.xdev.brevo.model.MainCodeCountHttpResponse;
import software.xdev.brevo.model.MainCreateRedeemPayload;
import software.xdev.brevo.model.MainCreateRewardPayload;
import software.xdev.brevo.model.MainCreateRewardResponse;
import software.xdev.brevo.model.MainModelContactRewardsResp;
import software.xdev.brevo.model.MainRedeem;
import software.xdev.brevo.model.MainReward;
import software.xdev.brevo.model.MainRewardAttribution;
import software.xdev.brevo.model.MainRewardPage;
import software.xdev.brevo.model.MainRewardValidate;
import software.xdev.brevo.model.MainValidateRewardPayload;

public class RewardApi
extends BaseApi {
    public RewardApi() {
        super(Configuration.getDefaultApiClient());
    }

    public RewardApi(ApiClient apiClient) {
        super(apiClient);
    }

    public MainRedeem completeRedeemTransaction(@Nonnull UUID pid, @Nonnull String tid) throws ApiException {
        return this.completeRedeemTransaction(pid, tid, Collections.emptyMap());
    }

    public MainRedeem completeRedeemTransaction(@Nonnull UUID pid, @Nonnull String tid, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling completeRedeemTransaction");
        }
        if (tid == null) {
            throw new ApiException(400, "Missing the required parameter 'tid' when calling completeRedeemTransaction");
        }
        String localVarPath = "/loyalty/offer/programs/{pid}/rewards/redeem/{tid}/complete".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid))).replaceAll("\\{tid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(tid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<MainRedeem> localVarReturnType = new TypeReference<MainRedeem>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MainCreateRewardResponse createReward(@Nonnull UUID pid, @Nonnull MainCreateRewardPayload mainCreateRewardPayload) throws ApiException {
        return this.createReward(pid, mainCreateRewardPayload, Collections.emptyMap());
    }

    public MainCreateRewardResponse createReward(@Nonnull UUID pid, @Nonnull MainCreateRewardPayload mainCreateRewardPayload, Map<String, String> additionalHeaders) throws ApiException {
        MainCreateRewardPayload localVarPostBody = mainCreateRewardPayload;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling createReward");
        }
        if (mainCreateRewardPayload == null) {
            throw new ApiException(400, "Missing the required parameter 'mainCreateRewardPayload' when calling createReward");
        }
        String localVarPath = "/loyalty/offer/programs/{pid}/offers".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<MainCreateRewardResponse> localVarReturnType = new TypeReference<MainCreateRewardResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MainRewardAttribution createVoucher(@Nonnull UUID pid, @Nonnull MainAttributeRewardPayload mainAttributeRewardPayload) throws ApiException {
        return this.createVoucher(pid, mainAttributeRewardPayload, Collections.emptyMap());
    }

    public MainRewardAttribution createVoucher(@Nonnull UUID pid, @Nonnull MainAttributeRewardPayload mainAttributeRewardPayload, Map<String, String> additionalHeaders) throws ApiException {
        MainAttributeRewardPayload localVarPostBody = mainAttributeRewardPayload;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling createVoucher");
        }
        if (mainAttributeRewardPayload == null) {
            throw new ApiException(400, "Missing the required parameter 'mainAttributeRewardPayload' when calling createVoucher");
        }
        String localVarPath = "/loyalty/offer/programs/{pid}/rewards/attribute".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<MainRewardAttribution> localVarReturnType = new TypeReference<MainRewardAttribution>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MainCodeCountHttpResponse getCodeCount(@Nonnull UUID pid, @Nonnull UUID cpid) throws ApiException {
        return this.getCodeCount(pid, cpid, Collections.emptyMap());
    }

    public MainCodeCountHttpResponse getCodeCount(@Nonnull UUID pid, @Nonnull UUID cpid, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling getCodeCount");
        }
        if (cpid == null) {
            throw new ApiException(400, "Missing the required parameter 'cpid' when calling getCodeCount");
        }
        String localVarPath = "/loyalty/offer/programs/{pid}/code-pools/{cpid}/codes-count".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid))).replaceAll("\\{cpid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(cpid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<MainCodeCountHttpResponse> localVarReturnType = new TypeReference<MainCodeCountHttpResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MainRewardPage loyaltyOfferProgramsPidOffersGet(@Nonnull UUID pid, @Nullable Integer limit, @Nullable Integer offset, @Nullable String state, @Nullable String version) throws ApiException {
        return this.loyaltyOfferProgramsPidOffersGet(pid, limit, offset, state, version, Collections.emptyMap());
    }

    public MainRewardPage loyaltyOfferProgramsPidOffersGet(@Nonnull UUID pid, @Nullable Integer limit, @Nullable Integer offset, @Nullable String state, @Nullable String version, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling loyaltyOfferProgramsPidOffersGet");
        }
        String localVarPath = "/loyalty/offer/programs/{pid}/offers".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("state", state));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("version", version));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<MainRewardPage> localVarReturnType = new TypeReference<MainRewardPage>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MainReward loyaltyOfferProgramsPidRewardsRidGet(@Nonnull UUID pid, @Nonnull UUID rid, @Nullable String version) throws ApiException {
        return this.loyaltyOfferProgramsPidRewardsRidGet(pid, rid, version, Collections.emptyMap());
    }

    public MainReward loyaltyOfferProgramsPidRewardsRidGet(@Nonnull UUID pid, @Nonnull UUID rid, @Nullable String version, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling loyaltyOfferProgramsPidRewardsRidGet");
        }
        if (rid == null) {
            throw new ApiException(400, "Missing the required parameter 'rid' when calling loyaltyOfferProgramsPidRewardsRidGet");
        }
        String localVarPath = "/loyalty/offer/programs/{pid}/rewards/{rid}".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid))).replaceAll("\\{rid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(rid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("version", version));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<MainReward> localVarReturnType = new TypeReference<MainReward>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MainModelContactRewardsResp loyaltyOfferProgramsPidVouchersGet(@Nonnull UUID pid, @Nonnull Integer contactId, @Nullable Integer limit, @Nullable Integer offset, @Nullable String sort, @Nullable String sortField, @Nullable String metadataKeyValue, @Nullable String rewardId) throws ApiException {
        return this.loyaltyOfferProgramsPidVouchersGet(pid, contactId, limit, offset, sort, sortField, metadataKeyValue, rewardId, Collections.emptyMap());
    }

    public MainModelContactRewardsResp loyaltyOfferProgramsPidVouchersGet(@Nonnull UUID pid, @Nonnull Integer contactId, @Nullable Integer limit, @Nullable Integer offset, @Nullable String sort, @Nullable String sortField, @Nullable String metadataKeyValue, @Nullable String rewardId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling loyaltyOfferProgramsPidVouchersGet");
        }
        if (contactId == null) {
            throw new ApiException(400, "Missing the required parameter 'contactId' when calling loyaltyOfferProgramsPidVouchersGet");
        }
        String localVarPath = "/loyalty/offer/programs/{pid}/vouchers".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortField", sortField));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("contactId", contactId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("metadata_key_value", metadataKeyValue));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("rewardId", rewardId));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<MainModelContactRewardsResp> localVarReturnType = new TypeReference<MainModelContactRewardsResp>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MainRedeem redeemVoucher(@Nonnull UUID pid, @Nonnull MainCreateRedeemPayload mainCreateRedeemPayload) throws ApiException {
        return this.redeemVoucher(pid, mainCreateRedeemPayload, Collections.emptyMap());
    }

    public MainRedeem redeemVoucher(@Nonnull UUID pid, @Nonnull MainCreateRedeemPayload mainCreateRedeemPayload, Map<String, String> additionalHeaders) throws ApiException {
        MainCreateRedeemPayload localVarPostBody = mainCreateRedeemPayload;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling redeemVoucher");
        }
        if (mainCreateRedeemPayload == null) {
            throw new ApiException(400, "Missing the required parameter 'mainCreateRedeemPayload' when calling redeemVoucher");
        }
        String localVarPath = "/loyalty/offer/programs/{pid}/rewards/redeem".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<MainRedeem> localVarReturnType = new TypeReference<MainRedeem>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void revokeVouchers(@Nonnull UUID pid, @Nullable String attributedRewardIds) throws ApiException {
        this.revokeVouchers(pid, attributedRewardIds, Collections.emptyMap());
    }

    public void revokeVouchers(@Nonnull UUID pid, @Nullable String attributedRewardIds, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling revokeVouchers");
        }
        String localVarPath = "/loyalty/offer/programs/{pid}/rewards/revoke".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("attributedRewardIds", attributedRewardIds));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public MainRewardValidate validateReward(@Nonnull UUID pid, @Nonnull MainValidateRewardPayload mainValidateRewardPayload) throws ApiException {
        return this.validateReward(pid, mainValidateRewardPayload, Collections.emptyMap());
    }

    public MainRewardValidate validateReward(@Nonnull UUID pid, @Nonnull MainValidateRewardPayload mainValidateRewardPayload, Map<String, String> additionalHeaders) throws ApiException {
        MainValidateRewardPayload localVarPostBody = mainValidateRewardPayload;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling validateReward");
        }
        if (mainValidateRewardPayload == null) {
            throw new ApiException(400, "Missing the required parameter 'mainValidateRewardPayload' when calling validateReward");
        }
        String localVarPath = "/loyalty/offer/programs/{pid}/rewards/validate".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<MainRewardValidate> localVarReturnType = new TypeReference<MainRewardValidate>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

