/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.UUID;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;
import software.xdev.brevo.model.AddSubscriptionMemberPayload;
import software.xdev.brevo.model.CreateLoyaltyProgramPayload;
import software.xdev.brevo.model.CreateSubscriptionPayload;
import software.xdev.brevo.model.LoyaltyProgram;
import software.xdev.brevo.model.LoyaltyProgramPage;
import software.xdev.brevo.model.PatchLoyaltyProgramPayload;
import software.xdev.brevo.model.Subscription;
import software.xdev.brevo.model.SubscriptionHandlerInfo;
import software.xdev.brevo.model.SubscriptionMember;
import software.xdev.brevo.model.UpdateLoyaltyProgramPayload;

public class ProgramApi
extends BaseApi {
    public ProgramApi() {
        super(Configuration.getDefaultApiClient());
    }

    public ProgramApi(ApiClient apiClient) {
        super(apiClient);
    }

    public LoyaltyProgram createNewLP(@Nonnull CreateLoyaltyProgramPayload createLoyaltyProgramPayload) throws ApiException {
        return this.createNewLP(createLoyaltyProgramPayload, Collections.emptyMap());
    }

    public LoyaltyProgram createNewLP(@Nonnull CreateLoyaltyProgramPayload createLoyaltyProgramPayload, Map<String, String> additionalHeaders) throws ApiException {
        CreateLoyaltyProgramPayload localVarPostBody = createLoyaltyProgramPayload;
        if (createLoyaltyProgramPayload == null) {
            throw new ApiException(400, "Missing the required parameter 'createLoyaltyProgramPayload' when calling createNewLP");
        }
        String localVarPath = "/loyalty/config/programs";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<LoyaltyProgram> localVarReturnType = new TypeReference<LoyaltyProgram>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteContactMembers(@Nonnull UUID pid, @Nonnull String memberContactIds) throws ApiException {
        this.deleteContactMembers(pid, memberContactIds, Collections.emptyMap());
    }

    public void deleteContactMembers(@Nonnull UUID pid, @Nonnull String memberContactIds, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling deleteContactMembers");
        }
        if (memberContactIds == null) {
            throw new ApiException(400, "Missing the required parameter 'memberContactIds' when calling deleteContactMembers");
        }
        String localVarPath = "/loyalty/config/programs/{pid}/subscription-members".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("memberContactIds", memberContactIds));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteLoyaltyProgram(@Nonnull UUID pid) throws ApiException {
        this.deleteLoyaltyProgram(pid, Collections.emptyMap());
    }

    public void deleteLoyaltyProgram(@Nonnull UUID pid, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling deleteLoyaltyProgram");
        }
        String localVarPath = "/loyalty/config/programs/{pid}".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public LoyaltyProgramPage getLPList(@Nullable Integer limit, @Nullable Integer offset, @Nullable String sortField, @Nullable String sort) throws ApiException {
        return this.getLPList(limit, offset, sortField, sort, Collections.emptyMap());
    }

    public LoyaltyProgramPage getLPList(@Nullable Integer limit, @Nullable Integer offset, @Nullable String sortField, @Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/loyalty/config/programs";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort_field", sortField));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<LoyaltyProgramPage> localVarReturnType = new TypeReference<LoyaltyProgramPage>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public LoyaltyProgram getLoyaltyProgramInfo(@Nonnull UUID pid) throws ApiException {
        return this.getLoyaltyProgramInfo(pid, Collections.emptyMap());
    }

    public LoyaltyProgram getLoyaltyProgramInfo(@Nonnull UUID pid, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling getLoyaltyProgramInfo");
        }
        String localVarPath = "/loyalty/config/programs/{pid}".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<LoyaltyProgram> localVarReturnType = new TypeReference<LoyaltyProgram>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SubscriptionHandlerInfo getParameterSubscriptionInfo(@Nonnull UUID pid, @Nullable String contactId, @Nullable String params, @Nullable String loyaltySubscriptionId) throws ApiException {
        return this.getParameterSubscriptionInfo(pid, contactId, params, loyaltySubscriptionId, Collections.emptyMap());
    }

    public SubscriptionHandlerInfo getParameterSubscriptionInfo(@Nonnull UUID pid, @Nullable String contactId, @Nullable String params, @Nullable String loyaltySubscriptionId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling getParameterSubscriptionInfo");
        }
        String localVarPath = "/loyalty/config/programs/{pid}/account-info".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("contactId", contactId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("params", params));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("loyaltySubscriptionId", loyaltySubscriptionId));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<SubscriptionHandlerInfo> localVarReturnType = new TypeReference<SubscriptionHandlerInfo>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public LoyaltyProgram partiallyUpdateLoyaltyProgram(@Nonnull UUID pid, @Nonnull PatchLoyaltyProgramPayload patchLoyaltyProgramPayload) throws ApiException {
        return this.partiallyUpdateLoyaltyProgram(pid, patchLoyaltyProgramPayload, Collections.emptyMap());
    }

    public LoyaltyProgram partiallyUpdateLoyaltyProgram(@Nonnull UUID pid, @Nonnull PatchLoyaltyProgramPayload patchLoyaltyProgramPayload, Map<String, String> additionalHeaders) throws ApiException {
        PatchLoyaltyProgramPayload localVarPostBody = patchLoyaltyProgramPayload;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling partiallyUpdateLoyaltyProgram");
        }
        if (patchLoyaltyProgramPayload == null) {
            throw new ApiException(400, "Missing the required parameter 'patchLoyaltyProgramPayload' when calling partiallyUpdateLoyaltyProgram");
        }
        String localVarPath = "/loyalty/config/programs/{pid}".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<LoyaltyProgram> localVarReturnType = new TypeReference<LoyaltyProgram>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void publishLoyaltyProgram(@Nonnull UUID pid) throws ApiException {
        this.publishLoyaltyProgram(pid, Collections.emptyMap());
    }

    public void publishLoyaltyProgram(@Nonnull UUID pid, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling publishLoyaltyProgram");
        }
        String localVarPath = "/loyalty/config/programs/{pid}/publish".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public SubscriptionMember subscribeMemberToASubscription(@Nonnull UUID pid, @Nonnull AddSubscriptionMemberPayload addSubscriptionMemberPayload) throws ApiException {
        return this.subscribeMemberToASubscription(pid, addSubscriptionMemberPayload, Collections.emptyMap());
    }

    public SubscriptionMember subscribeMemberToASubscription(@Nonnull UUID pid, @Nonnull AddSubscriptionMemberPayload addSubscriptionMemberPayload, Map<String, String> additionalHeaders) throws ApiException {
        AddSubscriptionMemberPayload localVarPostBody = addSubscriptionMemberPayload;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling subscribeMemberToASubscription");
        }
        if (addSubscriptionMemberPayload == null) {
            throw new ApiException(400, "Missing the required parameter 'addSubscriptionMemberPayload' when calling subscribeMemberToASubscription");
        }
        String localVarPath = "/loyalty/config/programs/{pid}/subscription-members".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<SubscriptionMember> localVarReturnType = new TypeReference<SubscriptionMember>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Subscription subscribeToLoyaltyProgram(@Nonnull UUID pid, @Nonnull CreateSubscriptionPayload createSubscriptionPayload) throws ApiException {
        return this.subscribeToLoyaltyProgram(pid, createSubscriptionPayload, Collections.emptyMap());
    }

    public Subscription subscribeToLoyaltyProgram(@Nonnull UUID pid, @Nonnull CreateSubscriptionPayload createSubscriptionPayload, Map<String, String> additionalHeaders) throws ApiException {
        CreateSubscriptionPayload localVarPostBody = createSubscriptionPayload;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling subscribeToLoyaltyProgram");
        }
        if (createSubscriptionPayload == null) {
            throw new ApiException(400, "Missing the required parameter 'createSubscriptionPayload' when calling subscribeToLoyaltyProgram");
        }
        String localVarPath = "/loyalty/config/programs/{pid}/subscriptions".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<Subscription> localVarReturnType = new TypeReference<Subscription>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public LoyaltyProgram updateLoyaltyProgram(@Nonnull UUID pid, @Nonnull UpdateLoyaltyProgramPayload updateLoyaltyProgramPayload) throws ApiException {
        return this.updateLoyaltyProgram(pid, updateLoyaltyProgramPayload, Collections.emptyMap());
    }

    public LoyaltyProgram updateLoyaltyProgram(@Nonnull UUID pid, @Nonnull UpdateLoyaltyProgramPayload updateLoyaltyProgramPayload, Map<String, String> additionalHeaders) throws ApiException {
        UpdateLoyaltyProgramPayload localVarPostBody = updateLoyaltyProgramPayload;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling updateLoyaltyProgram");
        }
        if (updateLoyaltyProgramPayload == null) {
            throw new ApiException(400, "Missing the required parameter 'updateLoyaltyProgramPayload' when calling updateLoyaltyProgram");
        }
        String localVarPath = "/loyalty/config/programs/{pid}".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<LoyaltyProgram> localVarReturnType = new TypeReference<LoyaltyProgram>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

