/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;
import software.xdev.brevo.model.CorporateGroupDetailsResponse;
import software.xdev.brevo.model.CorporateGroupIdPutRequest;
import software.xdev.brevo.model.CorporateGroupPost201Response;
import software.xdev.brevo.model.CorporateGroupPostRequest;
import software.xdev.brevo.model.CorporateGroupUnlinkGroupIdSubAccountsPutRequest;
import software.xdev.brevo.model.CorporateIpGet200ResponseInner;
import software.xdev.brevo.model.CorporateSsoTokenPostRequest;
import software.xdev.brevo.model.CorporateSubAccountIpAssociatePostRequest;
import software.xdev.brevo.model.CorporateSubAccountIpDissociatePutRequest;
import software.xdev.brevo.model.CorporateSubAccountKeyPostRequest;
import software.xdev.brevo.model.CorporateSubAccountSsoTokenPostRequest;
import software.xdev.brevo.model.CorporateUserEmailPermissionsPutRequest;
import software.xdev.brevo.model.CorporateUserInvitationActionEmailPut200Response;
import software.xdev.brevo.model.CreateApiKeyResponse;
import software.xdev.brevo.model.CreateSubAccount;
import software.xdev.brevo.model.CreateSubAccountResponse;
import software.xdev.brevo.model.GetAccountActivity;
import software.xdev.brevo.model.GetCorporateInvitedUsersList;
import software.xdev.brevo.model.GetCorporateUserPermission;
import software.xdev.brevo.model.GetSsoToken;
import software.xdev.brevo.model.GetSubAccountGroups200ResponseInner;
import software.xdev.brevo.model.InviteAdminUser;
import software.xdev.brevo.model.MasterDetailsResponse;
import software.xdev.brevo.model.SubAccountAppsToggleRequest;
import software.xdev.brevo.model.SubAccountDetailsResponse;
import software.xdev.brevo.model.SubAccountUpdatePlanRequest;
import software.xdev.brevo.model.SubAccountsResponse;
import software.xdev.brevo.model.SubAccountsUpdatePlanRequest;

public class MasterAccountApi
extends BaseApi {
    public MasterAccountApi() {
        super(Configuration.getDefaultApiClient());
    }

    public MasterAccountApi(ApiClient apiClient) {
        super(apiClient);
    }

    public void corporateGroupIdDelete(@Nonnull String id) throws ApiException {
        this.corporateGroupIdDelete(id, Collections.emptyMap());
    }

    public void corporateGroupIdDelete(@Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling corporateGroupIdDelete");
        }
        String localVarPath = "/corporate/group/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public CorporateGroupDetailsResponse corporateGroupIdGet(@Nonnull String id) throws ApiException {
        return this.corporateGroupIdGet(id, Collections.emptyMap());
    }

    public CorporateGroupDetailsResponse corporateGroupIdGet(@Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling corporateGroupIdGet");
        }
        String localVarPath = "/corporate/group/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CorporateGroupDetailsResponse> localVarReturnType = new TypeReference<CorporateGroupDetailsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void corporateGroupIdPut(@Nonnull String id, @Nonnull CorporateGroupIdPutRequest corporateGroupIdPutRequest) throws ApiException {
        this.corporateGroupIdPut(id, corporateGroupIdPutRequest, Collections.emptyMap());
    }

    public void corporateGroupIdPut(@Nonnull String id, @Nonnull CorporateGroupIdPutRequest corporateGroupIdPutRequest, Map<String, String> additionalHeaders) throws ApiException {
        CorporateGroupIdPutRequest localVarPostBody = corporateGroupIdPutRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling corporateGroupIdPut");
        }
        if (corporateGroupIdPutRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'corporateGroupIdPutRequest' when calling corporateGroupIdPut");
        }
        String localVarPath = "/corporate/group/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public CorporateGroupPost201Response corporateGroupPost(@Nullable CorporateGroupPostRequest corporateGroupPostRequest) throws ApiException {
        return this.corporateGroupPost(corporateGroupPostRequest, Collections.emptyMap());
    }

    public CorporateGroupPost201Response corporateGroupPost(@Nullable CorporateGroupPostRequest corporateGroupPostRequest, Map<String, String> additionalHeaders) throws ApiException {
        CorporateGroupPostRequest localVarPostBody = corporateGroupPostRequest;
        String localVarPath = "/corporate/group";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CorporateGroupPost201Response> localVarReturnType = new TypeReference<CorporateGroupPost201Response>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void corporateGroupUnlinkGroupIdSubAccountsPut(@Nonnull String groupId, @Nonnull CorporateGroupUnlinkGroupIdSubAccountsPutRequest corporateGroupUnlinkGroupIdSubAccountsPutRequest) throws ApiException {
        this.corporateGroupUnlinkGroupIdSubAccountsPut(groupId, corporateGroupUnlinkGroupIdSubAccountsPutRequest, Collections.emptyMap());
    }

    public void corporateGroupUnlinkGroupIdSubAccountsPut(@Nonnull String groupId, @Nonnull CorporateGroupUnlinkGroupIdSubAccountsPutRequest corporateGroupUnlinkGroupIdSubAccountsPutRequest, Map<String, String> additionalHeaders) throws ApiException {
        CorporateGroupUnlinkGroupIdSubAccountsPutRequest localVarPostBody = corporateGroupUnlinkGroupIdSubAccountsPutRequest;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling corporateGroupUnlinkGroupIdSubAccountsPut");
        }
        if (corporateGroupUnlinkGroupIdSubAccountsPutRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'corporateGroupUnlinkGroupIdSubAccountsPutRequest' when calling corporateGroupUnlinkGroupIdSubAccountsPut");
        }
        String localVarPath = "/corporate/group/unlink/{groupId}/subAccounts".replaceAll("\\{groupId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(groupId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public List<CorporateIpGet200ResponseInner> corporateIpGet() throws ApiException {
        return this.corporateIpGet(Collections.emptyMap());
    }

    public List<CorporateIpGet200ResponseInner> corporateIpGet(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/corporate/ip";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<List<CorporateIpGet200ResponseInner>> localVarReturnType = new TypeReference<List<CorporateIpGet200ResponseInner>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MasterDetailsResponse corporateMasterAccountGet() throws ApiException {
        return this.corporateMasterAccountGet(Collections.emptyMap());
    }

    public MasterDetailsResponse corporateMasterAccountGet(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/corporate/masterAccount";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<MasterDetailsResponse> localVarReturnType = new TypeReference<MasterDetailsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetSsoToken corporateSsoTokenPost(@Nullable CorporateSsoTokenPostRequest corporateSsoTokenPostRequest) throws ApiException {
        return this.corporateSsoTokenPost(corporateSsoTokenPostRequest, Collections.emptyMap());
    }

    public GetSsoToken corporateSsoTokenPost(@Nullable CorporateSsoTokenPostRequest corporateSsoTokenPostRequest, Map<String, String> additionalHeaders) throws ApiException {
        CorporateSsoTokenPostRequest localVarPostBody = corporateSsoTokenPostRequest;
        String localVarPath = "/corporate/ssoToken";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetSsoToken> localVarReturnType = new TypeReference<GetSsoToken>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SubAccountsResponse corporateSubAccountGet(@Nonnull Integer offset, @Nonnull Integer limit) throws ApiException {
        return this.corporateSubAccountGet(offset, limit, Collections.emptyMap());
    }

    public SubAccountsResponse corporateSubAccountGet(@Nonnull Integer offset, @Nonnull Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (offset == null) {
            throw new ApiException(400, "Missing the required parameter 'offset' when calling corporateSubAccountGet");
        }
        if (limit == null) {
            throw new ApiException(400, "Missing the required parameter 'limit' when calling corporateSubAccountGet");
        }
        String localVarPath = "/corporate/subAccount";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<SubAccountsResponse> localVarReturnType = new TypeReference<SubAccountsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void corporateSubAccountIdApplicationsTogglePut(@Nonnull Long id, @Nonnull SubAccountAppsToggleRequest subAccountAppsToggleRequest) throws ApiException {
        this.corporateSubAccountIdApplicationsTogglePut(id, subAccountAppsToggleRequest, Collections.emptyMap());
    }

    public void corporateSubAccountIdApplicationsTogglePut(@Nonnull Long id, @Nonnull SubAccountAppsToggleRequest subAccountAppsToggleRequest, Map<String, String> additionalHeaders) throws ApiException {
        SubAccountAppsToggleRequest localVarPostBody = subAccountAppsToggleRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling corporateSubAccountIdApplicationsTogglePut");
        }
        if (subAccountAppsToggleRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'subAccountAppsToggleRequest' when calling corporateSubAccountIdApplicationsTogglePut");
        }
        String localVarPath = "/corporate/subAccount/{id}/applications/toggle".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void corporateSubAccountIdDelete(@Nonnull Long id) throws ApiException {
        this.corporateSubAccountIdDelete(id, Collections.emptyMap());
    }

    public void corporateSubAccountIdDelete(@Nonnull Long id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling corporateSubAccountIdDelete");
        }
        String localVarPath = "/corporate/subAccount/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public SubAccountDetailsResponse corporateSubAccountIdGet(@Nonnull Long id) throws ApiException {
        return this.corporateSubAccountIdGet(id, Collections.emptyMap());
    }

    public SubAccountDetailsResponse corporateSubAccountIdGet(@Nonnull Long id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling corporateSubAccountIdGet");
        }
        String localVarPath = "/corporate/subAccount/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<SubAccountDetailsResponse> localVarReturnType = new TypeReference<SubAccountDetailsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void corporateSubAccountIdPlanPut(@Nonnull Long id, @Nonnull SubAccountUpdatePlanRequest subAccountUpdatePlanRequest) throws ApiException {
        this.corporateSubAccountIdPlanPut(id, subAccountUpdatePlanRequest, Collections.emptyMap());
    }

    public void corporateSubAccountIdPlanPut(@Nonnull Long id, @Nonnull SubAccountUpdatePlanRequest subAccountUpdatePlanRequest, Map<String, String> additionalHeaders) throws ApiException {
        SubAccountUpdatePlanRequest localVarPostBody = subAccountUpdatePlanRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling corporateSubAccountIdPlanPut");
        }
        if (subAccountUpdatePlanRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'subAccountUpdatePlanRequest' when calling corporateSubAccountIdPlanPut");
        }
        String localVarPath = "/corporate/subAccount/{id}/plan".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public Object corporateSubAccountIpAssociatePost(@Nullable CorporateSubAccountIpAssociatePostRequest corporateSubAccountIpAssociatePostRequest) throws ApiException {
        return this.corporateSubAccountIpAssociatePost(corporateSubAccountIpAssociatePostRequest, Collections.emptyMap());
    }

    public Object corporateSubAccountIpAssociatePost(@Nullable CorporateSubAccountIpAssociatePostRequest corporateSubAccountIpAssociatePostRequest, Map<String, String> additionalHeaders) throws ApiException {
        CorporateSubAccountIpAssociatePostRequest localVarPostBody = corporateSubAccountIpAssociatePostRequest;
        String localVarPath = "/corporate/subAccount/ip/associate";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<Object> localVarReturnType = new TypeReference<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void corporateSubAccountIpDissociatePut(@Nullable CorporateSubAccountIpDissociatePutRequest corporateSubAccountIpDissociatePutRequest) throws ApiException {
        this.corporateSubAccountIpDissociatePut(corporateSubAccountIpDissociatePutRequest, Collections.emptyMap());
    }

    public void corporateSubAccountIpDissociatePut(@Nullable CorporateSubAccountIpDissociatePutRequest corporateSubAccountIpDissociatePutRequest, Map<String, String> additionalHeaders) throws ApiException {
        CorporateSubAccountIpDissociatePutRequest localVarPostBody = corporateSubAccountIpDissociatePutRequest;
        String localVarPath = "/corporate/subAccount/ip/dissociate";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public CreateApiKeyResponse corporateSubAccountKeyPost(@Nullable CorporateSubAccountKeyPostRequest corporateSubAccountKeyPostRequest) throws ApiException {
        return this.corporateSubAccountKeyPost(corporateSubAccountKeyPostRequest, Collections.emptyMap());
    }

    public CreateApiKeyResponse corporateSubAccountKeyPost(@Nullable CorporateSubAccountKeyPostRequest corporateSubAccountKeyPostRequest, Map<String, String> additionalHeaders) throws ApiException {
        CorporateSubAccountKeyPostRequest localVarPostBody = corporateSubAccountKeyPostRequest;
        String localVarPath = "/corporate/subAccount/key";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CreateApiKeyResponse> localVarReturnType = new TypeReference<CreateApiKeyResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CreateSubAccountResponse corporateSubAccountPost(@Nonnull CreateSubAccount createSubAccount) throws ApiException {
        return this.corporateSubAccountPost(createSubAccount, Collections.emptyMap());
    }

    public CreateSubAccountResponse corporateSubAccountPost(@Nonnull CreateSubAccount createSubAccount, Map<String, String> additionalHeaders) throws ApiException {
        CreateSubAccount localVarPostBody = createSubAccount;
        if (createSubAccount == null) {
            throw new ApiException(400, "Missing the required parameter 'createSubAccount' when calling corporateSubAccountPost");
        }
        String localVarPath = "/corporate/subAccount";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CreateSubAccountResponse> localVarReturnType = new TypeReference<CreateSubAccountResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetSsoToken corporateSubAccountSsoTokenPost(@Nullable CorporateSubAccountSsoTokenPostRequest corporateSubAccountSsoTokenPostRequest) throws ApiException {
        return this.corporateSubAccountSsoTokenPost(corporateSubAccountSsoTokenPostRequest, Collections.emptyMap());
    }

    public GetSsoToken corporateSubAccountSsoTokenPost(@Nullable CorporateSubAccountSsoTokenPostRequest corporateSubAccountSsoTokenPostRequest, Map<String, String> additionalHeaders) throws ApiException {
        CorporateSubAccountSsoTokenPostRequest localVarPostBody = corporateSubAccountSsoTokenPostRequest;
        String localVarPath = "/corporate/subAccount/ssoToken";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetSsoToken> localVarReturnType = new TypeReference<GetSsoToken>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void corporateSubAccountsPlanPut(@Nonnull SubAccountsUpdatePlanRequest subAccountsUpdatePlanRequest) throws ApiException {
        this.corporateSubAccountsPlanPut(subAccountsUpdatePlanRequest, Collections.emptyMap());
    }

    public void corporateSubAccountsPlanPut(@Nonnull SubAccountsUpdatePlanRequest subAccountsUpdatePlanRequest, Map<String, String> additionalHeaders) throws ApiException {
        SubAccountsUpdatePlanRequest localVarPostBody = subAccountsUpdatePlanRequest;
        if (subAccountsUpdatePlanRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'subAccountsUpdatePlanRequest' when calling corporateSubAccountsPlanPut");
        }
        String localVarPath = "/corporate/subAccounts/plan";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void corporateUserEmailPermissionsPut(@Nonnull String email, @Nonnull CorporateUserEmailPermissionsPutRequest corporateUserEmailPermissionsPutRequest) throws ApiException {
        this.corporateUserEmailPermissionsPut(email, corporateUserEmailPermissionsPutRequest, Collections.emptyMap());
    }

    public void corporateUserEmailPermissionsPut(@Nonnull String email, @Nonnull CorporateUserEmailPermissionsPutRequest corporateUserEmailPermissionsPutRequest, Map<String, String> additionalHeaders) throws ApiException {
        CorporateUserEmailPermissionsPutRequest localVarPostBody = corporateUserEmailPermissionsPutRequest;
        if (email == null) {
            throw new ApiException(400, "Missing the required parameter 'email' when calling corporateUserEmailPermissionsPut");
        }
        if (corporateUserEmailPermissionsPutRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'corporateUserEmailPermissionsPutRequest' when calling corporateUserEmailPermissionsPut");
        }
        String localVarPath = "/corporate/user/{email}/permissions".replaceAll("\\{email\\}", this.apiClient.escapeString(this.apiClient.parameterToString(email)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public CorporateUserInvitationActionEmailPut200Response corporateUserInvitationActionEmailPut(@Nonnull String action, @Nonnull String email) throws ApiException {
        return this.corporateUserInvitationActionEmailPut(action, email, Collections.emptyMap());
    }

    public CorporateUserInvitationActionEmailPut200Response corporateUserInvitationActionEmailPut(@Nonnull String action, @Nonnull String email, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (action == null) {
            throw new ApiException(400, "Missing the required parameter 'action' when calling corporateUserInvitationActionEmailPut");
        }
        if (email == null) {
            throw new ApiException(400, "Missing the required parameter 'email' when calling corporateUserInvitationActionEmailPut");
        }
        String localVarPath = "/corporate/user/invitation/{action}/{email}".replaceAll("\\{action\\}", this.apiClient.escapeString(this.apiClient.parameterToString(action))).replaceAll("\\{email\\}", this.apiClient.escapeString(this.apiClient.parameterToString(email)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CorporateUserInvitationActionEmailPut200Response> localVarReturnType = new TypeReference<CorporateUserInvitationActionEmailPut200Response>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void corporateUserRevokeEmailDelete(@Nonnull String email) throws ApiException {
        this.corporateUserRevokeEmailDelete(email, Collections.emptyMap());
    }

    public void corporateUserRevokeEmailDelete(@Nonnull String email, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (email == null) {
            throw new ApiException(400, "Missing the required parameter 'email' when calling corporateUserRevokeEmailDelete");
        }
        String localVarPath = "/corporate/user/revoke/{email}".replaceAll("\\{email\\}", this.apiClient.escapeString(this.apiClient.parameterToString(email)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public GetAccountActivity getAccountActivity(@Nullable String startDate, @Nullable String endDate, @Nullable String email, @Nullable Long limit, @Nullable Long offset) throws ApiException {
        return this.getAccountActivity(startDate, endDate, email, limit, offset, Collections.emptyMap());
    }

    public GetAccountActivity getAccountActivity(@Nullable String startDate, @Nullable String endDate, @Nullable String email, @Nullable Long limit, @Nullable Long offset, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/organization/activities";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("email", email));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetAccountActivity> localVarReturnType = new TypeReference<GetAccountActivity>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetCorporateInvitedUsersList getCorporateInvitedUsersList() throws ApiException {
        return this.getCorporateInvitedUsersList(Collections.emptyMap());
    }

    public GetCorporateInvitedUsersList getCorporateInvitedUsersList(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/corporate/invited/users";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetCorporateInvitedUsersList> localVarReturnType = new TypeReference<GetCorporateInvitedUsersList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetCorporateUserPermission getCorporateUserPermission(@Nonnull String email) throws ApiException {
        return this.getCorporateUserPermission(email, Collections.emptyMap());
    }

    public GetCorporateUserPermission getCorporateUserPermission(@Nonnull String email, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (email == null) {
            throw new ApiException(400, "Missing the required parameter 'email' when calling getCorporateUserPermission");
        }
        String localVarPath = "/corporate/user/{email}/permissions".replaceAll("\\{email\\}", this.apiClient.escapeString(this.apiClient.parameterToString(email)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetCorporateUserPermission> localVarReturnType = new TypeReference<GetCorporateUserPermission>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<GetSubAccountGroups200ResponseInner> getSubAccountGroups() throws ApiException {
        return this.getSubAccountGroups(Collections.emptyMap());
    }

    public List<GetSubAccountGroups200ResponseInner> getSubAccountGroups(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/corporate/groups";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<List<GetSubAccountGroups200ResponseInner>> localVarReturnType = new TypeReference<List<GetSubAccountGroups200ResponseInner>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CorporateGroupPost201Response inviteAdminUser(@Nonnull InviteAdminUser inviteAdminUser) throws ApiException {
        return this.inviteAdminUser(inviteAdminUser, Collections.emptyMap());
    }

    public CorporateGroupPost201Response inviteAdminUser(@Nonnull InviteAdminUser inviteAdminUser, Map<String, String> additionalHeaders) throws ApiException {
        InviteAdminUser localVarPostBody = inviteAdminUser;
        if (inviteAdminUser == null) {
            throw new ApiException(400, "Missing the required parameter 'inviteAdminUser' when calling inviteAdminUser");
        }
        String localVarPath = "/corporate/user/invitation/send";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CorporateGroupPost201Response> localVarReturnType = new TypeReference<CorporateGroupPost201Response>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

