/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;
import software.xdev.brevo.model.AbTestCampaignResult;
import software.xdev.brevo.model.CreateEmailCampaign;
import software.xdev.brevo.model.CreateModel;
import software.xdev.brevo.model.CreatedProcessId;
import software.xdev.brevo.model.EmailExportRecipients;
import software.xdev.brevo.model.GetEmailCampaign;
import software.xdev.brevo.model.GetEmailCampaigns;
import software.xdev.brevo.model.GetSharedTemplateUrl;
import software.xdev.brevo.model.SendReport;
import software.xdev.brevo.model.SendTestEmail;
import software.xdev.brevo.model.UpdateCampaignStatus;
import software.xdev.brevo.model.UpdateEmailCampaign;
import software.xdev.brevo.model.UploadImageModel;
import software.xdev.brevo.model.UploadImageToGallery;

public class EmailCampaignsApi
extends BaseApi {
    public EmailCampaignsApi() {
        super(Configuration.getDefaultApiClient());
    }

    public EmailCampaignsApi(ApiClient apiClient) {
        super(apiClient);
    }

    public CreateModel createEmailCampaign(@Nonnull CreateEmailCampaign createEmailCampaign) throws ApiException {
        return this.createEmailCampaign(createEmailCampaign, Collections.emptyMap());
    }

    public CreateModel createEmailCampaign(@Nonnull CreateEmailCampaign createEmailCampaign, Map<String, String> additionalHeaders) throws ApiException {
        CreateEmailCampaign localVarPostBody = createEmailCampaign;
        if (createEmailCampaign == null) {
            throw new ApiException(400, "Missing the required parameter 'createEmailCampaign' when calling createEmailCampaign");
        }
        String localVarPath = "/emailCampaigns";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CreateModel> localVarReturnType = new TypeReference<CreateModel>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteEmailCampaign(@Nonnull Long campaignId) throws ApiException {
        this.deleteEmailCampaign(campaignId, Collections.emptyMap());
    }

    public void deleteEmailCampaign(@Nonnull Long campaignId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (campaignId == null) {
            throw new ApiException(400, "Missing the required parameter 'campaignId' when calling deleteEmailCampaign");
        }
        String localVarPath = "/emailCampaigns/{campaignId}".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(campaignId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public CreatedProcessId emailExportRecipients(@Nonnull Long campaignId, @Nullable EmailExportRecipients emailExportRecipients) throws ApiException {
        return this.emailExportRecipients(campaignId, emailExportRecipients, Collections.emptyMap());
    }

    public CreatedProcessId emailExportRecipients(@Nonnull Long campaignId, @Nullable EmailExportRecipients emailExportRecipients, Map<String, String> additionalHeaders) throws ApiException {
        EmailExportRecipients localVarPostBody = emailExportRecipients;
        if (campaignId == null) {
            throw new ApiException(400, "Missing the required parameter 'campaignId' when calling emailExportRecipients");
        }
        String localVarPath = "/emailCampaigns/{campaignId}/exportRecipients".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(campaignId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CreatedProcessId> localVarReturnType = new TypeReference<CreatedProcessId>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AbTestCampaignResult getAbTestCampaignResult(@Nonnull Long campaignId) throws ApiException {
        return this.getAbTestCampaignResult(campaignId, Collections.emptyMap());
    }

    public AbTestCampaignResult getAbTestCampaignResult(@Nonnull Long campaignId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (campaignId == null) {
            throw new ApiException(400, "Missing the required parameter 'campaignId' when calling getAbTestCampaignResult");
        }
        String localVarPath = "/emailCampaigns/{campaignId}/abTestCampaignResult".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(campaignId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<AbTestCampaignResult> localVarReturnType = new TypeReference<AbTestCampaignResult>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetEmailCampaign getEmailCampaign(@Nonnull Long campaignId, @Nullable String statistics) throws ApiException {
        return this.getEmailCampaign(campaignId, statistics, Collections.emptyMap());
    }

    public GetEmailCampaign getEmailCampaign(@Nonnull Long campaignId, @Nullable String statistics, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (campaignId == null) {
            throw new ApiException(400, "Missing the required parameter 'campaignId' when calling getEmailCampaign");
        }
        String localVarPath = "/emailCampaigns/{campaignId}".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(campaignId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("statistics", statistics));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetEmailCampaign> localVarReturnType = new TypeReference<GetEmailCampaign>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetEmailCampaigns getEmailCampaigns(@Nullable String type, @Nullable String status, @Nullable String statistics, @Nullable String startDate, @Nullable String endDate, @Nullable Long limit, @Nullable Long offset, @Nullable String sort, @Nullable Boolean excludeHtmlContent) throws ApiException {
        return this.getEmailCampaigns(type, status, statistics, startDate, endDate, limit, offset, sort, excludeHtmlContent, Collections.emptyMap());
    }

    public GetEmailCampaigns getEmailCampaigns(@Nullable String type, @Nullable String status, @Nullable String statistics, @Nullable String startDate, @Nullable String endDate, @Nullable Long limit, @Nullable Long offset, @Nullable String sort, @Nullable Boolean excludeHtmlContent, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/emailCampaigns";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("status", status));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("statistics", statistics));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("excludeHtmlContent", excludeHtmlContent));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetEmailCampaigns> localVarReturnType = new TypeReference<GetEmailCampaigns>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetSharedTemplateUrl getSharedTemplateUrl(@Nonnull Long campaignId) throws ApiException {
        return this.getSharedTemplateUrl(campaignId, Collections.emptyMap());
    }

    public GetSharedTemplateUrl getSharedTemplateUrl(@Nonnull Long campaignId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (campaignId == null) {
            throw new ApiException(400, "Missing the required parameter 'campaignId' when calling getSharedTemplateUrl");
        }
        String localVarPath = "/emailCampaigns/{campaignId}/sharedUrl".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(campaignId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetSharedTemplateUrl> localVarReturnType = new TypeReference<GetSharedTemplateUrl>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void sendEmailCampaignNow(@Nonnull Long campaignId) throws ApiException {
        this.sendEmailCampaignNow(campaignId, Collections.emptyMap());
    }

    public void sendEmailCampaignNow(@Nonnull Long campaignId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (campaignId == null) {
            throw new ApiException(400, "Missing the required parameter 'campaignId' when calling sendEmailCampaignNow");
        }
        String localVarPath = "/emailCampaigns/{campaignId}/sendNow".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(campaignId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void sendReport(@Nonnull Long campaignId, @Nonnull SendReport sendReport) throws ApiException {
        this.sendReport(campaignId, sendReport, Collections.emptyMap());
    }

    public void sendReport(@Nonnull Long campaignId, @Nonnull SendReport sendReport, Map<String, String> additionalHeaders) throws ApiException {
        SendReport localVarPostBody = sendReport;
        if (campaignId == null) {
            throw new ApiException(400, "Missing the required parameter 'campaignId' when calling sendReport");
        }
        if (sendReport == null) {
            throw new ApiException(400, "Missing the required parameter 'sendReport' when calling sendReport");
        }
        String localVarPath = "/emailCampaigns/{campaignId}/sendReport".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(campaignId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void sendTestEmail(@Nonnull Long campaignId, @Nonnull SendTestEmail sendTestEmail) throws ApiException {
        this.sendTestEmail(campaignId, sendTestEmail, Collections.emptyMap());
    }

    public void sendTestEmail(@Nonnull Long campaignId, @Nonnull SendTestEmail sendTestEmail, Map<String, String> additionalHeaders) throws ApiException {
        SendTestEmail localVarPostBody = sendTestEmail;
        if (campaignId == null) {
            throw new ApiException(400, "Missing the required parameter 'campaignId' when calling sendTestEmail");
        }
        if (sendTestEmail == null) {
            throw new ApiException(400, "Missing the required parameter 'sendTestEmail' when calling sendTestEmail");
        }
        String localVarPath = "/emailCampaigns/{campaignId}/sendTest".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(campaignId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void updateCampaignStatus(@Nonnull Long campaignId, @Nonnull UpdateCampaignStatus updateCampaignStatus) throws ApiException {
        this.updateCampaignStatus(campaignId, updateCampaignStatus, Collections.emptyMap());
    }

    public void updateCampaignStatus(@Nonnull Long campaignId, @Nonnull UpdateCampaignStatus updateCampaignStatus, Map<String, String> additionalHeaders) throws ApiException {
        UpdateCampaignStatus localVarPostBody = updateCampaignStatus;
        if (campaignId == null) {
            throw new ApiException(400, "Missing the required parameter 'campaignId' when calling updateCampaignStatus");
        }
        if (updateCampaignStatus == null) {
            throw new ApiException(400, "Missing the required parameter 'updateCampaignStatus' when calling updateCampaignStatus");
        }
        String localVarPath = "/emailCampaigns/{campaignId}/status".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(campaignId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void updateEmailCampaign(@Nonnull Long campaignId, @Nonnull UpdateEmailCampaign updateEmailCampaign) throws ApiException {
        this.updateEmailCampaign(campaignId, updateEmailCampaign, Collections.emptyMap());
    }

    public void updateEmailCampaign(@Nonnull Long campaignId, @Nonnull UpdateEmailCampaign updateEmailCampaign, Map<String, String> additionalHeaders) throws ApiException {
        UpdateEmailCampaign localVarPostBody = updateEmailCampaign;
        if (campaignId == null) {
            throw new ApiException(400, "Missing the required parameter 'campaignId' when calling updateEmailCampaign");
        }
        if (updateEmailCampaign == null) {
            throw new ApiException(400, "Missing the required parameter 'updateEmailCampaign' when calling updateEmailCampaign");
        }
        String localVarPath = "/emailCampaigns/{campaignId}".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(campaignId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public UploadImageModel uploadImageToGallery(@Nonnull UploadImageToGallery uploadImageToGallery) throws ApiException {
        return this.uploadImageToGallery(uploadImageToGallery, Collections.emptyMap());
    }

    public UploadImageModel uploadImageToGallery(@Nonnull UploadImageToGallery uploadImageToGallery, Map<String, String> additionalHeaders) throws ApiException {
        UploadImageToGallery localVarPostBody = uploadImageToGallery;
        if (uploadImageToGallery == null) {
            throw new ApiException(400, "Missing the required parameter 'uploadImageToGallery' when calling uploadImageToGallery");
        }
        String localVarPath = "/emailCampaigns/images";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<UploadImageModel> localVarReturnType = new TypeReference<UploadImageModel>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

