/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;
import software.xdev.brevo.model.CreateCategoryModel;
import software.xdev.brevo.model.CreateProductModel;
import software.xdev.brevo.model.CreateUpdateBatchCategory;
import software.xdev.brevo.model.CreateUpdateBatchCategoryModel;
import software.xdev.brevo.model.CreateUpdateBatchProducts;
import software.xdev.brevo.model.CreateUpdateBatchProductsModel;
import software.xdev.brevo.model.CreateUpdateCategory;
import software.xdev.brevo.model.CreateUpdateProduct;
import software.xdev.brevo.model.CreatedBatchId;
import software.xdev.brevo.model.EcommerceAttributionMetricsConversionSourceConversionSourceIdGet200Response;
import software.xdev.brevo.model.EcommerceAttributionMetricsGet200Response;
import software.xdev.brevo.model.EcommerceAttributionProductsConversionSourceConversionSourceIdGet200Response;
import software.xdev.brevo.model.EcommerceConfigDisplayCurrencyGet200Response;
import software.xdev.brevo.model.GetCategories;
import software.xdev.brevo.model.GetCategoryDetails;
import software.xdev.brevo.model.GetProductDetails;
import software.xdev.brevo.model.GetProducts;
import software.xdev.brevo.model.Order;
import software.xdev.brevo.model.OrderBatch;

public class EcommerceApi
extends BaseApi {
    public EcommerceApi() {
        super(Configuration.getDefaultApiClient());
    }

    public EcommerceApi(ApiClient apiClient) {
        super(apiClient);
    }

    public CreatedBatchId createBatchOrder(@Nonnull OrderBatch orderBatch) throws ApiException {
        return this.createBatchOrder(orderBatch, Collections.emptyMap());
    }

    public CreatedBatchId createBatchOrder(@Nonnull OrderBatch orderBatch, Map<String, String> additionalHeaders) throws ApiException {
        OrderBatch localVarPostBody = orderBatch;
        if (orderBatch == null) {
            throw new ApiException(400, "Missing the required parameter 'orderBatch' when calling createBatchOrder");
        }
        String localVarPath = "/orders/status/batch";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CreatedBatchId> localVarReturnType = new TypeReference<CreatedBatchId>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void createOrder(@Nonnull Order order) throws ApiException {
        this.createOrder(order, Collections.emptyMap());
    }

    public void createOrder(@Nonnull Order order, Map<String, String> additionalHeaders) throws ApiException {
        Order localVarPostBody = order;
        if (order == null) {
            throw new ApiException(400, "Missing the required parameter 'order' when calling createOrder");
        }
        String localVarPath = "/orders/status";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public CreateUpdateBatchCategoryModel createUpdateBatchCategory(@Nonnull CreateUpdateBatchCategory createUpdateBatchCategory) throws ApiException {
        return this.createUpdateBatchCategory(createUpdateBatchCategory, Collections.emptyMap());
    }

    public CreateUpdateBatchCategoryModel createUpdateBatchCategory(@Nonnull CreateUpdateBatchCategory createUpdateBatchCategory, Map<String, String> additionalHeaders) throws ApiException {
        CreateUpdateBatchCategory localVarPostBody = createUpdateBatchCategory;
        if (createUpdateBatchCategory == null) {
            throw new ApiException(400, "Missing the required parameter 'createUpdateBatchCategory' when calling createUpdateBatchCategory");
        }
        String localVarPath = "/categories/batch";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CreateUpdateBatchCategoryModel> localVarReturnType = new TypeReference<CreateUpdateBatchCategoryModel>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CreateUpdateBatchProductsModel createUpdateBatchProducts(@Nonnull CreateUpdateBatchProducts createUpdateBatchProducts) throws ApiException {
        return this.createUpdateBatchProducts(createUpdateBatchProducts, Collections.emptyMap());
    }

    public CreateUpdateBatchProductsModel createUpdateBatchProducts(@Nonnull CreateUpdateBatchProducts createUpdateBatchProducts, Map<String, String> additionalHeaders) throws ApiException {
        CreateUpdateBatchProducts localVarPostBody = createUpdateBatchProducts;
        if (createUpdateBatchProducts == null) {
            throw new ApiException(400, "Missing the required parameter 'createUpdateBatchProducts' when calling createUpdateBatchProducts");
        }
        String localVarPath = "/products/batch";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CreateUpdateBatchProductsModel> localVarReturnType = new TypeReference<CreateUpdateBatchProductsModel>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CreateCategoryModel createUpdateCategory(@Nonnull CreateUpdateCategory createUpdateCategory) throws ApiException {
        return this.createUpdateCategory(createUpdateCategory, Collections.emptyMap());
    }

    public CreateCategoryModel createUpdateCategory(@Nonnull CreateUpdateCategory createUpdateCategory, Map<String, String> additionalHeaders) throws ApiException {
        CreateUpdateCategory localVarPostBody = createUpdateCategory;
        if (createUpdateCategory == null) {
            throw new ApiException(400, "Missing the required parameter 'createUpdateCategory' when calling createUpdateCategory");
        }
        String localVarPath = "/categories";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CreateCategoryModel> localVarReturnType = new TypeReference<CreateCategoryModel>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CreateProductModel createUpdateProduct(@Nonnull CreateUpdateProduct createUpdateProduct) throws ApiException {
        return this.createUpdateProduct(createUpdateProduct, Collections.emptyMap());
    }

    public CreateProductModel createUpdateProduct(@Nonnull CreateUpdateProduct createUpdateProduct, Map<String, String> additionalHeaders) throws ApiException {
        CreateUpdateProduct localVarPostBody = createUpdateProduct;
        if (createUpdateProduct == null) {
            throw new ApiException(400, "Missing the required parameter 'createUpdateProduct' when calling createUpdateProduct");
        }
        String localVarPath = "/products";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CreateProductModel> localVarReturnType = new TypeReference<CreateProductModel>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void ecommerceActivatePost() throws ApiException {
        this.ecommerceActivatePost(Collections.emptyMap());
    }

    public void ecommerceActivatePost(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/ecommerce/activate";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public EcommerceAttributionMetricsConversionSourceConversionSourceIdGet200Response ecommerceAttributionMetricsConversionSourceConversionSourceIdGet(@Nonnull String conversionSource, @Nonnull String conversionSourceId) throws ApiException {
        return this.ecommerceAttributionMetricsConversionSourceConversionSourceIdGet(conversionSource, conversionSourceId, Collections.emptyMap());
    }

    public EcommerceAttributionMetricsConversionSourceConversionSourceIdGet200Response ecommerceAttributionMetricsConversionSourceConversionSourceIdGet(@Nonnull String conversionSource, @Nonnull String conversionSourceId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (conversionSource == null) {
            throw new ApiException(400, "Missing the required parameter 'conversionSource' when calling ecommerceAttributionMetricsConversionSourceConversionSourceIdGet");
        }
        if (conversionSourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'conversionSourceId' when calling ecommerceAttributionMetricsConversionSourceConversionSourceIdGet");
        }
        String localVarPath = "/ecommerce/attribution/metrics/{conversionSource}/{conversionSourceId}".replaceAll("\\{conversionSource\\}", this.apiClient.escapeString(this.apiClient.parameterToString(conversionSource))).replaceAll("\\{conversionSourceId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(conversionSourceId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<EcommerceAttributionMetricsConversionSourceConversionSourceIdGet200Response> localVarReturnType = new TypeReference<EcommerceAttributionMetricsConversionSourceConversionSourceIdGet200Response>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EcommerceAttributionMetricsGet200Response ecommerceAttributionMetricsGet(@Nullable OffsetDateTime periodFrom, @Nullable OffsetDateTime periodTo, @Nullable List<String> emailCampaignId, @Nullable List<String> smsCampaignId, @Nullable List<String> automationWorkflowEmailId, @Nullable List<String> automationWorkflowSmsId) throws ApiException {
        return this.ecommerceAttributionMetricsGet(periodFrom, periodTo, emailCampaignId, smsCampaignId, automationWorkflowEmailId, automationWorkflowSmsId, Collections.emptyMap());
    }

    public EcommerceAttributionMetricsGet200Response ecommerceAttributionMetricsGet(@Nullable OffsetDateTime periodFrom, @Nullable OffsetDateTime periodTo, @Nullable List<String> emailCampaignId, @Nullable List<String> smsCampaignId, @Nullable List<String> automationWorkflowEmailId, @Nullable List<String> automationWorkflowSmsId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/ecommerce/attribution/metrics";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("periodFrom", periodFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("periodTo", periodTo));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "emailCampaignId[]", emailCampaignId));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "smsCampaignId[]", smsCampaignId));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "automationWorkflowEmailId[]", automationWorkflowEmailId));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "automationWorkflowSmsId[]", automationWorkflowSmsId));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<EcommerceAttributionMetricsGet200Response> localVarReturnType = new TypeReference<EcommerceAttributionMetricsGet200Response>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EcommerceAttributionProductsConversionSourceConversionSourceIdGet200Response ecommerceAttributionProductsConversionSourceConversionSourceIdGet(@Nonnull String conversionSource, @Nonnull String conversionSourceId) throws ApiException {
        return this.ecommerceAttributionProductsConversionSourceConversionSourceIdGet(conversionSource, conversionSourceId, Collections.emptyMap());
    }

    public EcommerceAttributionProductsConversionSourceConversionSourceIdGet200Response ecommerceAttributionProductsConversionSourceConversionSourceIdGet(@Nonnull String conversionSource, @Nonnull String conversionSourceId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (conversionSource == null) {
            throw new ApiException(400, "Missing the required parameter 'conversionSource' when calling ecommerceAttributionProductsConversionSourceConversionSourceIdGet");
        }
        if (conversionSourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'conversionSourceId' when calling ecommerceAttributionProductsConversionSourceConversionSourceIdGet");
        }
        String localVarPath = "/ecommerce/attribution/products/{conversionSource}/{conversionSourceId}".replaceAll("\\{conversionSource\\}", this.apiClient.escapeString(this.apiClient.parameterToString(conversionSource))).replaceAll("\\{conversionSourceId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(conversionSourceId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<EcommerceAttributionProductsConversionSourceConversionSourceIdGet200Response> localVarReturnType = new TypeReference<EcommerceAttributionProductsConversionSourceConversionSourceIdGet200Response>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EcommerceConfigDisplayCurrencyGet200Response ecommerceConfigDisplayCurrencyGet() throws ApiException {
        return this.ecommerceConfigDisplayCurrencyGet(Collections.emptyMap());
    }

    public EcommerceConfigDisplayCurrencyGet200Response ecommerceConfigDisplayCurrencyGet(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/ecommerce/config/displayCurrency";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<EcommerceConfigDisplayCurrencyGet200Response> localVarReturnType = new TypeReference<EcommerceConfigDisplayCurrencyGet200Response>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetCategories getCategories(@Nullable Long limit, @Nullable Long offset, @Nullable String sort, @Nullable List<String> ids, @Nullable String name, @Nullable String modifiedSince, @Nullable String createdSince) throws ApiException {
        return this.getCategories(limit, offset, sort, ids, name, modifiedSince, createdSince, Collections.emptyMap());
    }

    public GetCategories getCategories(@Nullable Long limit, @Nullable Long offset, @Nullable String sort, @Nullable List<String> ids, @Nullable String name, @Nullable String modifiedSince, @Nullable String createdSince, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/categories";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "ids", ids));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("modifiedSince", modifiedSince));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("createdSince", createdSince));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetCategories> localVarReturnType = new TypeReference<GetCategories>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetCategoryDetails getCategoryInfo(@Nonnull String id) throws ApiException {
        return this.getCategoryInfo(id, Collections.emptyMap());
    }

    public GetCategoryDetails getCategoryInfo(@Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getCategoryInfo");
        }
        String localVarPath = "/categories/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetCategoryDetails> localVarReturnType = new TypeReference<GetCategoryDetails>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void getOrders(@Nullable Long limit, @Nullable Long offset, @Nullable String sort, @Nullable String modifiedSince, @Nullable String createdSince) throws ApiException {
        this.getOrders(limit, offset, sort, modifiedSince, createdSince, Collections.emptyMap());
    }

    public void getOrders(@Nullable Long limit, @Nullable Long offset, @Nullable String sort, @Nullable String modifiedSince, @Nullable String createdSince, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/orders";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("modifiedSince", modifiedSince));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("createdSince", createdSince));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public GetProductDetails getProductInfo(@Nonnull String id) throws ApiException {
        return this.getProductInfo(id, Collections.emptyMap());
    }

    public GetProductDetails getProductInfo(@Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getProductInfo");
        }
        String localVarPath = "/products/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetProductDetails> localVarReturnType = new TypeReference<GetProductDetails>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetProducts getProducts(@Nullable Long limit, @Nullable Long offset, @Nullable String sort, @Nullable List<String> ids, @Nullable String name, @Nullable BigDecimal priceLte, @Nullable BigDecimal priceGte, @Nullable BigDecimal priceLt, @Nullable BigDecimal priceGt, @Nullable BigDecimal priceEq, @Nullable BigDecimal priceNe, @Nullable List<String> categories, @Nullable String modifiedSince, @Nullable String createdSince) throws ApiException {
        return this.getProducts(limit, offset, sort, ids, name, priceLte, priceGte, priceLt, priceGt, priceEq, priceNe, categories, modifiedSince, createdSince, Collections.emptyMap());
    }

    public GetProducts getProducts(@Nullable Long limit, @Nullable Long offset, @Nullable String sort, @Nullable List<String> ids, @Nullable String name, @Nullable BigDecimal priceLte, @Nullable BigDecimal priceGte, @Nullable BigDecimal priceLt, @Nullable BigDecimal priceGt, @Nullable BigDecimal priceEq, @Nullable BigDecimal priceNe, @Nullable List<String> categories, @Nullable String modifiedSince, @Nullable String createdSince, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/products";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "ids", ids));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("price[lte]", priceLte));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("price[gte]", priceGte));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("price[lt]", priceLt));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("price[gt]", priceGt));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("price[eq]", priceEq));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("price[ne]", priceNe));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "categories", categories));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("modifiedSince", modifiedSince));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("createdSince", createdSince));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetProducts> localVarReturnType = new TypeReference<GetProducts>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EcommerceConfigDisplayCurrencyGet200Response setConfigDisplayCurrency(@Nullable EcommerceConfigDisplayCurrencyGet200Response ecommerceConfigDisplayCurrencyGet200Response) throws ApiException {
        return this.setConfigDisplayCurrency(ecommerceConfigDisplayCurrencyGet200Response, Collections.emptyMap());
    }

    public EcommerceConfigDisplayCurrencyGet200Response setConfigDisplayCurrency(@Nullable EcommerceConfigDisplayCurrencyGet200Response ecommerceConfigDisplayCurrencyGet200Response, Map<String, String> additionalHeaders) throws ApiException {
        EcommerceConfigDisplayCurrencyGet200Response localVarPostBody = ecommerceConfigDisplayCurrencyGet200Response;
        String localVarPath = "/ecommerce/config/displayCurrency";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<EcommerceConfigDisplayCurrencyGet200Response> localVarReturnType = new TypeReference<EcommerceConfigDisplayCurrencyGet200Response>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

