/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;
import software.xdev.brevo.model.AuthenticateDomainModel;
import software.xdev.brevo.model.CreateDomain;
import software.xdev.brevo.model.CreateDomainModel;
import software.xdev.brevo.model.GetDomainConfigurationModel;
import software.xdev.brevo.model.GetDomainsList;

public class DomainsApi
extends BaseApi {
    public DomainsApi() {
        super(Configuration.getDefaultApiClient());
    }

    public DomainsApi(ApiClient apiClient) {
        super(apiClient);
    }

    public AuthenticateDomainModel authenticateDomain(@Nonnull String domainName) throws ApiException {
        return this.authenticateDomain(domainName, Collections.emptyMap());
    }

    public AuthenticateDomainModel authenticateDomain(@Nonnull String domainName, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (domainName == null) {
            throw new ApiException(400, "Missing the required parameter 'domainName' when calling authenticateDomain");
        }
        String localVarPath = "/senders/domains/{domainName}/authenticate".replaceAll("\\{domainName\\}", this.apiClient.escapeString(this.apiClient.parameterToString(domainName)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<AuthenticateDomainModel> localVarReturnType = new TypeReference<AuthenticateDomainModel>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CreateDomainModel createDomain(@Nullable CreateDomain domain) throws ApiException {
        return this.createDomain(domain, Collections.emptyMap());
    }

    public CreateDomainModel createDomain(@Nullable CreateDomain domain, Map<String, String> additionalHeaders) throws ApiException {
        CreateDomain localVarPostBody = domain;
        String localVarPath = "/senders/domains";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CreateDomainModel> localVarReturnType = new TypeReference<CreateDomainModel>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteDomain(@Nonnull String domainName) throws ApiException {
        this.deleteDomain(domainName, Collections.emptyMap());
    }

    public void deleteDomain(@Nonnull String domainName, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (domainName == null) {
            throw new ApiException(400, "Missing the required parameter 'domainName' when calling deleteDomain");
        }
        String localVarPath = "/senders/domains/{domainName}".replaceAll("\\{domainName\\}", this.apiClient.escapeString(this.apiClient.parameterToString(domainName)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public GetDomainConfigurationModel getDomainConfiguration(@Nonnull String domainName) throws ApiException {
        return this.getDomainConfiguration(domainName, Collections.emptyMap());
    }

    public GetDomainConfigurationModel getDomainConfiguration(@Nonnull String domainName, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (domainName == null) {
            throw new ApiException(400, "Missing the required parameter 'domainName' when calling getDomainConfiguration");
        }
        String localVarPath = "/senders/domains/{domainName}".replaceAll("\\{domainName\\}", this.apiClient.escapeString(this.apiClient.parameterToString(domainName)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetDomainConfigurationModel> localVarReturnType = new TypeReference<GetDomainConfigurationModel>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetDomainsList getDomains() throws ApiException {
        return this.getDomains(Collections.emptyMap());
    }

    public GetDomainsList getDomains(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/senders/domains";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetDomainsList> localVarReturnType = new TypeReference<GetDomainsList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

