/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;
import software.xdev.brevo.model.CompaniesImportPost200Response;
import software.xdev.brevo.model.CrmAttributesPost200Response;
import software.xdev.brevo.model.CrmAttributesPostRequest;
import software.xdev.brevo.model.CrmDealsIdPatchRequest;
import software.xdev.brevo.model.CrmDealsLinkUnlinkIdPatchRequest;
import software.xdev.brevo.model.CrmDealsPost201Response;
import software.xdev.brevo.model.CrmDealsPostRequest;
import software.xdev.brevo.model.Deal;
import software.xdev.brevo.model.DealAttributesInner;
import software.xdev.brevo.model.DealsList;
import software.xdev.brevo.model.Pipeline;

public class DealsApi
extends BaseApi {
    public DealsApi() {
        super(Configuration.getDefaultApiClient());
    }

    public DealsApi(ApiClient apiClient) {
        super(apiClient);
    }

    public List<DealAttributesInner> crmAttributesDealsGet() throws ApiException {
        return this.crmAttributesDealsGet(Collections.emptyMap());
    }

    public List<DealAttributesInner> crmAttributesDealsGet(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/crm/attributes/deals";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<List<DealAttributesInner>> localVarReturnType = new TypeReference<List<DealAttributesInner>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CrmAttributesPost200Response crmAttributesPost(@Nonnull CrmAttributesPostRequest crmAttributesPostRequest) throws ApiException {
        return this.crmAttributesPost(crmAttributesPostRequest, Collections.emptyMap());
    }

    public CrmAttributesPost200Response crmAttributesPost(@Nonnull CrmAttributesPostRequest crmAttributesPostRequest, Map<String, String> additionalHeaders) throws ApiException {
        CrmAttributesPostRequest localVarPostBody = crmAttributesPostRequest;
        if (crmAttributesPostRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'crmAttributesPostRequest' when calling crmAttributesPost");
        }
        String localVarPath = "/crm/attributes";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CrmAttributesPost200Response> localVarReturnType = new TypeReference<CrmAttributesPost200Response>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DealsList crmDealsGet(@Nullable String filtersAttributesDealName, @Nullable String filtersLinkedCompaniesIds, @Nullable String filtersLinkedContactsIds, @Nullable String modifiedSince, @Nullable String createdSince, @Nullable Long offset, @Nullable Long limit, @Nullable String sort) throws ApiException {
        return this.crmDealsGet(filtersAttributesDealName, filtersLinkedCompaniesIds, filtersLinkedContactsIds, modifiedSince, createdSince, offset, limit, sort, Collections.emptyMap());
    }

    public DealsList crmDealsGet(@Nullable String filtersAttributesDealName, @Nullable String filtersLinkedCompaniesIds, @Nullable String filtersLinkedContactsIds, @Nullable String modifiedSince, @Nullable String createdSince, @Nullable Long offset, @Nullable Long limit, @Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/crm/deals";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("filters[attributes.deal_name]", filtersAttributesDealName));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("filters[linkedCompaniesIds]", filtersLinkedCompaniesIds));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("filters[linkedContactsIds]", filtersLinkedContactsIds));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("modifiedSince", modifiedSince));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("createdSince", createdSince));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<DealsList> localVarReturnType = new TypeReference<DealsList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void crmDealsIdDelete(@Nonnull String id) throws ApiException {
        this.crmDealsIdDelete(id, Collections.emptyMap());
    }

    public void crmDealsIdDelete(@Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling crmDealsIdDelete");
        }
        String localVarPath = "/crm/deals/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public Deal crmDealsIdGet(@Nonnull String id) throws ApiException {
        return this.crmDealsIdGet(id, Collections.emptyMap());
    }

    public Deal crmDealsIdGet(@Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling crmDealsIdGet");
        }
        String localVarPath = "/crm/deals/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<Deal> localVarReturnType = new TypeReference<Deal>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void crmDealsIdPatch(@Nonnull String id, @Nonnull CrmDealsIdPatchRequest crmDealsIdPatchRequest) throws ApiException {
        this.crmDealsIdPatch(id, crmDealsIdPatchRequest, Collections.emptyMap());
    }

    public void crmDealsIdPatch(@Nonnull String id, @Nonnull CrmDealsIdPatchRequest crmDealsIdPatchRequest, Map<String, String> additionalHeaders) throws ApiException {
        CrmDealsIdPatchRequest localVarPostBody = crmDealsIdPatchRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling crmDealsIdPatch");
        }
        if (crmDealsIdPatchRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'crmDealsIdPatchRequest' when calling crmDealsIdPatch");
        }
        String localVarPath = "/crm/deals/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public CompaniesImportPost200Response crmDealsImportPost(@Nullable File _file, @Nullable Object mapping) throws ApiException {
        return this.crmDealsImportPost(_file, mapping, Collections.emptyMap());
    }

    public CompaniesImportPost200Response crmDealsImportPost(@Nullable File _file, @Nullable Object mapping, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/crm/deals/import";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        if (_file != null) {
            localVarFormParams.put("file", _file);
        }
        if (mapping != null) {
            localVarFormParams.put("mapping", mapping);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CompaniesImportPost200Response> localVarReturnType = new TypeReference<CompaniesImportPost200Response>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void crmDealsLinkUnlinkIdPatch(@Nonnull String id, @Nonnull CrmDealsLinkUnlinkIdPatchRequest crmDealsLinkUnlinkIdPatchRequest) throws ApiException {
        this.crmDealsLinkUnlinkIdPatch(id, crmDealsLinkUnlinkIdPatchRequest, Collections.emptyMap());
    }

    public void crmDealsLinkUnlinkIdPatch(@Nonnull String id, @Nonnull CrmDealsLinkUnlinkIdPatchRequest crmDealsLinkUnlinkIdPatchRequest, Map<String, String> additionalHeaders) throws ApiException {
        CrmDealsLinkUnlinkIdPatchRequest localVarPostBody = crmDealsLinkUnlinkIdPatchRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling crmDealsLinkUnlinkIdPatch");
        }
        if (crmDealsLinkUnlinkIdPatchRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'crmDealsLinkUnlinkIdPatchRequest' when calling crmDealsLinkUnlinkIdPatch");
        }
        String localVarPath = "/crm/deals/link-unlink/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public CrmDealsPost201Response crmDealsPost(@Nonnull CrmDealsPostRequest crmDealsPostRequest) throws ApiException {
        return this.crmDealsPost(crmDealsPostRequest, Collections.emptyMap());
    }

    public CrmDealsPost201Response crmDealsPost(@Nonnull CrmDealsPostRequest crmDealsPostRequest, Map<String, String> additionalHeaders) throws ApiException {
        CrmDealsPostRequest localVarPostBody = crmDealsPostRequest;
        if (crmDealsPostRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'crmDealsPostRequest' when calling crmDealsPost");
        }
        String localVarPath = "/crm/deals";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CrmDealsPost201Response> localVarReturnType = new TypeReference<CrmDealsPost201Response>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Pipeline> crmPipelineDetailsAllGet() throws ApiException {
        return this.crmPipelineDetailsAllGet(Collections.emptyMap());
    }

    public List<Pipeline> crmPipelineDetailsAllGet(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/crm/pipeline/details/all";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<List<Pipeline>> localVarReturnType = new TypeReference<List<Pipeline>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    @Deprecated
    public Pipeline crmPipelineDetailsGet() throws ApiException {
        return this.crmPipelineDetailsGet(Collections.emptyMap());
    }

    @Deprecated
    public Pipeline crmPipelineDetailsGet(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/crm/pipeline/details";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<Pipeline> localVarReturnType = new TypeReference<Pipeline>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Pipeline> crmPipelineDetailsPipelineIDGet(@Nonnull String pipelineID) throws ApiException {
        return this.crmPipelineDetailsPipelineIDGet(pipelineID, Collections.emptyMap());
    }

    public List<Pipeline> crmPipelineDetailsPipelineIDGet(@Nonnull String pipelineID, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (pipelineID == null) {
            throw new ApiException(400, "Missing the required parameter 'pipelineID' when calling crmPipelineDetailsPipelineIDGet");
        }
        String localVarPath = "/crm/pipeline/details/{pipelineID}".replaceAll("\\{pipelineID\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pipelineID)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<List<Pipeline>> localVarReturnType = new TypeReference<List<Pipeline>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

