/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;
import software.xdev.brevo.model.AddContactToListRequest;
import software.xdev.brevo.model.CreateAttribute;
import software.xdev.brevo.model.CreateContact;
import software.xdev.brevo.model.CreateDoiContact;
import software.xdev.brevo.model.CreateList;
import software.xdev.brevo.model.CreateModel;
import software.xdev.brevo.model.CreateUpdateContactModel;
import software.xdev.brevo.model.CreateUpdateFolder;
import software.xdev.brevo.model.CreatedProcessId;
import software.xdev.brevo.model.GetAttributes;
import software.xdev.brevo.model.GetContactCampaignStats;
import software.xdev.brevo.model.GetContactInfoIdentifierParameter;
import software.xdev.brevo.model.GetContacts;
import software.xdev.brevo.model.GetExtendedContactDetails;
import software.xdev.brevo.model.GetExtendedList;
import software.xdev.brevo.model.GetFolder;
import software.xdev.brevo.model.GetFolderLists;
import software.xdev.brevo.model.GetFolders;
import software.xdev.brevo.model.GetLists;
import software.xdev.brevo.model.GetSegments;
import software.xdev.brevo.model.PostContactInfo;
import software.xdev.brevo.model.RemoveContactFromListRequest;
import software.xdev.brevo.model.RequestContactExport;
import software.xdev.brevo.model.RequestContactImport;
import software.xdev.brevo.model.UpdateAttribute;
import software.xdev.brevo.model.UpdateBatchContacts;
import software.xdev.brevo.model.UpdateContact;
import software.xdev.brevo.model.UpdateList;

public class ContactsApi
extends BaseApi {
    public ContactsApi() {
        super(Configuration.getDefaultApiClient());
    }

    public ContactsApi(ApiClient apiClient) {
        super(apiClient);
    }

    public PostContactInfo addContactToList(@Nonnull Long listId, @Nonnull AddContactToListRequest addContactToListRequest) throws ApiException {
        return this.addContactToList(listId, addContactToListRequest, Collections.emptyMap());
    }

    public PostContactInfo addContactToList(@Nonnull Long listId, @Nonnull AddContactToListRequest addContactToListRequest, Map<String, String> additionalHeaders) throws ApiException {
        AddContactToListRequest localVarPostBody = addContactToListRequest;
        if (listId == null) {
            throw new ApiException(400, "Missing the required parameter 'listId' when calling addContactToList");
        }
        if (addContactToListRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'addContactToListRequest' when calling addContactToList");
        }
        String localVarPath = "/contacts/lists/{listId}/contacts/add".replaceAll("\\{listId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(listId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<PostContactInfo> localVarReturnType = new TypeReference<PostContactInfo>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void createAttribute(@Nonnull String attributeCategory, @Nonnull String attributeName, @Nonnull CreateAttribute createAttribute) throws ApiException {
        this.createAttribute(attributeCategory, attributeName, createAttribute, Collections.emptyMap());
    }

    public void createAttribute(@Nonnull String attributeCategory, @Nonnull String attributeName, @Nonnull CreateAttribute createAttribute, Map<String, String> additionalHeaders) throws ApiException {
        CreateAttribute localVarPostBody = createAttribute;
        if (attributeCategory == null) {
            throw new ApiException(400, "Missing the required parameter 'attributeCategory' when calling createAttribute");
        }
        if (attributeName == null) {
            throw new ApiException(400, "Missing the required parameter 'attributeName' when calling createAttribute");
        }
        if (createAttribute == null) {
            throw new ApiException(400, "Missing the required parameter 'createAttribute' when calling createAttribute");
        }
        String localVarPath = "/contacts/attributes/{attributeCategory}/{attributeName}".replaceAll("\\{attributeCategory\\}", this.apiClient.escapeString(this.apiClient.parameterToString(attributeCategory))).replaceAll("\\{attributeName\\}", this.apiClient.escapeString(this.apiClient.parameterToString(attributeName)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public CreateUpdateContactModel createContact(@Nonnull CreateContact createContact) throws ApiException {
        return this.createContact(createContact, Collections.emptyMap());
    }

    public CreateUpdateContactModel createContact(@Nonnull CreateContact createContact, Map<String, String> additionalHeaders) throws ApiException {
        CreateContact localVarPostBody = createContact;
        if (createContact == null) {
            throw new ApiException(400, "Missing the required parameter 'createContact' when calling createContact");
        }
        String localVarPath = "/contacts";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CreateUpdateContactModel> localVarReturnType = new TypeReference<CreateUpdateContactModel>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void createDoiContact(@Nonnull CreateDoiContact createDoiContact) throws ApiException {
        this.createDoiContact(createDoiContact, Collections.emptyMap());
    }

    public void createDoiContact(@Nonnull CreateDoiContact createDoiContact, Map<String, String> additionalHeaders) throws ApiException {
        CreateDoiContact localVarPostBody = createDoiContact;
        if (createDoiContact == null) {
            throw new ApiException(400, "Missing the required parameter 'createDoiContact' when calling createDoiContact");
        }
        String localVarPath = "/contacts/doubleOptinConfirmation";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public CreateModel createFolder(@Nonnull CreateUpdateFolder createFolder) throws ApiException {
        return this.createFolder(createFolder, Collections.emptyMap());
    }

    public CreateModel createFolder(@Nonnull CreateUpdateFolder createFolder, Map<String, String> additionalHeaders) throws ApiException {
        CreateUpdateFolder localVarPostBody = createFolder;
        if (createFolder == null) {
            throw new ApiException(400, "Missing the required parameter 'createFolder' when calling createFolder");
        }
        String localVarPath = "/contacts/folders";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CreateModel> localVarReturnType = new TypeReference<CreateModel>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CreateModel createList(@Nonnull CreateList createList) throws ApiException {
        return this.createList(createList, Collections.emptyMap());
    }

    public CreateModel createList(@Nonnull CreateList createList, Map<String, String> additionalHeaders) throws ApiException {
        CreateList localVarPostBody = createList;
        if (createList == null) {
            throw new ApiException(400, "Missing the required parameter 'createList' when calling createList");
        }
        String localVarPath = "/contacts/lists";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CreateModel> localVarReturnType = new TypeReference<CreateModel>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteAttribute(@Nonnull String attributeCategory, @Nonnull String attributeName) throws ApiException {
        this.deleteAttribute(attributeCategory, attributeName, Collections.emptyMap());
    }

    public void deleteAttribute(@Nonnull String attributeCategory, @Nonnull String attributeName, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (attributeCategory == null) {
            throw new ApiException(400, "Missing the required parameter 'attributeCategory' when calling deleteAttribute");
        }
        if (attributeName == null) {
            throw new ApiException(400, "Missing the required parameter 'attributeName' when calling deleteAttribute");
        }
        String localVarPath = "/contacts/attributes/{attributeCategory}/{attributeName}".replaceAll("\\{attributeCategory\\}", this.apiClient.escapeString(this.apiClient.parameterToString(attributeCategory))).replaceAll("\\{attributeName\\}", this.apiClient.escapeString(this.apiClient.parameterToString(attributeName)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteContact(@Nonnull GetContactInfoIdentifierParameter identifier, @Nullable String identifierType) throws ApiException {
        this.deleteContact(identifier, identifierType, Collections.emptyMap());
    }

    public void deleteContact(@Nonnull GetContactInfoIdentifierParameter identifier, @Nullable String identifierType, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (identifier == null) {
            throw new ApiException(400, "Missing the required parameter 'identifier' when calling deleteContact");
        }
        String localVarPath = "/contacts/{identifier}".replaceAll("\\{identifier\\}", this.apiClient.escapeString(this.apiClient.parameterToString(identifier)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("identifierType", identifierType));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteFolder(@Nonnull Long folderId) throws ApiException {
        this.deleteFolder(folderId, Collections.emptyMap());
    }

    public void deleteFolder(@Nonnull Long folderId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (folderId == null) {
            throw new ApiException(400, "Missing the required parameter 'folderId' when calling deleteFolder");
        }
        String localVarPath = "/contacts/folders/{folderId}".replaceAll("\\{folderId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(folderId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteList(@Nonnull Long listId) throws ApiException {
        this.deleteList(listId, Collections.emptyMap());
    }

    public void deleteList(@Nonnull Long listId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (listId == null) {
            throw new ApiException(400, "Missing the required parameter 'listId' when calling deleteList");
        }
        String localVarPath = "/contacts/lists/{listId}".replaceAll("\\{listId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(listId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteMultiAttributeOptions(@Nonnull String attributeType, @Nonnull String multipleChoiceAttribute, @Nonnull String multipleChoiceAttributeOption) throws ApiException {
        this.deleteMultiAttributeOptions(attributeType, multipleChoiceAttribute, multipleChoiceAttributeOption, Collections.emptyMap());
    }

    public void deleteMultiAttributeOptions(@Nonnull String attributeType, @Nonnull String multipleChoiceAttribute, @Nonnull String multipleChoiceAttributeOption, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (attributeType == null) {
            throw new ApiException(400, "Missing the required parameter 'attributeType' when calling deleteMultiAttributeOptions");
        }
        if (multipleChoiceAttribute == null) {
            throw new ApiException(400, "Missing the required parameter 'multipleChoiceAttribute' when calling deleteMultiAttributeOptions");
        }
        if (multipleChoiceAttributeOption == null) {
            throw new ApiException(400, "Missing the required parameter 'multipleChoiceAttributeOption' when calling deleteMultiAttributeOptions");
        }
        String localVarPath = "/contacts/attributes/{attributeType}/{multipleChoiceAttribute}/{multipleChoiceAttributeOption}".replaceAll("\\{attributeType\\}", this.apiClient.escapeString(this.apiClient.parameterToString(attributeType))).replaceAll("\\{multipleChoiceAttribute\\}", this.apiClient.escapeString(this.apiClient.parameterToString(multipleChoiceAttribute))).replaceAll("\\{multipleChoiceAttributeOption\\}", this.apiClient.escapeString(this.apiClient.parameterToString(multipleChoiceAttributeOption)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public GetAttributes getAttributes() throws ApiException {
        return this.getAttributes(Collections.emptyMap());
    }

    public GetAttributes getAttributes(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/contacts/attributes";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetAttributes> localVarReturnType = new TypeReference<GetAttributes>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetExtendedContactDetails getContactInfo(@Nonnull GetContactInfoIdentifierParameter identifier, @Nullable String identifierType, @Nullable String startDate, @Nullable String endDate) throws ApiException {
        return this.getContactInfo(identifier, identifierType, startDate, endDate, Collections.emptyMap());
    }

    public GetExtendedContactDetails getContactInfo(@Nonnull GetContactInfoIdentifierParameter identifier, @Nullable String identifierType, @Nullable String startDate, @Nullable String endDate, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (identifier == null) {
            throw new ApiException(400, "Missing the required parameter 'identifier' when calling getContactInfo");
        }
        String localVarPath = "/contacts/{identifier}".replaceAll("\\{identifier\\}", this.apiClient.escapeString(this.apiClient.parameterToString(identifier)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("identifierType", identifierType));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetExtendedContactDetails> localVarReturnType = new TypeReference<GetExtendedContactDetails>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetContactCampaignStats getContactStats(@Nonnull GetContactInfoIdentifierParameter identifier, @Nullable String startDate, @Nullable String endDate) throws ApiException {
        return this.getContactStats(identifier, startDate, endDate, Collections.emptyMap());
    }

    public GetContactCampaignStats getContactStats(@Nonnull GetContactInfoIdentifierParameter identifier, @Nullable String startDate, @Nullable String endDate, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (identifier == null) {
            throw new ApiException(400, "Missing the required parameter 'identifier' when calling getContactStats");
        }
        String localVarPath = "/contacts/{identifier}/campaignStats".replaceAll("\\{identifier\\}", this.apiClient.escapeString(this.apiClient.parameterToString(identifier)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetContactCampaignStats> localVarReturnType = new TypeReference<GetContactCampaignStats>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetContacts getContacts(@Nullable Long limit, @Nullable Long offset, @Nullable String modifiedSince, @Nullable String createdSince, @Nullable String sort, @Nullable Long segmentId, @Nullable List<Long> listIds, @Nullable String filter) throws ApiException {
        return this.getContacts(limit, offset, modifiedSince, createdSince, sort, segmentId, listIds, filter, Collections.emptyMap());
    }

    public GetContacts getContacts(@Nullable Long limit, @Nullable Long offset, @Nullable String modifiedSince, @Nullable String createdSince, @Nullable String sort, @Nullable Long segmentId, @Nullable List<Long> listIds, @Nullable String filter, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/contacts";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("modifiedSince", modifiedSince));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("createdSince", createdSince));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("segmentId", segmentId));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "listIds", listIds));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("filter", filter));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetContacts> localVarReturnType = new TypeReference<GetContacts>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetContacts getContactsFromList(@Nonnull Long listId, @Nullable String modifiedSince, @Nullable Long limit, @Nullable Long offset, @Nullable String sort) throws ApiException {
        return this.getContactsFromList(listId, modifiedSince, limit, offset, sort, Collections.emptyMap());
    }

    public GetContacts getContactsFromList(@Nonnull Long listId, @Nullable String modifiedSince, @Nullable Long limit, @Nullable Long offset, @Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (listId == null) {
            throw new ApiException(400, "Missing the required parameter 'listId' when calling getContactsFromList");
        }
        String localVarPath = "/contacts/lists/{listId}/contacts".replaceAll("\\{listId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(listId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("modifiedSince", modifiedSince));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetContacts> localVarReturnType = new TypeReference<GetContacts>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetFolder getFolder(@Nonnull Long folderId) throws ApiException {
        return this.getFolder(folderId, Collections.emptyMap());
    }

    public GetFolder getFolder(@Nonnull Long folderId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (folderId == null) {
            throw new ApiException(400, "Missing the required parameter 'folderId' when calling getFolder");
        }
        String localVarPath = "/contacts/folders/{folderId}".replaceAll("\\{folderId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(folderId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetFolder> localVarReturnType = new TypeReference<GetFolder>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetFolderLists getFolderLists(@Nonnull Long folderId, @Nullable Long limit, @Nullable Long offset, @Nullable String sort) throws ApiException {
        return this.getFolderLists(folderId, limit, offset, sort, Collections.emptyMap());
    }

    public GetFolderLists getFolderLists(@Nonnull Long folderId, @Nullable Long limit, @Nullable Long offset, @Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (folderId == null) {
            throw new ApiException(400, "Missing the required parameter 'folderId' when calling getFolderLists");
        }
        String localVarPath = "/contacts/folders/{folderId}/lists".replaceAll("\\{folderId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(folderId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetFolderLists> localVarReturnType = new TypeReference<GetFolderLists>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetFolders getFolders(@Nullable Long limit, @Nullable Long offset, @Nullable String sort) throws ApiException {
        return this.getFolders(limit, offset, sort, Collections.emptyMap());
    }

    public GetFolders getFolders(@Nullable Long limit, @Nullable Long offset, @Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/contacts/folders";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetFolders> localVarReturnType = new TypeReference<GetFolders>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetExtendedList getList(@Nonnull Long listId, @Nullable String startDate, @Nullable String endDate) throws ApiException {
        return this.getList(listId, startDate, endDate, Collections.emptyMap());
    }

    public GetExtendedList getList(@Nonnull Long listId, @Nullable String startDate, @Nullable String endDate, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (listId == null) {
            throw new ApiException(400, "Missing the required parameter 'listId' when calling getList");
        }
        String localVarPath = "/contacts/lists/{listId}".replaceAll("\\{listId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(listId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetExtendedList> localVarReturnType = new TypeReference<GetExtendedList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetLists getLists(@Nullable Long limit, @Nullable Long offset, @Nullable String sort) throws ApiException {
        return this.getLists(limit, offset, sort, Collections.emptyMap());
    }

    public GetLists getLists(@Nullable Long limit, @Nullable Long offset, @Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/contacts/lists";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetLists> localVarReturnType = new TypeReference<GetLists>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GetSegments getSegments(@Nullable Long limit, @Nullable Long offset, @Nullable String sort) throws ApiException {
        return this.getSegments(limit, offset, sort, Collections.emptyMap());
    }

    public GetSegments getSegments(@Nullable Long limit, @Nullable Long offset, @Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/contacts/segments";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<GetSegments> localVarReturnType = new TypeReference<GetSegments>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CreatedProcessId importContacts(@Nonnull RequestContactImport requestContactImport) throws ApiException {
        return this.importContacts(requestContactImport, Collections.emptyMap());
    }

    public CreatedProcessId importContacts(@Nonnull RequestContactImport requestContactImport, Map<String, String> additionalHeaders) throws ApiException {
        RequestContactImport localVarPostBody = requestContactImport;
        if (requestContactImport == null) {
            throw new ApiException(400, "Missing the required parameter 'requestContactImport' when calling importContacts");
        }
        String localVarPath = "/contacts/import";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CreatedProcessId> localVarReturnType = new TypeReference<CreatedProcessId>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PostContactInfo removeContactFromList(@Nonnull Long listId, @Nonnull RemoveContactFromListRequest contactEmails) throws ApiException {
        return this.removeContactFromList(listId, contactEmails, Collections.emptyMap());
    }

    public PostContactInfo removeContactFromList(@Nonnull Long listId, @Nonnull RemoveContactFromListRequest contactEmails, Map<String, String> additionalHeaders) throws ApiException {
        RemoveContactFromListRequest localVarPostBody = contactEmails;
        if (listId == null) {
            throw new ApiException(400, "Missing the required parameter 'listId' when calling removeContactFromList");
        }
        if (contactEmails == null) {
            throw new ApiException(400, "Missing the required parameter 'contactEmails' when calling removeContactFromList");
        }
        String localVarPath = "/contacts/lists/{listId}/contacts/remove".replaceAll("\\{listId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(listId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<PostContactInfo> localVarReturnType = new TypeReference<PostContactInfo>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CreatedProcessId requestContactExport(@Nonnull RequestContactExport requestContactExport) throws ApiException {
        return this.requestContactExport(requestContactExport, Collections.emptyMap());
    }

    public CreatedProcessId requestContactExport(@Nonnull RequestContactExport requestContactExport, Map<String, String> additionalHeaders) throws ApiException {
        RequestContactExport localVarPostBody = requestContactExport;
        if (requestContactExport == null) {
            throw new ApiException(400, "Missing the required parameter 'requestContactExport' when calling requestContactExport");
        }
        String localVarPath = "/contacts/export";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CreatedProcessId> localVarReturnType = new TypeReference<CreatedProcessId>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void updateAttribute(@Nonnull String attributeCategory, @Nonnull String attributeName, @Nonnull UpdateAttribute updateAttribute) throws ApiException {
        this.updateAttribute(attributeCategory, attributeName, updateAttribute, Collections.emptyMap());
    }

    public void updateAttribute(@Nonnull String attributeCategory, @Nonnull String attributeName, @Nonnull UpdateAttribute updateAttribute, Map<String, String> additionalHeaders) throws ApiException {
        UpdateAttribute localVarPostBody = updateAttribute;
        if (attributeCategory == null) {
            throw new ApiException(400, "Missing the required parameter 'attributeCategory' when calling updateAttribute");
        }
        if (attributeName == null) {
            throw new ApiException(400, "Missing the required parameter 'attributeName' when calling updateAttribute");
        }
        if (updateAttribute == null) {
            throw new ApiException(400, "Missing the required parameter 'updateAttribute' when calling updateAttribute");
        }
        String localVarPath = "/contacts/attributes/{attributeCategory}/{attributeName}".replaceAll("\\{attributeCategory\\}", this.apiClient.escapeString(this.apiClient.parameterToString(attributeCategory))).replaceAll("\\{attributeName\\}", this.apiClient.escapeString(this.apiClient.parameterToString(attributeName)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void updateBatchContacts(@Nonnull UpdateBatchContacts updateBatchContacts) throws ApiException {
        this.updateBatchContacts(updateBatchContacts, Collections.emptyMap());
    }

    public void updateBatchContacts(@Nonnull UpdateBatchContacts updateBatchContacts, Map<String, String> additionalHeaders) throws ApiException {
        UpdateBatchContacts localVarPostBody = updateBatchContacts;
        if (updateBatchContacts == null) {
            throw new ApiException(400, "Missing the required parameter 'updateBatchContacts' when calling updateBatchContacts");
        }
        String localVarPath = "/contacts/batch";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void updateContact(@Nonnull GetContactInfoIdentifierParameter identifier, @Nonnull UpdateContact updateContact, @Nullable String identifierType) throws ApiException {
        this.updateContact(identifier, updateContact, identifierType, Collections.emptyMap());
    }

    public void updateContact(@Nonnull GetContactInfoIdentifierParameter identifier, @Nonnull UpdateContact updateContact, @Nullable String identifierType, Map<String, String> additionalHeaders) throws ApiException {
        UpdateContact localVarPostBody = updateContact;
        if (identifier == null) {
            throw new ApiException(400, "Missing the required parameter 'identifier' when calling updateContact");
        }
        if (updateContact == null) {
            throw new ApiException(400, "Missing the required parameter 'updateContact' when calling updateContact");
        }
        String localVarPath = "/contacts/{identifier}".replaceAll("\\{identifier\\}", this.apiClient.escapeString(this.apiClient.parameterToString(identifier)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("identifierType", identifierType));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void updateFolder(@Nonnull Long folderId, @Nonnull CreateUpdateFolder updateFolder) throws ApiException {
        this.updateFolder(folderId, updateFolder, Collections.emptyMap());
    }

    public void updateFolder(@Nonnull Long folderId, @Nonnull CreateUpdateFolder updateFolder, Map<String, String> additionalHeaders) throws ApiException {
        CreateUpdateFolder localVarPostBody = updateFolder;
        if (folderId == null) {
            throw new ApiException(400, "Missing the required parameter 'folderId' when calling updateFolder");
        }
        if (updateFolder == null) {
            throw new ApiException(400, "Missing the required parameter 'updateFolder' when calling updateFolder");
        }
        String localVarPath = "/contacts/folders/{folderId}".replaceAll("\\{folderId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(folderId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void updateList(@Nonnull Long listId, @Nonnull UpdateList updateList) throws ApiException {
        this.updateList(listId, updateList, Collections.emptyMap());
    }

    public void updateList(@Nonnull Long listId, @Nonnull UpdateList updateList, Map<String, String> additionalHeaders) throws ApiException {
        UpdateList localVarPostBody = updateList;
        if (listId == null) {
            throw new ApiException(400, "Missing the required parameter 'listId' when calling updateList");
        }
        if (updateList == null) {
            throw new ApiException(400, "Missing the required parameter 'updateList' when calling updateList");
        }
        String localVarPath = "/contacts/lists/{listId}".replaceAll("\\{listId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(listId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

