/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;
import software.xdev.brevo.model.CompaniesIdPatchRequest;
import software.xdev.brevo.model.CompaniesImportPost200Response;
import software.xdev.brevo.model.CompaniesLinkUnlinkIdPatchRequest;
import software.xdev.brevo.model.CompaniesList;
import software.xdev.brevo.model.CompaniesPost200Response;
import software.xdev.brevo.model.CompaniesPostRequest;
import software.xdev.brevo.model.Company;
import software.xdev.brevo.model.CompanyAttributesInner;
import software.xdev.brevo.model.CrmAttributesPost200Response;
import software.xdev.brevo.model.CrmAttributesPostRequest;

public class CompaniesApi
extends BaseApi {
    public CompaniesApi() {
        super(Configuration.getDefaultApiClient());
    }

    public CompaniesApi(ApiClient apiClient) {
        super(apiClient);
    }

    public CompaniesList companiesGet(@Nullable String filters, @Nullable Long linkedContactsIds, @Nullable String linkedDealsIds, @Nullable String modifiedSince, @Nullable String createdSince, @Nullable Long page, @Nullable Long limit, @Nullable String sort, @Nullable String sortBy) throws ApiException {
        return this.companiesGet(filters, linkedContactsIds, linkedDealsIds, modifiedSince, createdSince, page, limit, sort, sortBy, Collections.emptyMap());
    }

    public CompaniesList companiesGet(@Nullable String filters, @Nullable Long linkedContactsIds, @Nullable String linkedDealsIds, @Nullable String modifiedSince, @Nullable String createdSince, @Nullable Long page, @Nullable Long limit, @Nullable String sort, @Nullable String sortBy, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/companies";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("filters", filters));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("linkedContactsIds", linkedContactsIds));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("linkedDealsIds", linkedDealsIds));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("modifiedSince", modifiedSince));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("createdSince", createdSince));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CompaniesList> localVarReturnType = new TypeReference<CompaniesList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void companiesIdDelete(@Nonnull String id) throws ApiException {
        this.companiesIdDelete(id, Collections.emptyMap());
    }

    public void companiesIdDelete(@Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling companiesIdDelete");
        }
        String localVarPath = "/companies/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public Company companiesIdGet(@Nonnull String id) throws ApiException {
        return this.companiesIdGet(id, Collections.emptyMap());
    }

    public Company companiesIdGet(@Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling companiesIdGet");
        }
        String localVarPath = "/companies/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<Company> localVarReturnType = new TypeReference<Company>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Company companiesIdPatch(@Nonnull String id, @Nonnull CompaniesIdPatchRequest companiesIdPatchRequest) throws ApiException {
        return this.companiesIdPatch(id, companiesIdPatchRequest, Collections.emptyMap());
    }

    public Company companiesIdPatch(@Nonnull String id, @Nonnull CompaniesIdPatchRequest companiesIdPatchRequest, Map<String, String> additionalHeaders) throws ApiException {
        CompaniesIdPatchRequest localVarPostBody = companiesIdPatchRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling companiesIdPatch");
        }
        if (companiesIdPatchRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'companiesIdPatchRequest' when calling companiesIdPatch");
        }
        String localVarPath = "/companies/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<Company> localVarReturnType = new TypeReference<Company>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CompaniesImportPost200Response companiesImportPost(@Nullable File _file, @Nullable Object mapping) throws ApiException {
        return this.companiesImportPost(_file, mapping, Collections.emptyMap());
    }

    public CompaniesImportPost200Response companiesImportPost(@Nullable File _file, @Nullable Object mapping, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/companies/import";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        if (_file != null) {
            localVarFormParams.put("file", _file);
        }
        if (mapping != null) {
            localVarFormParams.put("mapping", mapping);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CompaniesImportPost200Response> localVarReturnType = new TypeReference<CompaniesImportPost200Response>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void companiesLinkUnlinkIdPatch(@Nonnull String id, @Nonnull CompaniesLinkUnlinkIdPatchRequest companiesLinkUnlinkIdPatchRequest) throws ApiException {
        this.companiesLinkUnlinkIdPatch(id, companiesLinkUnlinkIdPatchRequest, Collections.emptyMap());
    }

    public void companiesLinkUnlinkIdPatch(@Nonnull String id, @Nonnull CompaniesLinkUnlinkIdPatchRequest companiesLinkUnlinkIdPatchRequest, Map<String, String> additionalHeaders) throws ApiException {
        CompaniesLinkUnlinkIdPatchRequest localVarPostBody = companiesLinkUnlinkIdPatchRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling companiesLinkUnlinkIdPatch");
        }
        if (companiesLinkUnlinkIdPatchRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'companiesLinkUnlinkIdPatchRequest' when calling companiesLinkUnlinkIdPatch");
        }
        String localVarPath = "/companies/link-unlink/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public CompaniesPost200Response companiesPost(@Nonnull CompaniesPostRequest companiesPostRequest) throws ApiException {
        return this.companiesPost(companiesPostRequest, Collections.emptyMap());
    }

    public CompaniesPost200Response companiesPost(@Nonnull CompaniesPostRequest companiesPostRequest, Map<String, String> additionalHeaders) throws ApiException {
        CompaniesPostRequest localVarPostBody = companiesPostRequest;
        if (companiesPostRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'companiesPostRequest' when calling companiesPost");
        }
        String localVarPath = "/companies";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CompaniesPost200Response> localVarReturnType = new TypeReference<CompaniesPost200Response>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<CompanyAttributesInner> crmAttributesCompaniesGet() throws ApiException {
        return this.crmAttributesCompaniesGet(Collections.emptyMap());
    }

    public List<CompanyAttributesInner> crmAttributesCompaniesGet(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/crm/attributes/companies";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<List<CompanyAttributesInner>> localVarReturnType = new TypeReference<List<CompanyAttributesInner>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CrmAttributesPost200Response crmAttributesPost(@Nonnull CrmAttributesPostRequest crmAttributesPostRequest) throws ApiException {
        return this.crmAttributesPost(crmAttributesPostRequest, Collections.emptyMap());
    }

    public CrmAttributesPost200Response crmAttributesPost(@Nonnull CrmAttributesPostRequest crmAttributesPostRequest, Map<String, String> additionalHeaders) throws ApiException {
        CrmAttributesPostRequest localVarPostBody = crmAttributesPostRequest;
        if (crmAttributesPostRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'crmAttributesPostRequest' when calling crmAttributesPost");
        }
        String localVarPath = "/crm/attributes";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<CrmAttributesPost200Response> localVarReturnType = new TypeReference<CrmAttributesPost200Response>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

