/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.UUID;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;
import software.xdev.brevo.model.Balance;
import software.xdev.brevo.model.BalanceDefinition;
import software.xdev.brevo.model.BalanceDefinitionPage;
import software.xdev.brevo.model.BalanceLimit;
import software.xdev.brevo.model.BalanceOrder;
import software.xdev.brevo.model.ContactBalancesResp;
import software.xdev.brevo.model.CreateBalanceDefinitionPayload;
import software.xdev.brevo.model.CreateBalanceLimitPayload;
import software.xdev.brevo.model.CreateBalancePayload;
import software.xdev.brevo.model.CreateOrderPayload;
import software.xdev.brevo.model.CreateTransactionPayload;
import software.xdev.brevo.model.ModelSubscriptionBalanceResp;
import software.xdev.brevo.model.Transaction;
import software.xdev.brevo.model.TransactionHistoryResp;
import software.xdev.brevo.model.UpdateBalanceDefinitionPayload;
import software.xdev.brevo.model.UpdateBalanceLimitPayload;

public class BalanceApi
extends BaseApi {
    public BalanceApi() {
        super(Configuration.getDefaultApiClient());
    }

    public BalanceApi(ApiClient apiClient) {
        super(apiClient);
    }

    public Transaction beginTransaction(@Nonnull UUID pid, @Nonnull CreateTransactionPayload createTransactionPayload) throws ApiException {
        return this.beginTransaction(pid, createTransactionPayload, Collections.emptyMap());
    }

    public Transaction beginTransaction(@Nonnull UUID pid, @Nonnull CreateTransactionPayload createTransactionPayload, Map<String, String> additionalHeaders) throws ApiException {
        CreateTransactionPayload localVarPostBody = createTransactionPayload;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling beginTransaction");
        }
        if (createTransactionPayload == null) {
            throw new ApiException(400, "Missing the required parameter 'createTransactionPayload' when calling beginTransaction");
        }
        String localVarPath = "/loyalty/balance/programs/{pid}/transactions".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<Transaction> localVarReturnType = new TypeReference<Transaction>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Transaction cancelTransaction(@Nonnull UUID pid, @Nonnull UUID tid) throws ApiException {
        return this.cancelTransaction(pid, tid, Collections.emptyMap());
    }

    public Transaction cancelTransaction(@Nonnull UUID pid, @Nonnull UUID tid, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling cancelTransaction");
        }
        if (tid == null) {
            throw new ApiException(400, "Missing the required parameter 'tid' when calling cancelTransaction");
        }
        String localVarPath = "/loyalty/balance/programs/{pid}/transactions/{tid}/cancel".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid))).replaceAll("\\{tid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(tid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<Transaction> localVarReturnType = new TypeReference<Transaction>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Transaction completeTransaction(@Nonnull UUID pid, @Nonnull UUID tid) throws ApiException {
        return this.completeTransaction(pid, tid, Collections.emptyMap());
    }

    public Transaction completeTransaction(@Nonnull UUID pid, @Nonnull UUID tid, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling completeTransaction");
        }
        if (tid == null) {
            throw new ApiException(400, "Missing the required parameter 'tid' when calling completeTransaction");
        }
        String localVarPath = "/loyalty/balance/programs/{pid}/transactions/{tid}/complete".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid))).replaceAll("\\{tid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(tid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<Transaction> localVarReturnType = new TypeReference<Transaction>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BalanceLimit createBalanceLimit(@Nonnull UUID pid, @Nonnull UUID bdid, @Nonnull CreateBalanceLimitPayload createBalanceLimitPayload) throws ApiException {
        return this.createBalanceLimit(pid, bdid, createBalanceLimitPayload, Collections.emptyMap());
    }

    public BalanceLimit createBalanceLimit(@Nonnull UUID pid, @Nonnull UUID bdid, @Nonnull CreateBalanceLimitPayload createBalanceLimitPayload, Map<String, String> additionalHeaders) throws ApiException {
        CreateBalanceLimitPayload localVarPostBody = createBalanceLimitPayload;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling createBalanceLimit");
        }
        if (bdid == null) {
            throw new ApiException(400, "Missing the required parameter 'bdid' when calling createBalanceLimit");
        }
        if (createBalanceLimitPayload == null) {
            throw new ApiException(400, "Missing the required parameter 'createBalanceLimitPayload' when calling createBalanceLimit");
        }
        String localVarPath = "/loyalty/balance/programs/{pid}/balance-definitions/{bdid}/limits".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid))).replaceAll("\\{bdid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(bdid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<BalanceLimit> localVarReturnType = new TypeReference<BalanceLimit>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BalanceOrder createBalanceOrder(@Nonnull UUID pid, @Nonnull CreateOrderPayload createOrderPayload) throws ApiException {
        return this.createBalanceOrder(pid, createOrderPayload, Collections.emptyMap());
    }

    public BalanceOrder createBalanceOrder(@Nonnull UUID pid, @Nonnull CreateOrderPayload createOrderPayload, Map<String, String> additionalHeaders) throws ApiException {
        CreateOrderPayload localVarPostBody = createOrderPayload;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling createBalanceOrder");
        }
        if (createOrderPayload == null) {
            throw new ApiException(400, "Missing the required parameter 'createOrderPayload' when calling createBalanceOrder");
        }
        String localVarPath = "/loyalty/balance/programs/{pid}/create-order".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<BalanceOrder> localVarReturnType = new TypeReference<BalanceOrder>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteBalanceDefinition(@Nonnull UUID pid, @Nonnull UUID bdid) throws ApiException {
        this.deleteBalanceDefinition(pid, bdid, Collections.emptyMap());
    }

    public void deleteBalanceDefinition(@Nonnull UUID pid, @Nonnull UUID bdid, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling deleteBalanceDefinition");
        }
        if (bdid == null) {
            throw new ApiException(400, "Missing the required parameter 'bdid' when calling deleteBalanceDefinition");
        }
        String localVarPath = "/loyalty/balance/programs/{pid}/balance-definitions/{bdid}".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid))).replaceAll("\\{bdid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(bdid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteBalanceLimit(@Nonnull UUID pid, @Nonnull UUID bdid, @Nonnull UUID blid) throws ApiException {
        this.deleteBalanceLimit(pid, bdid, blid, Collections.emptyMap());
    }

    public void deleteBalanceLimit(@Nonnull UUID pid, @Nonnull UUID bdid, @Nonnull UUID blid, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling deleteBalanceLimit");
        }
        if (bdid == null) {
            throw new ApiException(400, "Missing the required parameter 'bdid' when calling deleteBalanceLimit");
        }
        if (blid == null) {
            throw new ApiException(400, "Missing the required parameter 'blid' when calling deleteBalanceLimit");
        }
        String localVarPath = "/loyalty/balance/programs/{pid}/balance-definitions/{bdid}/limits/{blid}".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid))).replaceAll("\\{bdid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(bdid))).replaceAll("\\{blid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(blid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public BalanceDefinition getBalanceDefinition(@Nonnull UUID pid, @Nonnull UUID bdid, @Nullable String version) throws ApiException {
        return this.getBalanceDefinition(pid, bdid, version, Collections.emptyMap());
    }

    public BalanceDefinition getBalanceDefinition(@Nonnull UUID pid, @Nonnull UUID bdid, @Nullable String version, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling getBalanceDefinition");
        }
        if (bdid == null) {
            throw new ApiException(400, "Missing the required parameter 'bdid' when calling getBalanceDefinition");
        }
        String localVarPath = "/loyalty/balance/programs/{pid}/balance-definitions/{bdid}".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid))).replaceAll("\\{bdid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(bdid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("version", version));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<BalanceDefinition> localVarReturnType = new TypeReference<BalanceDefinition>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BalanceDefinitionPage getBalanceDefinitionList(@Nonnull UUID pid, @Nullable Integer limit, @Nullable Integer offset, @Nullable String sortField, @Nullable String sort, @Nullable String version) throws ApiException {
        return this.getBalanceDefinitionList(pid, limit, offset, sortField, sort, version, Collections.emptyMap());
    }

    public BalanceDefinitionPage getBalanceDefinitionList(@Nonnull UUID pid, @Nullable Integer limit, @Nullable Integer offset, @Nullable String sortField, @Nullable String sort, @Nullable String version, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling getBalanceDefinitionList");
        }
        String localVarPath = "/loyalty/balance/programs/{pid}/balance-definitions".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortField", sortField));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("version", version));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<BalanceDefinitionPage> localVarReturnType = new TypeReference<BalanceDefinitionPage>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BalanceLimit getBalanceLimit(@Nonnull UUID pid, @Nonnull UUID bdid, @Nonnull UUID blid, @Nullable String version) throws ApiException {
        return this.getBalanceLimit(pid, bdid, blid, version, Collections.emptyMap());
    }

    public BalanceLimit getBalanceLimit(@Nonnull UUID pid, @Nonnull UUID bdid, @Nonnull UUID blid, @Nullable String version, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling getBalanceLimit");
        }
        if (bdid == null) {
            throw new ApiException(400, "Missing the required parameter 'bdid' when calling getBalanceLimit");
        }
        if (blid == null) {
            throw new ApiException(400, "Missing the required parameter 'blid' when calling getBalanceLimit");
        }
        String localVarPath = "/loyalty/balance/programs/{pid}/balance-definitions/{bdid}/limits/{blid}".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid))).replaceAll("\\{bdid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(bdid))).replaceAll("\\{blid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(blid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("version", version));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<BalanceLimit> localVarReturnType = new TypeReference<BalanceLimit>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ContactBalancesResp getContactBalances(@Nonnull UUID pid) throws ApiException {
        return this.getContactBalances(pid, Collections.emptyMap());
    }

    public ContactBalancesResp getContactBalances(@Nonnull UUID pid, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling getContactBalances");
        }
        String localVarPath = "/loyalty/balance/programs/{pid}/contact-balances".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<ContactBalancesResp> localVarReturnType = new TypeReference<ContactBalancesResp>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ModelSubscriptionBalanceResp getSubscriptionBalances(@Nonnull Integer cid, @Nonnull UUID pid) throws ApiException {
        return this.getSubscriptionBalances(cid, pid, Collections.emptyMap());
    }

    public ModelSubscriptionBalanceResp getSubscriptionBalances(@Nonnull Integer cid, @Nonnull UUID pid, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (cid == null) {
            throw new ApiException(400, "Missing the required parameter 'cid' when calling getSubscriptionBalances");
        }
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling getSubscriptionBalances");
        }
        String localVarPath = "/loyalty/balance/programs/{pid}/subscriptions/{cid}/balances".replaceAll("\\{cid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(cid))).replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<ModelSubscriptionBalanceResp> localVarReturnType = new TypeReference<ModelSubscriptionBalanceResp>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BalanceLimit loyaltyBalanceProgramsPidActiveBalanceGet(@Nonnull UUID pid, @Nonnull Integer contactId, @Nonnull UUID balanceDefinitionId, @Nullable Integer limit, @Nullable Integer offset, @Nullable String sortField, @Nullable String sort) throws ApiException {
        return this.loyaltyBalanceProgramsPidActiveBalanceGet(pid, contactId, balanceDefinitionId, limit, offset, sortField, sort, Collections.emptyMap());
    }

    public BalanceLimit loyaltyBalanceProgramsPidActiveBalanceGet(@Nonnull UUID pid, @Nonnull Integer contactId, @Nonnull UUID balanceDefinitionId, @Nullable Integer limit, @Nullable Integer offset, @Nullable String sortField, @Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling loyaltyBalanceProgramsPidActiveBalanceGet");
        }
        if (contactId == null) {
            throw new ApiException(400, "Missing the required parameter 'contactId' when calling loyaltyBalanceProgramsPidActiveBalanceGet");
        }
        if (balanceDefinitionId == null) {
            throw new ApiException(400, "Missing the required parameter 'balanceDefinitionId' when calling loyaltyBalanceProgramsPidActiveBalanceGet");
        }
        String localVarPath = "/loyalty/balance/programs/{pid}/active-balance".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort_field", sortField));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("contact_id", contactId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("balance_definition_id", balanceDefinitionId));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<BalanceLimit> localVarReturnType = new TypeReference<BalanceLimit>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BalanceDefinition loyaltyBalanceProgramsPidBalanceDefinitionsPost(@Nonnull UUID pid, @Nonnull CreateBalanceDefinitionPayload createBalanceDefinitionPayload) throws ApiException {
        return this.loyaltyBalanceProgramsPidBalanceDefinitionsPost(pid, createBalanceDefinitionPayload, Collections.emptyMap());
    }

    public BalanceDefinition loyaltyBalanceProgramsPidBalanceDefinitionsPost(@Nonnull UUID pid, @Nonnull CreateBalanceDefinitionPayload createBalanceDefinitionPayload, Map<String, String> additionalHeaders) throws ApiException {
        CreateBalanceDefinitionPayload localVarPostBody = createBalanceDefinitionPayload;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling loyaltyBalanceProgramsPidBalanceDefinitionsPost");
        }
        if (createBalanceDefinitionPayload == null) {
            throw new ApiException(400, "Missing the required parameter 'createBalanceDefinitionPayload' when calling loyaltyBalanceProgramsPidBalanceDefinitionsPost");
        }
        String localVarPath = "/loyalty/balance/programs/{pid}/balance-definitions".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<BalanceDefinition> localVarReturnType = new TypeReference<BalanceDefinition>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Balance loyaltyBalanceProgramsPidSubscriptionsCidBalancesPost(@Nonnull UUID pid, @Nonnull UUID cid, @Nonnull CreateBalancePayload createBalancePayload) throws ApiException {
        return this.loyaltyBalanceProgramsPidSubscriptionsCidBalancesPost(pid, cid, createBalancePayload, Collections.emptyMap());
    }

    public Balance loyaltyBalanceProgramsPidSubscriptionsCidBalancesPost(@Nonnull UUID pid, @Nonnull UUID cid, @Nonnull CreateBalancePayload createBalancePayload, Map<String, String> additionalHeaders) throws ApiException {
        CreateBalancePayload localVarPostBody = createBalancePayload;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling loyaltyBalanceProgramsPidSubscriptionsCidBalancesPost");
        }
        if (cid == null) {
            throw new ApiException(400, "Missing the required parameter 'cid' when calling loyaltyBalanceProgramsPidSubscriptionsCidBalancesPost");
        }
        if (createBalancePayload == null) {
            throw new ApiException(400, "Missing the required parameter 'createBalancePayload' when calling loyaltyBalanceProgramsPidSubscriptionsCidBalancesPost");
        }
        String localVarPath = "/loyalty/balance/programs/{pid}/subscriptions/{cid}/balances".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid))).replaceAll("\\{cid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(cid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<Balance> localVarReturnType = new TypeReference<Balance>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public TransactionHistoryResp loyaltyBalanceProgramsPidTransactionHistoryGet(@Nonnull UUID pid, @Nonnull Integer contactId, @Nonnull UUID balanceDefinitionId, @Nullable Integer limit, @Nullable Integer offset, @Nullable String sortField, @Nullable String sort, @Nullable List<String> filters) throws ApiException {
        return this.loyaltyBalanceProgramsPidTransactionHistoryGet(pid, contactId, balanceDefinitionId, limit, offset, sortField, sort, filters, Collections.emptyMap());
    }

    public TransactionHistoryResp loyaltyBalanceProgramsPidTransactionHistoryGet(@Nonnull UUID pid, @Nonnull Integer contactId, @Nonnull UUID balanceDefinitionId, @Nullable Integer limit, @Nullable Integer offset, @Nullable String sortField, @Nullable String sort, @Nullable List<String> filters, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling loyaltyBalanceProgramsPidTransactionHistoryGet");
        }
        if (contactId == null) {
            throw new ApiException(400, "Missing the required parameter 'contactId' when calling loyaltyBalanceProgramsPidTransactionHistoryGet");
        }
        if (balanceDefinitionId == null) {
            throw new ApiException(400, "Missing the required parameter 'balanceDefinitionId' when calling loyaltyBalanceProgramsPidTransactionHistoryGet");
        }
        String localVarPath = "/loyalty/balance/programs/{pid}/transaction-history".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort_field", sortField));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("contact_id", contactId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("balance_definition_id", balanceDefinitionId));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "filters", filters));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<TransactionHistoryResp> localVarReturnType = new TypeReference<TransactionHistoryResp>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BalanceDefinition updateBalanceDefinition(@Nonnull UUID pid, @Nonnull UUID bdid, @Nonnull UpdateBalanceDefinitionPayload updateBalanceDefinitionPayload) throws ApiException {
        return this.updateBalanceDefinition(pid, bdid, updateBalanceDefinitionPayload, Collections.emptyMap());
    }

    public BalanceDefinition updateBalanceDefinition(@Nonnull UUID pid, @Nonnull UUID bdid, @Nonnull UpdateBalanceDefinitionPayload updateBalanceDefinitionPayload, Map<String, String> additionalHeaders) throws ApiException {
        UpdateBalanceDefinitionPayload localVarPostBody = updateBalanceDefinitionPayload;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling updateBalanceDefinition");
        }
        if (bdid == null) {
            throw new ApiException(400, "Missing the required parameter 'bdid' when calling updateBalanceDefinition");
        }
        if (updateBalanceDefinitionPayload == null) {
            throw new ApiException(400, "Missing the required parameter 'updateBalanceDefinitionPayload' when calling updateBalanceDefinition");
        }
        String localVarPath = "/loyalty/balance/programs/{pid}/balance-definitions/{bdid}".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid))).replaceAll("\\{bdid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(bdid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<BalanceDefinition> localVarReturnType = new TypeReference<BalanceDefinition>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BalanceLimit updateBalanceLimit(@Nonnull UUID pid, @Nonnull UUID bdid, @Nonnull UUID blid, @Nonnull UpdateBalanceLimitPayload updateBalanceLimitPayload) throws ApiException {
        return this.updateBalanceLimit(pid, bdid, blid, updateBalanceLimitPayload, Collections.emptyMap());
    }

    public BalanceLimit updateBalanceLimit(@Nonnull UUID pid, @Nonnull UUID bdid, @Nonnull UUID blid, @Nonnull UpdateBalanceLimitPayload updateBalanceLimitPayload, Map<String, String> additionalHeaders) throws ApiException {
        UpdateBalanceLimitPayload localVarPostBody = updateBalanceLimitPayload;
        if (pid == null) {
            throw new ApiException(400, "Missing the required parameter 'pid' when calling updateBalanceLimit");
        }
        if (bdid == null) {
            throw new ApiException(400, "Missing the required parameter 'bdid' when calling updateBalanceLimit");
        }
        if (blid == null) {
            throw new ApiException(400, "Missing the required parameter 'blid' when calling updateBalanceLimit");
        }
        if (updateBalanceLimitPayload == null) {
            throw new ApiException(400, "Missing the required parameter 'updateBalanceLimitPayload' when calling updateBalanceLimit");
        }
        String localVarPath = "/loyalty/balance/programs/{pid}/balance-definitions/{bdid}/limits/{blid}".replaceAll("\\{pid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(pid))).replaceAll("\\{bdid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(bdid))).replaceAll("\\{blid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(blid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        TypeReference<BalanceLimit> localVarReturnType = new TypeReference<BalanceLimit>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

