/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import software.xdev.brevo.model.CreateWhatsAppCampaignRecipients;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * UpdateWhatsAppCampaign
 */
@JsonPropertyOrder({
  UpdateWhatsAppCampaign.JSON_PROPERTY_CAMPAIGN_NAME,
  UpdateWhatsAppCampaign.JSON_PROPERTY_CAMPAIGN_STATUS,
  UpdateWhatsAppCampaign.JSON_PROPERTY_RESCHEDULE_FOR,
  UpdateWhatsAppCampaign.JSON_PROPERTY_RECIPIENTS
})
@JsonTypeName("updateWhatsAppCampaign")
public class UpdateWhatsAppCampaign {
  public static final String JSON_PROPERTY_CAMPAIGN_NAME = "campaignName";
  @jakarta.annotation.Nullable
  private String campaignName;

  /**
   * Status of the campaign
   */
  public enum CampaignStatusEnum {
    SCHEDULED(String.valueOf("scheduled")),
    
    SUSPENDED(String.valueOf("suspended"));

    private String value;

    CampaignStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CampaignStatusEnum fromValue(String value) {
      for (CampaignStatusEnum b : CampaignStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CAMPAIGN_STATUS = "campaignStatus";
  @jakarta.annotation.Nullable
  private CampaignStatusEnum campaignStatus = CampaignStatusEnum.SCHEDULED;

  public static final String JSON_PROPERTY_RESCHEDULE_FOR = "rescheduleFor";
  @jakarta.annotation.Nullable
  private String rescheduleFor;

  public static final String JSON_PROPERTY_RECIPIENTS = "recipients";
  @jakarta.annotation.Nullable
  private CreateWhatsAppCampaignRecipients recipients;

  public UpdateWhatsAppCampaign() {
  }

  public UpdateWhatsAppCampaign campaignName(@jakarta.annotation.Nullable String campaignName) {
    
    this.campaignName = campaignName;
    return this;
  }

  /**
   * Name of the campaign
   * @return campaignName
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CAMPAIGN_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCampaignName() {
    return campaignName;
  }


  @JsonProperty(JSON_PROPERTY_CAMPAIGN_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCampaignName(@jakarta.annotation.Nullable String campaignName) {
    this.campaignName = campaignName;
  }

  public UpdateWhatsAppCampaign campaignStatus(@jakarta.annotation.Nullable CampaignStatusEnum campaignStatus) {
    
    this.campaignStatus = campaignStatus;
    return this;
  }

  /**
   * Status of the campaign
   * @return campaignStatus
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CAMPAIGN_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CampaignStatusEnum getCampaignStatus() {
    return campaignStatus;
  }


  @JsonProperty(JSON_PROPERTY_CAMPAIGN_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCampaignStatus(@jakarta.annotation.Nullable CampaignStatusEnum campaignStatus) {
    this.campaignStatus = campaignStatus;
  }

  public UpdateWhatsAppCampaign rescheduleFor(@jakarta.annotation.Nullable String rescheduleFor) {
    
    this.rescheduleFor = rescheduleFor;
    return this;
  }

  /**
   * Reschedule the sending UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) of campaign. **Prefer to pass your timezone in date-time format for accurate result.For example: **2017-06-01T12:30:00+02:00** Use this field to update the scheduledAt of any existing draft or scheduled WhatsApp campaign. 
   * @return rescheduleFor
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RESCHEDULE_FOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRescheduleFor() {
    return rescheduleFor;
  }


  @JsonProperty(JSON_PROPERTY_RESCHEDULE_FOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRescheduleFor(@jakarta.annotation.Nullable String rescheduleFor) {
    this.rescheduleFor = rescheduleFor;
  }

  public UpdateWhatsAppCampaign recipients(@jakarta.annotation.Nullable CreateWhatsAppCampaignRecipients recipients) {
    
    this.recipients = recipients;
    return this;
  }

  /**
   * Get recipients
   * @return recipients
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RECIPIENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CreateWhatsAppCampaignRecipients getRecipients() {
    return recipients;
  }


  @JsonProperty(JSON_PROPERTY_RECIPIENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecipients(@jakarta.annotation.Nullable CreateWhatsAppCampaignRecipients recipients) {
    this.recipients = recipients;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateWhatsAppCampaign updateWhatsAppCampaign = (UpdateWhatsAppCampaign) o;
    return Objects.equals(this.campaignName, updateWhatsAppCampaign.campaignName) &&
        Objects.equals(this.campaignStatus, updateWhatsAppCampaign.campaignStatus) &&
        Objects.equals(this.rescheduleFor, updateWhatsAppCampaign.rescheduleFor) &&
        Objects.equals(this.recipients, updateWhatsAppCampaign.recipients);
  }

  @Override
  public int hashCode() {
    return Objects.hash(campaignName, campaignStatus, rescheduleFor, recipients);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateWhatsAppCampaign {\n");
    sb.append("    campaignName: ").append(toIndentedString(campaignName)).append("\n");
    sb.append("    campaignStatus: ").append(toIndentedString(campaignStatus)).append("\n");
    sb.append("    rescheduleFor: ").append(toIndentedString(rescheduleFor)).append("\n");
    sb.append("    recipients: ").append(toIndentedString(recipients)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `campaignName` to the URL query string
    if (getCampaignName() != null) {
      try {
        joiner.add(String.format("%scampaignName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCampaignName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `campaignStatus` to the URL query string
    if (getCampaignStatus() != null) {
      try {
        joiner.add(String.format("%scampaignStatus%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCampaignStatus()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `rescheduleFor` to the URL query string
    if (getRescheduleFor() != null) {
      try {
        joiner.add(String.format("%srescheduleFor%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRescheduleFor()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `recipients` to the URL query string
    if (getRecipients() != null) {
      joiner.add(getRecipients().toUrlQueryString(prefix + "recipients" + suffix));
    }

    return joiner.toString();
  }

}

