/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * UpdateTierGroupRequest
 */
@JsonPropertyOrder({
  UpdateTierGroupRequest.JSON_PROPERTY_NAME,
  UpdateTierGroupRequest.JSON_PROPERTY_TIER_ORDER,
  UpdateTierGroupRequest.JSON_PROPERTY_UPGRADE_STRATEGY,
  UpdateTierGroupRequest.JSON_PROPERTY_DOWNGRADE_STRATEGY
})
@JsonTypeName("updateTierGroupRequest")
public class UpdateTierGroupRequest {
  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nonnull
  private String name;

  public static final String JSON_PROPERTY_TIER_ORDER = "tierOrder";
  @jakarta.annotation.Nonnull
  private List<UUID> tierOrder = new ArrayList<>();

  /**
   * Select real_time to upgrade tier on real time balance updates. Select membership_anniversary to upgrade tier on subscription anniversary. Select tier_anniversary to upgrade tier on tier anniversary.
   */
  public enum UpgradeStrategyEnum {
    REAL_TIME(String.valueOf("real_time")),
    
    MEMBERSHIP_ANNIVERSARY(String.valueOf("membership_anniversary")),
    
    TIER_ANNIVERSARY(String.valueOf("tier_anniversary"));

    private String value;

    UpgradeStrategyEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static UpgradeStrategyEnum fromValue(String value) {
      for (UpgradeStrategyEnum b : UpgradeStrategyEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_UPGRADE_STRATEGY = "upgradeStrategy";
  @jakarta.annotation.Nonnull
  private UpgradeStrategyEnum upgradeStrategy = UpgradeStrategyEnum.REAL_TIME;

  /**
   * Select real_time to downgrade tier on real time balance updates. Select membership_anniversary to downgrade tier on subscription anniversary. Select tier_anniversary to downgrade tier on tier anniversary.
   */
  public enum DowngradeStrategyEnum {
    REAL_TIME(String.valueOf("real_time")),
    
    MEMBERSHIP_ANNIVERSARY(String.valueOf("membership_anniversary")),
    
    TIER_ANNIVERSARY(String.valueOf("tier_anniversary"));

    private String value;

    DowngradeStrategyEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DowngradeStrategyEnum fromValue(String value) {
      for (DowngradeStrategyEnum b : DowngradeStrategyEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DOWNGRADE_STRATEGY = "downgradeStrategy";
  @jakarta.annotation.Nonnull
  private DowngradeStrategyEnum downgradeStrategy = DowngradeStrategyEnum.REAL_TIME;

  public UpdateTierGroupRequest() {
  }

  public UpdateTierGroupRequest name(@jakarta.annotation.Nonnull String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Name of the tier group
   * @return name
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(@jakarta.annotation.Nonnull String name) {
    this.name = name;
  }

  public UpdateTierGroupRequest tierOrder(@jakarta.annotation.Nonnull List<UUID> tierOrder) {
    
    this.tierOrder = tierOrder;
    return this;
  }

  public UpdateTierGroupRequest addTierOrderItem(UUID tierOrderItem) {
    if (this.tierOrder == null) {
      this.tierOrder = new ArrayList<>();
    }
    this.tierOrder.add(tierOrderItem);
    return this;
  }

  /**
   * Order of the tiers in the group in ascending order
   * @return tierOrder
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TIER_ORDER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<UUID> getTierOrder() {
    return tierOrder;
  }


  @JsonProperty(JSON_PROPERTY_TIER_ORDER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTierOrder(@jakarta.annotation.Nonnull List<UUID> tierOrder) {
    this.tierOrder = tierOrder;
  }

  public UpdateTierGroupRequest upgradeStrategy(@jakarta.annotation.Nonnull UpgradeStrategyEnum upgradeStrategy) {
    
    this.upgradeStrategy = upgradeStrategy;
    return this;
  }

  /**
   * Select real_time to upgrade tier on real time balance updates. Select membership_anniversary to upgrade tier on subscription anniversary. Select tier_anniversary to upgrade tier on tier anniversary.
   * @return upgradeStrategy
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_UPGRADE_STRATEGY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UpgradeStrategyEnum getUpgradeStrategy() {
    return upgradeStrategy;
  }


  @JsonProperty(JSON_PROPERTY_UPGRADE_STRATEGY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUpgradeStrategy(@jakarta.annotation.Nonnull UpgradeStrategyEnum upgradeStrategy) {
    this.upgradeStrategy = upgradeStrategy;
  }

  public UpdateTierGroupRequest downgradeStrategy(@jakarta.annotation.Nonnull DowngradeStrategyEnum downgradeStrategy) {
    
    this.downgradeStrategy = downgradeStrategy;
    return this;
  }

  /**
   * Select real_time to downgrade tier on real time balance updates. Select membership_anniversary to downgrade tier on subscription anniversary. Select tier_anniversary to downgrade tier on tier anniversary.
   * @return downgradeStrategy
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_DOWNGRADE_STRATEGY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public DowngradeStrategyEnum getDowngradeStrategy() {
    return downgradeStrategy;
  }


  @JsonProperty(JSON_PROPERTY_DOWNGRADE_STRATEGY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDowngradeStrategy(@jakarta.annotation.Nonnull DowngradeStrategyEnum downgradeStrategy) {
    this.downgradeStrategy = downgradeStrategy;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateTierGroupRequest updateTierGroupRequest = (UpdateTierGroupRequest) o;
    return Objects.equals(this.name, updateTierGroupRequest.name) &&
        Objects.equals(this.tierOrder, updateTierGroupRequest.tierOrder) &&
        Objects.equals(this.upgradeStrategy, updateTierGroupRequest.upgradeStrategy) &&
        Objects.equals(this.downgradeStrategy, updateTierGroupRequest.downgradeStrategy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, tierOrder, upgradeStrategy, downgradeStrategy);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateTierGroupRequest {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    tierOrder: ").append(toIndentedString(tierOrder)).append("\n");
    sb.append("    upgradeStrategy: ").append(toIndentedString(upgradeStrategy)).append("\n");
    sb.append("    downgradeStrategy: ").append(toIndentedString(downgradeStrategy)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `name` to the URL query string
    if (getName() != null) {
      try {
        joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tierOrder` to the URL query string
    if (getTierOrder() != null) {
      for (int i = 0; i < getTierOrder().size(); i++) {
        if (getTierOrder().get(i) != null) {
          try {
            joiner.add(String.format("%stierOrder%s%s=%s", prefix, suffix,
                "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
                URLEncoder.encode(String.valueOf(getTierOrder().get(i)), "UTF-8").replaceAll("\\+", "%20")));
          } catch (UnsupportedEncodingException e) {
            // Should never happen, UTF-8 is always supported
            throw new RuntimeException(e);
          }
        }
      }
    }

    // add `upgradeStrategy` to the URL query string
    if (getUpgradeStrategy() != null) {
      try {
        joiner.add(String.format("%supgradeStrategy%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUpgradeStrategy()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `downgradeStrategy` to the URL query string
    if (getDowngradeStrategy() != null) {
      try {
        joiner.add(String.format("%sdowngradeStrategy%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDowngradeStrategy()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

