/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Payload for updating an existing balance definition, including expiry rules, rounding strategies, and constraints.
 */
@JsonPropertyOrder({
  UpdateBalanceDefinitionPayload.JSON_PROPERTY_BALANCE_AVAILABILITY_DURATION_MODIFIER,
  UpdateBalanceDefinitionPayload.JSON_PROPERTY_BALANCE_AVAILABILITY_DURATION_UNIT,
  UpdateBalanceDefinitionPayload.JSON_PROPERTY_BALANCE_AVAILABILITY_DURATION_VALUE,
  UpdateBalanceDefinitionPayload.JSON_PROPERTY_BALANCE_EXPIRATION_DATE,
  UpdateBalanceDefinitionPayload.JSON_PROPERTY_BALANCE_OPTION_AMOUNT_OVERTAKING_STRATEGY,
  UpdateBalanceDefinitionPayload.JSON_PROPERTY_BALANCE_OPTION_CREDIT_ROUNDING,
  UpdateBalanceDefinitionPayload.JSON_PROPERTY_BALANCE_OPTION_DEBIT_ROUNDING,
  UpdateBalanceDefinitionPayload.JSON_PROPERTY_DESCRIPTION,
  UpdateBalanceDefinitionPayload.JSON_PROPERTY_IMAGE_REF,
  UpdateBalanceDefinitionPayload.JSON_PROPERTY_MAX_AMOUNT,
  UpdateBalanceDefinitionPayload.JSON_PROPERTY_MAX_CREDIT_AMOUNT_LIMIT,
  UpdateBalanceDefinitionPayload.JSON_PROPERTY_MAX_DEBIT_AMOUNT_LIMIT,
  UpdateBalanceDefinitionPayload.JSON_PROPERTY_META,
  UpdateBalanceDefinitionPayload.JSON_PROPERTY_MIN_AMOUNT,
  UpdateBalanceDefinitionPayload.JSON_PROPERTY_NAME,
  UpdateBalanceDefinitionPayload.JSON_PROPERTY_UNIT
})
@JsonTypeName("updateBalanceDefinitionPayload")
public class UpdateBalanceDefinitionPayload {
  /**
   * Defines when the balance expires within the selected duration.
   */
  public enum BalanceAvailabilityDurationModifierEnum {
    NO_MODIFICATION(String.valueOf("noModification")),
    
    START_OF_PERIOD(String.valueOf("startOfPeriod")),
    
    END_OF_PERIOD(String.valueOf("endOfPeriod"));

    private String value;

    BalanceAvailabilityDurationModifierEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static BalanceAvailabilityDurationModifierEnum fromValue(String value) {
      for (BalanceAvailabilityDurationModifierEnum b : BalanceAvailabilityDurationModifierEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_BALANCE_AVAILABILITY_DURATION_MODIFIER = "balanceAvailabilityDurationModifier";
  @jakarta.annotation.Nullable
  private BalanceAvailabilityDurationModifierEnum balanceAvailabilityDurationModifier;

  /**
   * Unit of time for balance validity.
   */
  public enum BalanceAvailabilityDurationUnitEnum {
    DAY(String.valueOf("day")),
    
    WEEK(String.valueOf("week")),
    
    MONTH(String.valueOf("month")),
    
    YEAR(String.valueOf("year"));

    private String value;

    BalanceAvailabilityDurationUnitEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static BalanceAvailabilityDurationUnitEnum fromValue(String value) {
      for (BalanceAvailabilityDurationUnitEnum b : BalanceAvailabilityDurationUnitEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_BALANCE_AVAILABILITY_DURATION_UNIT = "balanceAvailabilityDurationUnit";
  @jakarta.annotation.Nullable
  private BalanceAvailabilityDurationUnitEnum balanceAvailabilityDurationUnit;

  public static final String JSON_PROPERTY_BALANCE_AVAILABILITY_DURATION_VALUE = "balanceAvailabilityDurationValue";
  @jakarta.annotation.Nullable
  private Integer balanceAvailabilityDurationValue;

  public static final String JSON_PROPERTY_BALANCE_EXPIRATION_DATE = "balanceExpirationDate";
  @jakarta.annotation.Nullable
  private String balanceExpirationDate;

  /**
   * Defines whether partial credit is allowed when reaching max balance.
   */
  public enum BalanceOptionAmountOvertakingStrategyEnum {
    STRICT(String.valueOf("strict")),
    
    PARTIAL(String.valueOf("partial"));

    private String value;

    BalanceOptionAmountOvertakingStrategyEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static BalanceOptionAmountOvertakingStrategyEnum fromValue(String value) {
      for (BalanceOptionAmountOvertakingStrategyEnum b : BalanceOptionAmountOvertakingStrategyEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_BALANCE_OPTION_AMOUNT_OVERTAKING_STRATEGY = "balanceOptionAmountOvertakingStrategy";
  @jakarta.annotation.Nullable
  private BalanceOptionAmountOvertakingStrategyEnum balanceOptionAmountOvertakingStrategy;

  /**
   * Rounding strategy for credit transactions.
   */
  public enum BalanceOptionCreditRoundingEnum {
    LOWER(String.valueOf("lower")),
    
    UPPER(String.valueOf("upper")),
    
    NATURAL(String.valueOf("natural"));

    private String value;

    BalanceOptionCreditRoundingEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static BalanceOptionCreditRoundingEnum fromValue(String value) {
      for (BalanceOptionCreditRoundingEnum b : BalanceOptionCreditRoundingEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_BALANCE_OPTION_CREDIT_ROUNDING = "balanceOptionCreditRounding";
  @jakarta.annotation.Nullable
  private BalanceOptionCreditRoundingEnum balanceOptionCreditRounding;

  /**
   * Rounding strategy for debit transactions.
   */
  public enum BalanceOptionDebitRoundingEnum {
    LOWER(String.valueOf("lower")),
    
    UPPER(String.valueOf("upper")),
    
    NATURAL(String.valueOf("natural"));

    private String value;

    BalanceOptionDebitRoundingEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static BalanceOptionDebitRoundingEnum fromValue(String value) {
      for (BalanceOptionDebitRoundingEnum b : BalanceOptionDebitRoundingEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_BALANCE_OPTION_DEBIT_ROUNDING = "balanceOptionDebitRounding";
  @jakarta.annotation.Nullable
  private BalanceOptionDebitRoundingEnum balanceOptionDebitRounding;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  @jakarta.annotation.Nullable
  private String description;

  public static final String JSON_PROPERTY_IMAGE_REF = "imageRef";
  @jakarta.annotation.Nullable
  private String imageRef;

  public static final String JSON_PROPERTY_MAX_AMOUNT = "maxAmount";
  @jakarta.annotation.Nullable
  private BigDecimal maxAmount;

  public static final String JSON_PROPERTY_MAX_CREDIT_AMOUNT_LIMIT = "maxCreditAmountLimit";
  @jakarta.annotation.Nullable
  private BigDecimal maxCreditAmountLimit;

  public static final String JSON_PROPERTY_MAX_DEBIT_AMOUNT_LIMIT = "maxDebitAmountLimit";
  @jakarta.annotation.Nullable
  private BigDecimal maxDebitAmountLimit;

  public static final String JSON_PROPERTY_META = "meta";
  @jakarta.annotation.Nullable
  private Map<String, Object> meta = new HashMap<>();

  public static final String JSON_PROPERTY_MIN_AMOUNT = "minAmount";
  @jakarta.annotation.Nullable
  private BigDecimal minAmount;

  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nonnull
  private String name;

  /**
   * Unit of balance measurement.
   */
  public enum UnitEnum {
    POINTS(String.valueOf("POINTS")),
    
    EUR(String.valueOf("EUR")),
    
    USD(String.valueOf("USD")),
    
    MXN(String.valueOf("MXN")),
    
    GBP(String.valueOf("GBP")),
    
    INR(String.valueOf("INR")),
    
    CAD(String.valueOf("CAD")),
    
    SGD(String.valueOf("SGD")),
    
    RON(String.valueOf("RON")),
    
    JPY(String.valueOf("JPY")),
    
    MYR(String.valueOf("MYR")),
    
    CLP(String.valueOf("CLP")),
    
    PEN(String.valueOf("PEN")),
    
    MAD(String.valueOf("MAD")),
    
    AUD(String.valueOf("AUD")),
    
    CHF(String.valueOf("CHF")),
    
    BRL(String.valueOf("BRL"));

    private String value;

    UnitEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static UnitEnum fromValue(String value) {
      for (UnitEnum b : UnitEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_UNIT = "unit";
  @jakarta.annotation.Nonnull
  private UnitEnum unit;

  public UpdateBalanceDefinitionPayload() {
  }

  public UpdateBalanceDefinitionPayload balanceAvailabilityDurationModifier(@jakarta.annotation.Nullable BalanceAvailabilityDurationModifierEnum balanceAvailabilityDurationModifier) {
    
    this.balanceAvailabilityDurationModifier = balanceAvailabilityDurationModifier;
    return this;
  }

  /**
   * Defines when the balance expires within the selected duration.
   * @return balanceAvailabilityDurationModifier
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BALANCE_AVAILABILITY_DURATION_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BalanceAvailabilityDurationModifierEnum getBalanceAvailabilityDurationModifier() {
    return balanceAvailabilityDurationModifier;
  }


  @JsonProperty(JSON_PROPERTY_BALANCE_AVAILABILITY_DURATION_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalanceAvailabilityDurationModifier(@jakarta.annotation.Nullable BalanceAvailabilityDurationModifierEnum balanceAvailabilityDurationModifier) {
    this.balanceAvailabilityDurationModifier = balanceAvailabilityDurationModifier;
  }

  public UpdateBalanceDefinitionPayload balanceAvailabilityDurationUnit(@jakarta.annotation.Nullable BalanceAvailabilityDurationUnitEnum balanceAvailabilityDurationUnit) {
    
    this.balanceAvailabilityDurationUnit = balanceAvailabilityDurationUnit;
    return this;
  }

  /**
   * Unit of time for balance validity.
   * @return balanceAvailabilityDurationUnit
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BALANCE_AVAILABILITY_DURATION_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BalanceAvailabilityDurationUnitEnum getBalanceAvailabilityDurationUnit() {
    return balanceAvailabilityDurationUnit;
  }


  @JsonProperty(JSON_PROPERTY_BALANCE_AVAILABILITY_DURATION_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalanceAvailabilityDurationUnit(@jakarta.annotation.Nullable BalanceAvailabilityDurationUnitEnum balanceAvailabilityDurationUnit) {
    this.balanceAvailabilityDurationUnit = balanceAvailabilityDurationUnit;
  }

  public UpdateBalanceDefinitionPayload balanceAvailabilityDurationValue(@jakarta.annotation.Nullable Integer balanceAvailabilityDurationValue) {
    
    this.balanceAvailabilityDurationValue = balanceAvailabilityDurationValue;
    return this;
  }

  /**
   * Number of time units before the balance expires.
   * @return balanceAvailabilityDurationValue
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BALANCE_AVAILABILITY_DURATION_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getBalanceAvailabilityDurationValue() {
    return balanceAvailabilityDurationValue;
  }


  @JsonProperty(JSON_PROPERTY_BALANCE_AVAILABILITY_DURATION_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalanceAvailabilityDurationValue(@jakarta.annotation.Nullable Integer balanceAvailabilityDurationValue) {
    this.balanceAvailabilityDurationValue = balanceAvailabilityDurationValue;
  }

  public UpdateBalanceDefinitionPayload balanceExpirationDate(@jakarta.annotation.Nullable String balanceExpirationDate) {
    
    this.balanceExpirationDate = balanceExpirationDate;
    return this;
  }

  /**
   * Expiration date (&#x60;dd/mm&#x60; format) or empty if not applicable.
   * @return balanceExpirationDate
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BALANCE_EXPIRATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBalanceExpirationDate() {
    return balanceExpirationDate;
  }


  @JsonProperty(JSON_PROPERTY_BALANCE_EXPIRATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalanceExpirationDate(@jakarta.annotation.Nullable String balanceExpirationDate) {
    this.balanceExpirationDate = balanceExpirationDate;
  }

  public UpdateBalanceDefinitionPayload balanceOptionAmountOvertakingStrategy(@jakarta.annotation.Nullable BalanceOptionAmountOvertakingStrategyEnum balanceOptionAmountOvertakingStrategy) {
    
    this.balanceOptionAmountOvertakingStrategy = balanceOptionAmountOvertakingStrategy;
    return this;
  }

  /**
   * Defines whether partial credit is allowed when reaching max balance.
   * @return balanceOptionAmountOvertakingStrategy
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BALANCE_OPTION_AMOUNT_OVERTAKING_STRATEGY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BalanceOptionAmountOvertakingStrategyEnum getBalanceOptionAmountOvertakingStrategy() {
    return balanceOptionAmountOvertakingStrategy;
  }


  @JsonProperty(JSON_PROPERTY_BALANCE_OPTION_AMOUNT_OVERTAKING_STRATEGY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalanceOptionAmountOvertakingStrategy(@jakarta.annotation.Nullable BalanceOptionAmountOvertakingStrategyEnum balanceOptionAmountOvertakingStrategy) {
    this.balanceOptionAmountOvertakingStrategy = balanceOptionAmountOvertakingStrategy;
  }

  public UpdateBalanceDefinitionPayload balanceOptionCreditRounding(@jakarta.annotation.Nullable BalanceOptionCreditRoundingEnum balanceOptionCreditRounding) {
    
    this.balanceOptionCreditRounding = balanceOptionCreditRounding;
    return this;
  }

  /**
   * Rounding strategy for credit transactions.
   * @return balanceOptionCreditRounding
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BALANCE_OPTION_CREDIT_ROUNDING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BalanceOptionCreditRoundingEnum getBalanceOptionCreditRounding() {
    return balanceOptionCreditRounding;
  }


  @JsonProperty(JSON_PROPERTY_BALANCE_OPTION_CREDIT_ROUNDING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalanceOptionCreditRounding(@jakarta.annotation.Nullable BalanceOptionCreditRoundingEnum balanceOptionCreditRounding) {
    this.balanceOptionCreditRounding = balanceOptionCreditRounding;
  }

  public UpdateBalanceDefinitionPayload balanceOptionDebitRounding(@jakarta.annotation.Nullable BalanceOptionDebitRoundingEnum balanceOptionDebitRounding) {
    
    this.balanceOptionDebitRounding = balanceOptionDebitRounding;
    return this;
  }

  /**
   * Rounding strategy for debit transactions.
   * @return balanceOptionDebitRounding
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BALANCE_OPTION_DEBIT_ROUNDING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BalanceOptionDebitRoundingEnum getBalanceOptionDebitRounding() {
    return balanceOptionDebitRounding;
  }


  @JsonProperty(JSON_PROPERTY_BALANCE_OPTION_DEBIT_ROUNDING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalanceOptionDebitRounding(@jakarta.annotation.Nullable BalanceOptionDebitRoundingEnum balanceOptionDebitRounding) {
    this.balanceOptionDebitRounding = balanceOptionDebitRounding;
  }

  public UpdateBalanceDefinitionPayload description(@jakarta.annotation.Nullable String description) {
    
    this.description = description;
    return this;
  }

  /**
   * Short description of the balance definition.
   * @return description
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(@jakarta.annotation.Nullable String description) {
    this.description = description;
  }

  public UpdateBalanceDefinitionPayload imageRef(@jakarta.annotation.Nullable String imageRef) {
    
    this.imageRef = imageRef;
    return this;
  }

  /**
   * URL of an optional image reference.
   * @return imageRef
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IMAGE_REF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getImageRef() {
    return imageRef;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_REF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImageRef(@jakarta.annotation.Nullable String imageRef) {
    this.imageRef = imageRef;
  }

  public UpdateBalanceDefinitionPayload maxAmount(@jakarta.annotation.Nullable BigDecimal maxAmount) {
    
    this.maxAmount = maxAmount;
    return this;
  }

  /**
   * Maximum allowable balance amount.
   * @return maxAmount
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MAX_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getMaxAmount() {
    return maxAmount;
  }


  @JsonProperty(JSON_PROPERTY_MAX_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxAmount(@jakarta.annotation.Nullable BigDecimal maxAmount) {
    this.maxAmount = maxAmount;
  }

  public UpdateBalanceDefinitionPayload maxCreditAmountLimit(@jakarta.annotation.Nullable BigDecimal maxCreditAmountLimit) {
    
    this.maxCreditAmountLimit = maxCreditAmountLimit;
    return this;
  }

  /**
   * Maximum credit allowed per operation.
   * @return maxCreditAmountLimit
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MAX_CREDIT_AMOUNT_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getMaxCreditAmountLimit() {
    return maxCreditAmountLimit;
  }


  @JsonProperty(JSON_PROPERTY_MAX_CREDIT_AMOUNT_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxCreditAmountLimit(@jakarta.annotation.Nullable BigDecimal maxCreditAmountLimit) {
    this.maxCreditAmountLimit = maxCreditAmountLimit;
  }

  public UpdateBalanceDefinitionPayload maxDebitAmountLimit(@jakarta.annotation.Nullable BigDecimal maxDebitAmountLimit) {
    
    this.maxDebitAmountLimit = maxDebitAmountLimit;
    return this;
  }

  /**
   * Maximum debit allowed per operation.
   * @return maxDebitAmountLimit
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MAX_DEBIT_AMOUNT_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getMaxDebitAmountLimit() {
    return maxDebitAmountLimit;
  }


  @JsonProperty(JSON_PROPERTY_MAX_DEBIT_AMOUNT_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxDebitAmountLimit(@jakarta.annotation.Nullable BigDecimal maxDebitAmountLimit) {
    this.maxDebitAmountLimit = maxDebitAmountLimit;
  }

  public UpdateBalanceDefinitionPayload meta(@jakarta.annotation.Nullable Map<String, Object> meta) {
    
    this.meta = meta;
    return this;
  }

  public UpdateBalanceDefinitionPayload putMetaItem(String key, Object metaItem) {
    if (this.meta == null) {
      this.meta = new HashMap<>();
    }
    this.meta.put(key, metaItem);
    return this;
  }

  /**
   * Optional metadata for the balance definition.
   * @return meta
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_META)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getMeta() {
    return meta;
  }


  @JsonProperty(JSON_PROPERTY_META)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeta(@jakarta.annotation.Nullable Map<String, Object> meta) {
    this.meta = meta;
  }

  public UpdateBalanceDefinitionPayload minAmount(@jakarta.annotation.Nullable BigDecimal minAmount) {
    
    this.minAmount = minAmount;
    return this;
  }

  /**
   * Minimum allowable balance amount.
   * @return minAmount
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MIN_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getMinAmount() {
    return minAmount;
  }


  @JsonProperty(JSON_PROPERTY_MIN_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinAmount(@jakarta.annotation.Nullable BigDecimal minAmount) {
    this.minAmount = minAmount;
  }

  public UpdateBalanceDefinitionPayload name(@jakarta.annotation.Nonnull String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Name of the balance definition.
   * @return name
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(@jakarta.annotation.Nonnull String name) {
    this.name = name;
  }

  public UpdateBalanceDefinitionPayload unit(@jakarta.annotation.Nonnull UnitEnum unit) {
    
    this.unit = unit;
    return this;
  }

  /**
   * Unit of balance measurement.
   * @return unit
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_UNIT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UnitEnum getUnit() {
    return unit;
  }


  @JsonProperty(JSON_PROPERTY_UNIT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUnit(@jakarta.annotation.Nonnull UnitEnum unit) {
    this.unit = unit;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateBalanceDefinitionPayload updateBalanceDefinitionPayload = (UpdateBalanceDefinitionPayload) o;
    return Objects.equals(this.balanceAvailabilityDurationModifier, updateBalanceDefinitionPayload.balanceAvailabilityDurationModifier) &&
        Objects.equals(this.balanceAvailabilityDurationUnit, updateBalanceDefinitionPayload.balanceAvailabilityDurationUnit) &&
        Objects.equals(this.balanceAvailabilityDurationValue, updateBalanceDefinitionPayload.balanceAvailabilityDurationValue) &&
        Objects.equals(this.balanceExpirationDate, updateBalanceDefinitionPayload.balanceExpirationDate) &&
        Objects.equals(this.balanceOptionAmountOvertakingStrategy, updateBalanceDefinitionPayload.balanceOptionAmountOvertakingStrategy) &&
        Objects.equals(this.balanceOptionCreditRounding, updateBalanceDefinitionPayload.balanceOptionCreditRounding) &&
        Objects.equals(this.balanceOptionDebitRounding, updateBalanceDefinitionPayload.balanceOptionDebitRounding) &&
        Objects.equals(this.description, updateBalanceDefinitionPayload.description) &&
        Objects.equals(this.imageRef, updateBalanceDefinitionPayload.imageRef) &&
        Objects.equals(this.maxAmount, updateBalanceDefinitionPayload.maxAmount) &&
        Objects.equals(this.maxCreditAmountLimit, updateBalanceDefinitionPayload.maxCreditAmountLimit) &&
        Objects.equals(this.maxDebitAmountLimit, updateBalanceDefinitionPayload.maxDebitAmountLimit) &&
        Objects.equals(this.meta, updateBalanceDefinitionPayload.meta) &&
        Objects.equals(this.minAmount, updateBalanceDefinitionPayload.minAmount) &&
        Objects.equals(this.name, updateBalanceDefinitionPayload.name) &&
        Objects.equals(this.unit, updateBalanceDefinitionPayload.unit);
  }

  @Override
  public int hashCode() {
    return Objects.hash(balanceAvailabilityDurationModifier, balanceAvailabilityDurationUnit, balanceAvailabilityDurationValue, balanceExpirationDate, balanceOptionAmountOvertakingStrategy, balanceOptionCreditRounding, balanceOptionDebitRounding, description, imageRef, maxAmount, maxCreditAmountLimit, maxDebitAmountLimit, meta, minAmount, name, unit);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateBalanceDefinitionPayload {\n");
    sb.append("    balanceAvailabilityDurationModifier: ").append(toIndentedString(balanceAvailabilityDurationModifier)).append("\n");
    sb.append("    balanceAvailabilityDurationUnit: ").append(toIndentedString(balanceAvailabilityDurationUnit)).append("\n");
    sb.append("    balanceAvailabilityDurationValue: ").append(toIndentedString(balanceAvailabilityDurationValue)).append("\n");
    sb.append("    balanceExpirationDate: ").append(toIndentedString(balanceExpirationDate)).append("\n");
    sb.append("    balanceOptionAmountOvertakingStrategy: ").append(toIndentedString(balanceOptionAmountOvertakingStrategy)).append("\n");
    sb.append("    balanceOptionCreditRounding: ").append(toIndentedString(balanceOptionCreditRounding)).append("\n");
    sb.append("    balanceOptionDebitRounding: ").append(toIndentedString(balanceOptionDebitRounding)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    imageRef: ").append(toIndentedString(imageRef)).append("\n");
    sb.append("    maxAmount: ").append(toIndentedString(maxAmount)).append("\n");
    sb.append("    maxCreditAmountLimit: ").append(toIndentedString(maxCreditAmountLimit)).append("\n");
    sb.append("    maxDebitAmountLimit: ").append(toIndentedString(maxDebitAmountLimit)).append("\n");
    sb.append("    meta: ").append(toIndentedString(meta)).append("\n");
    sb.append("    minAmount: ").append(toIndentedString(minAmount)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    unit: ").append(toIndentedString(unit)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `balanceAvailabilityDurationModifier` to the URL query string
    if (getBalanceAvailabilityDurationModifier() != null) {
      try {
        joiner.add(String.format("%sbalanceAvailabilityDurationModifier%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBalanceAvailabilityDurationModifier()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `balanceAvailabilityDurationUnit` to the URL query string
    if (getBalanceAvailabilityDurationUnit() != null) {
      try {
        joiner.add(String.format("%sbalanceAvailabilityDurationUnit%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBalanceAvailabilityDurationUnit()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `balanceAvailabilityDurationValue` to the URL query string
    if (getBalanceAvailabilityDurationValue() != null) {
      try {
        joiner.add(String.format("%sbalanceAvailabilityDurationValue%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBalanceAvailabilityDurationValue()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `balanceExpirationDate` to the URL query string
    if (getBalanceExpirationDate() != null) {
      try {
        joiner.add(String.format("%sbalanceExpirationDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBalanceExpirationDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `balanceOptionAmountOvertakingStrategy` to the URL query string
    if (getBalanceOptionAmountOvertakingStrategy() != null) {
      try {
        joiner.add(String.format("%sbalanceOptionAmountOvertakingStrategy%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBalanceOptionAmountOvertakingStrategy()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `balanceOptionCreditRounding` to the URL query string
    if (getBalanceOptionCreditRounding() != null) {
      try {
        joiner.add(String.format("%sbalanceOptionCreditRounding%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBalanceOptionCreditRounding()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `balanceOptionDebitRounding` to the URL query string
    if (getBalanceOptionDebitRounding() != null) {
      try {
        joiner.add(String.format("%sbalanceOptionDebitRounding%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBalanceOptionDebitRounding()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `description` to the URL query string
    if (getDescription() != null) {
      try {
        joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDescription()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `imageRef` to the URL query string
    if (getImageRef() != null) {
      try {
        joiner.add(String.format("%simageRef%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getImageRef()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `maxAmount` to the URL query string
    if (getMaxAmount() != null) {
      try {
        joiner.add(String.format("%smaxAmount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMaxAmount()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `maxCreditAmountLimit` to the URL query string
    if (getMaxCreditAmountLimit() != null) {
      try {
        joiner.add(String.format("%smaxCreditAmountLimit%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMaxCreditAmountLimit()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `maxDebitAmountLimit` to the URL query string
    if (getMaxDebitAmountLimit() != null) {
      try {
        joiner.add(String.format("%smaxDebitAmountLimit%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMaxDebitAmountLimit()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `meta` to the URL query string
    if (getMeta() != null) {
      for (String _key : getMeta().keySet()) {
        try {
          joiner.add(String.format("%smeta%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
              getMeta().get(_key), URLEncoder.encode(String.valueOf(getMeta().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `minAmount` to the URL query string
    if (getMinAmount() != null) {
      try {
        joiner.add(String.format("%sminAmount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMinAmount()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `name` to the URL query string
    if (getName() != null) {
      try {
        joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `unit` to the URL query string
    if (getUnit() != null) {
      try {
        joiner.add(String.format("%sunit%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUnit()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

