/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import software.xdev.brevo.model.TransactionHistory;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Response containing transaction history details for a specific balance and contact.
 */
@JsonPropertyOrder({
  TransactionHistoryResp.JSON_PROPERTY_BALANCE_DEFINITION_ID,
  TransactionHistoryResp.JSON_PROPERTY_CONTACT_ID,
  TransactionHistoryResp.JSON_PROPERTY_COUNT,
  TransactionHistoryResp.JSON_PROPERTY_LOYALTY_PROGRAM_ID,
  TransactionHistoryResp.JSON_PROPERTY_TRANSACTION_HISTORY
})
@JsonTypeName("transactionHistoryResp")
public class TransactionHistoryResp {
  public static final String JSON_PROPERTY_BALANCE_DEFINITION_ID = "balanceDefinitionId";
  @jakarta.annotation.Nullable
  private String balanceDefinitionId;

  public static final String JSON_PROPERTY_CONTACT_ID = "contactId";
  @jakarta.annotation.Nullable
  private Integer contactId;

  public static final String JSON_PROPERTY_COUNT = "count";
  @jakarta.annotation.Nullable
  private Integer count;

  public static final String JSON_PROPERTY_LOYALTY_PROGRAM_ID = "loyaltyProgramId";
  @jakarta.annotation.Nullable
  private String loyaltyProgramId;

  public static final String JSON_PROPERTY_TRANSACTION_HISTORY = "transactionHistory";
  @jakarta.annotation.Nullable
  private List<TransactionHistory> transactionHistory = new ArrayList<>();

  public TransactionHistoryResp() {
  }

  public TransactionHistoryResp balanceDefinitionId(@jakarta.annotation.Nullable String balanceDefinitionId) {
    
    this.balanceDefinitionId = balanceDefinitionId;
    return this;
  }

  /**
   * Unique identifier of the associated balance definition.
   * @return balanceDefinitionId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BALANCE_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBalanceDefinitionId() {
    return balanceDefinitionId;
  }


  @JsonProperty(JSON_PROPERTY_BALANCE_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalanceDefinitionId(@jakarta.annotation.Nullable String balanceDefinitionId) {
    this.balanceDefinitionId = balanceDefinitionId;
  }

  public TransactionHistoryResp contactId(@jakarta.annotation.Nullable Integer contactId) {
    
    this.contactId = contactId;
    return this;
  }

  /**
   * Unique identifier of the contact related to the transactions.
   * @return contactId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTACT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getContactId() {
    return contactId;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContactId(@jakarta.annotation.Nullable Integer contactId) {
    this.contactId = contactId;
  }

  public TransactionHistoryResp count(@jakarta.annotation.Nullable Integer count) {
    
    this.count = count;
    return this;
  }

  /**
   * Total number of transactions in the history.
   * @return count
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getCount() {
    return count;
  }


  @JsonProperty(JSON_PROPERTY_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCount(@jakarta.annotation.Nullable Integer count) {
    this.count = count;
  }

  public TransactionHistoryResp loyaltyProgramId(@jakarta.annotation.Nullable String loyaltyProgramId) {
    
    this.loyaltyProgramId = loyaltyProgramId;
    return this;
  }

  /**
   * Unique identifier of the associated loyalty program.
   * @return loyaltyProgramId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LOYALTY_PROGRAM_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLoyaltyProgramId() {
    return loyaltyProgramId;
  }


  @JsonProperty(JSON_PROPERTY_LOYALTY_PROGRAM_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLoyaltyProgramId(@jakarta.annotation.Nullable String loyaltyProgramId) {
    this.loyaltyProgramId = loyaltyProgramId;
  }

  public TransactionHistoryResp transactionHistory(@jakarta.annotation.Nullable List<TransactionHistory> transactionHistory) {
    
    this.transactionHistory = transactionHistory;
    return this;
  }

  public TransactionHistoryResp addTransactionHistoryItem(TransactionHistory transactionHistoryItem) {
    if (this.transactionHistory == null) {
      this.transactionHistory = new ArrayList<>();
    }
    this.transactionHistory.add(transactionHistoryItem);
    return this;
  }

  /**
   * List of past transactions associated with the balance.
   * @return transactionHistory
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TRANSACTION_HISTORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TransactionHistory> getTransactionHistory() {
    return transactionHistory;
  }


  @JsonProperty(JSON_PROPERTY_TRANSACTION_HISTORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransactionHistory(@jakarta.annotation.Nullable List<TransactionHistory> transactionHistory) {
    this.transactionHistory = transactionHistory;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TransactionHistoryResp transactionHistoryResp = (TransactionHistoryResp) o;
    return Objects.equals(this.balanceDefinitionId, transactionHistoryResp.balanceDefinitionId) &&
        Objects.equals(this.contactId, transactionHistoryResp.contactId) &&
        Objects.equals(this.count, transactionHistoryResp.count) &&
        Objects.equals(this.loyaltyProgramId, transactionHistoryResp.loyaltyProgramId) &&
        Objects.equals(this.transactionHistory, transactionHistoryResp.transactionHistory);
  }

  @Override
  public int hashCode() {
    return Objects.hash(balanceDefinitionId, contactId, count, loyaltyProgramId, transactionHistory);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TransactionHistoryResp {\n");
    sb.append("    balanceDefinitionId: ").append(toIndentedString(balanceDefinitionId)).append("\n");
    sb.append("    contactId: ").append(toIndentedString(contactId)).append("\n");
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    loyaltyProgramId: ").append(toIndentedString(loyaltyProgramId)).append("\n");
    sb.append("    transactionHistory: ").append(toIndentedString(transactionHistory)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `balanceDefinitionId` to the URL query string
    if (getBalanceDefinitionId() != null) {
      try {
        joiner.add(String.format("%sbalanceDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBalanceDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `contactId` to the URL query string
    if (getContactId() != null) {
      try {
        joiner.add(String.format("%scontactId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getContactId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `count` to the URL query string
    if (getCount() != null) {
      try {
        joiner.add(String.format("%scount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCount()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `loyaltyProgramId` to the URL query string
    if (getLoyaltyProgramId() != null) {
      try {
        joiner.add(String.format("%sloyaltyProgramId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getLoyaltyProgramId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `transactionHistory` to the URL query string
    if (getTransactionHistory() != null) {
      for (int i = 0; i < getTransactionHistory().size(); i++) {
        if (getTransactionHistory().get(i) != null) {
          joiner.add(getTransactionHistory().get(i).toUrlQueryString(String.format("%stransactionHistory%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

