/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Represents a record of a past transaction, including status and key timestamps.
 */
@JsonPropertyOrder({
  TransactionHistory.JSON_PROPERTY_AMOUNT,
  TransactionHistory.JSON_PROPERTY_BALANCE_EXPIRATION_DATE,
  TransactionHistory.JSON_PROPERTY_CANCELLED_AT,
  TransactionHistory.JSON_PROPERTY_COMPLETED_AT,
  TransactionHistory.JSON_PROPERTY_CREATED_AT,
  TransactionHistory.JSON_PROPERTY_ID,
  TransactionHistory.JSON_PROPERTY_META,
  TransactionHistory.JSON_PROPERTY_REJECT_REASON,
  TransactionHistory.JSON_PROPERTY_REJECTED_AT,
  TransactionHistory.JSON_PROPERTY_STATUS
})
@JsonTypeName("transactionHistory")
public class TransactionHistory {
  public static final String JSON_PROPERTY_AMOUNT = "amount";
  @jakarta.annotation.Nullable
  private BigDecimal amount;

  public static final String JSON_PROPERTY_BALANCE_EXPIRATION_DATE = "balanceExpirationDate";
  @jakarta.annotation.Nullable
  private String balanceExpirationDate;

  public static final String JSON_PROPERTY_CANCELLED_AT = "cancelledAt";
  @jakarta.annotation.Nullable
  private String cancelledAt;

  public static final String JSON_PROPERTY_COMPLETED_AT = "completedAt";
  @jakarta.annotation.Nullable
  private String completedAt;

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  @jakarta.annotation.Nullable
  private String createdAt;

  public static final String JSON_PROPERTY_ID = "id";
  @jakarta.annotation.Nullable
  private String id;

  public static final String JSON_PROPERTY_META = "meta";
  @jakarta.annotation.Nullable
  private Map<String, Object> meta = new HashMap<>();

  public static final String JSON_PROPERTY_REJECT_REASON = "rejectReason";
  @jakarta.annotation.Nullable
  private String rejectReason;

  public static final String JSON_PROPERTY_REJECTED_AT = "rejectedAt";
  @jakarta.annotation.Nullable
  private String rejectedAt;

  public static final String JSON_PROPERTY_STATUS = "status";
  @jakarta.annotation.Nullable
  private String status;

  public TransactionHistory() {
  }

  public TransactionHistory amount(@jakarta.annotation.Nullable BigDecimal amount) {
    
    this.amount = amount;
    return this;
  }

  /**
   * The transaction amount.
   * @return amount
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(@jakarta.annotation.Nullable BigDecimal amount) {
    this.amount = amount;
  }

  public TransactionHistory balanceExpirationDate(@jakarta.annotation.Nullable String balanceExpirationDate) {
    
    this.balanceExpirationDate = balanceExpirationDate;
    return this;
  }

  /**
   * Expiration date of the balance associated with this transaction.
   * @return balanceExpirationDate
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BALANCE_EXPIRATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBalanceExpirationDate() {
    return balanceExpirationDate;
  }


  @JsonProperty(JSON_PROPERTY_BALANCE_EXPIRATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalanceExpirationDate(@jakarta.annotation.Nullable String balanceExpirationDate) {
    this.balanceExpirationDate = balanceExpirationDate;
  }

  public TransactionHistory cancelledAt(@jakarta.annotation.Nullable String cancelledAt) {
    
    this.cancelledAt = cancelledAt;
    return this;
  }

  /**
   * Timestamp when the transaction was canceled, if applicable.
   * @return cancelledAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CANCELLED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCancelledAt() {
    return cancelledAt;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancelledAt(@jakarta.annotation.Nullable String cancelledAt) {
    this.cancelledAt = cancelledAt;
  }

  public TransactionHistory completedAt(@jakarta.annotation.Nullable String completedAt) {
    
    this.completedAt = completedAt;
    return this;
  }

  /**
   * Timestamp when the transaction was successfully completed.
   * @return completedAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_COMPLETED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCompletedAt() {
    return completedAt;
  }


  @JsonProperty(JSON_PROPERTY_COMPLETED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCompletedAt(@jakarta.annotation.Nullable String completedAt) {
    this.completedAt = completedAt;
  }

  public TransactionHistory createdAt(@jakarta.annotation.Nullable String createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Timestamp when the transaction was initiated.
   * @return createdAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedAt(@jakarta.annotation.Nullable String createdAt) {
    this.createdAt = createdAt;
  }

  public TransactionHistory id(@jakarta.annotation.Nullable String id) {
    
    this.id = id;
    return this;
  }

  /**
   * Unique identifier of the transaction.
   * @return id
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(@jakarta.annotation.Nullable String id) {
    this.id = id;
  }

  public TransactionHistory meta(@jakarta.annotation.Nullable Map<String, Object> meta) {
    
    this.meta = meta;
    return this;
  }

  public TransactionHistory putMetaItem(String key, Object metaItem) {
    if (this.meta == null) {
      this.meta = new HashMap<>();
    }
    this.meta.put(key, metaItem);
    return this;
  }

  /**
   * Optional metadata associated with the transaction.
   * @return meta
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_META)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getMeta() {
    return meta;
  }


  @JsonProperty(JSON_PROPERTY_META)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeta(@jakarta.annotation.Nullable Map<String, Object> meta) {
    this.meta = meta;
  }

  public TransactionHistory rejectReason(@jakarta.annotation.Nullable String rejectReason) {
    
    this.rejectReason = rejectReason;
    return this;
  }

  /**
   * Reason for rejection, if the transaction was declined.
   * @return rejectReason
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REJECT_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRejectReason() {
    return rejectReason;
  }


  @JsonProperty(JSON_PROPERTY_REJECT_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRejectReason(@jakarta.annotation.Nullable String rejectReason) {
    this.rejectReason = rejectReason;
  }

  public TransactionHistory rejectedAt(@jakarta.annotation.Nullable String rejectedAt) {
    
    this.rejectedAt = rejectedAt;
    return this;
  }

  /**
   * Timestamp when the transaction was rejected.
   * @return rejectedAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REJECTED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRejectedAt() {
    return rejectedAt;
  }


  @JsonProperty(JSON_PROPERTY_REJECTED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRejectedAt(@jakarta.annotation.Nullable String rejectedAt) {
    this.rejectedAt = rejectedAt;
  }

  public TransactionHistory status(@jakarta.annotation.Nullable String status) {
    
    this.status = status;
    return this;
  }

  /**
   * Current status of the transaction (e.g., pending, completed, rejected).
   * @return status
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(@jakarta.annotation.Nullable String status) {
    this.status = status;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TransactionHistory transactionHistory = (TransactionHistory) o;
    return Objects.equals(this.amount, transactionHistory.amount) &&
        Objects.equals(this.balanceExpirationDate, transactionHistory.balanceExpirationDate) &&
        Objects.equals(this.cancelledAt, transactionHistory.cancelledAt) &&
        Objects.equals(this.completedAt, transactionHistory.completedAt) &&
        Objects.equals(this.createdAt, transactionHistory.createdAt) &&
        Objects.equals(this.id, transactionHistory.id) &&
        Objects.equals(this.meta, transactionHistory.meta) &&
        Objects.equals(this.rejectReason, transactionHistory.rejectReason) &&
        Objects.equals(this.rejectedAt, transactionHistory.rejectedAt) &&
        Objects.equals(this.status, transactionHistory.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount, balanceExpirationDate, cancelledAt, completedAt, createdAt, id, meta, rejectReason, rejectedAt, status);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TransactionHistory {\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    balanceExpirationDate: ").append(toIndentedString(balanceExpirationDate)).append("\n");
    sb.append("    cancelledAt: ").append(toIndentedString(cancelledAt)).append("\n");
    sb.append("    completedAt: ").append(toIndentedString(completedAt)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    meta: ").append(toIndentedString(meta)).append("\n");
    sb.append("    rejectReason: ").append(toIndentedString(rejectReason)).append("\n");
    sb.append("    rejectedAt: ").append(toIndentedString(rejectedAt)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `amount` to the URL query string
    if (getAmount() != null) {
      try {
        joiner.add(String.format("%samount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAmount()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `balanceExpirationDate` to the URL query string
    if (getBalanceExpirationDate() != null) {
      try {
        joiner.add(String.format("%sbalanceExpirationDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBalanceExpirationDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `cancelledAt` to the URL query string
    if (getCancelledAt() != null) {
      try {
        joiner.add(String.format("%scancelledAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCancelledAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `completedAt` to the URL query string
    if (getCompletedAt() != null) {
      try {
        joiner.add(String.format("%scompletedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCompletedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `createdAt` to the URL query string
    if (getCreatedAt() != null) {
      try {
        joiner.add(String.format("%screatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreatedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `meta` to the URL query string
    if (getMeta() != null) {
      for (String _key : getMeta().keySet()) {
        try {
          joiner.add(String.format("%smeta%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
              getMeta().get(_key), URLEncoder.encode(String.valueOf(getMeta().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `rejectReason` to the URL query string
    if (getRejectReason() != null) {
      try {
        joiner.add(String.format("%srejectReason%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRejectReason()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `rejectedAt` to the URL query string
    if (getRejectedAt() != null) {
      try {
        joiner.add(String.format("%srejectedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRejectedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `status` to the URL query string
    if (getStatus() != null) {
      try {
        joiner.add(String.format("%sstatus%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStatus()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

