/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import software.xdev.brevo.model.TierRequestAccessConditionsInner;
import software.xdev.brevo.model.TierRequestTierRewardsInner;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * TierRequest
 */
@JsonPropertyOrder({
  TierRequest.JSON_PROPERTY_NAME,
  TierRequest.JSON_PROPERTY_IMAGE_REF,
  TierRequest.JSON_PROPERTY_ACCESS_CONDITIONS,
  TierRequest.JSON_PROPERTY_TIER_REWARDS
})
@JsonTypeName("tierRequest")
public class TierRequest {
  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nonnull
  private String name;

  public static final String JSON_PROPERTY_IMAGE_REF = "imageRef";
  @jakarta.annotation.Nullable
  private String imageRef;

  public static final String JSON_PROPERTY_ACCESS_CONDITIONS = "accessConditions";
  @jakarta.annotation.Nonnull
  private List<TierRequestAccessConditionsInner> accessConditions = new ArrayList<>();

  public static final String JSON_PROPERTY_TIER_REWARDS = "tierRewards";
  @jakarta.annotation.Nullable
  private List<TierRequestTierRewardsInner> tierRewards = new ArrayList<>();

  public TierRequest() {
  }

  public TierRequest name(@jakarta.annotation.Nonnull String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Name of the tier to be created
   * @return name
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(@jakarta.annotation.Nonnull String name) {
    this.name = name;
  }

  public TierRequest imageRef(@jakarta.annotation.Nullable String imageRef) {
    
    this.imageRef = imageRef;
    return this;
  }

  /**
   * Image of the tier
   * @return imageRef
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IMAGE_REF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getImageRef() {
    return imageRef;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_REF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImageRef(@jakarta.annotation.Nullable String imageRef) {
    this.imageRef = imageRef;
  }

  public TierRequest accessConditions(@jakarta.annotation.Nonnull List<TierRequestAccessConditionsInner> accessConditions) {
    
    this.accessConditions = accessConditions;
    return this;
  }

  public TierRequest addAccessConditionsItem(TierRequestAccessConditionsInner accessConditionsItem) {
    if (this.accessConditions == null) {
      this.accessConditions = new ArrayList<>();
    }
    this.accessConditions.add(accessConditionsItem);
    return this;
  }

  /**
   * Get accessConditions
   * @return accessConditions
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ACCESS_CONDITIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<TierRequestAccessConditionsInner> getAccessConditions() {
    return accessConditions;
  }


  @JsonProperty(JSON_PROPERTY_ACCESS_CONDITIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAccessConditions(@jakarta.annotation.Nonnull List<TierRequestAccessConditionsInner> accessConditions) {
    this.accessConditions = accessConditions;
  }

  public TierRequest tierRewards(@jakarta.annotation.Nullable List<TierRequestTierRewardsInner> tierRewards) {
    
    this.tierRewards = tierRewards;
    return this;
  }

  public TierRequest addTierRewardsItem(TierRequestTierRewardsInner tierRewardsItem) {
    if (this.tierRewards == null) {
      this.tierRewards = new ArrayList<>();
    }
    this.tierRewards.add(tierRewardsItem);
    return this;
  }

  /**
   * Get tierRewards
   * @return tierRewards
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TIER_REWARDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TierRequestTierRewardsInner> getTierRewards() {
    return tierRewards;
  }


  @JsonProperty(JSON_PROPERTY_TIER_REWARDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTierRewards(@jakarta.annotation.Nullable List<TierRequestTierRewardsInner> tierRewards) {
    this.tierRewards = tierRewards;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TierRequest tierRequest = (TierRequest) o;
    return Objects.equals(this.name, tierRequest.name) &&
        Objects.equals(this.imageRef, tierRequest.imageRef) &&
        Objects.equals(this.accessConditions, tierRequest.accessConditions) &&
        Objects.equals(this.tierRewards, tierRequest.tierRewards);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, imageRef, accessConditions, tierRewards);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TierRequest {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    imageRef: ").append(toIndentedString(imageRef)).append("\n");
    sb.append("    accessConditions: ").append(toIndentedString(accessConditions)).append("\n");
    sb.append("    tierRewards: ").append(toIndentedString(tierRewards)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `name` to the URL query string
    if (getName() != null) {
      try {
        joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `imageRef` to the URL query string
    if (getImageRef() != null) {
      try {
        joiner.add(String.format("%simageRef%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getImageRef()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `accessConditions` to the URL query string
    if (getAccessConditions() != null) {
      for (int i = 0; i < getAccessConditions().size(); i++) {
        if (getAccessConditions().get(i) != null) {
          joiner.add(getAccessConditions().get(i).toUrlQueryString(String.format("%saccessConditions%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `tierRewards` to the URL query string
    if (getTierRewards() != null) {
      for (int i = 0; i < getTierRewards().size(); i++) {
        if (getTierRewards().get(i) != null) {
          joiner.add(getTierRewards().get(i).toUrlQueryString(String.format("%stierRewards%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

