/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * TierGroup
 */
@JsonPropertyOrder({
  TierGroup.JSON_PROPERTY_ID,
  TierGroup.JSON_PROPERTY_NAME,
  TierGroup.JSON_PROPERTY_TIER_ORDER,
  TierGroup.JSON_PROPERTY_LOYALTY_PROGRAM_ID,
  TierGroup.JSON_PROPERTY_UPGRADE_STRATEGY,
  TierGroup.JSON_PROPERTY_DOWNGRADE_STRATEGY,
  TierGroup.JSON_PROPERTY_CREATED_AT,
  TierGroup.JSON_PROPERTY_UPDATED_AT
})
@JsonTypeName("tierGroup")
public class TierGroup {
  public static final String JSON_PROPERTY_ID = "id";
  @jakarta.annotation.Nullable
  private UUID id;

  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nullable
  private String name;

  public static final String JSON_PROPERTY_TIER_ORDER = "tierOrder";
  @jakarta.annotation.Nullable
  private List<UUID> tierOrder = new ArrayList<>();

  public static final String JSON_PROPERTY_LOYALTY_PROGRAM_ID = "loyaltyProgramId";
  @jakarta.annotation.Nullable
  private UUID loyaltyProgramId;

  /**
   * Select real_time to upgrade tier on real time balance updates. Select membership_anniversary to upgrade tier on subscription anniversary. Select tier_anniversary to upgrade tier on tier anniversary.
   */
  public enum UpgradeStrategyEnum {
    REAL_TIME(String.valueOf("real_time")),
    
    MEMBERSHIP_ANNIVERSARY(String.valueOf("membership_anniversary")),
    
    TIER_ANNIVERSARY(String.valueOf("tier_anniversary"));

    private String value;

    UpgradeStrategyEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static UpgradeStrategyEnum fromValue(String value) {
      for (UpgradeStrategyEnum b : UpgradeStrategyEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_UPGRADE_STRATEGY = "upgradeStrategy";
  @jakarta.annotation.Nullable
  private UpgradeStrategyEnum upgradeStrategy = UpgradeStrategyEnum.REAL_TIME;

  /**
   * Select real_time to downgrade tier on real time balance updates. Select membership_anniversary to downgrade tier on subscription anniversary. Select tier_anniversary to downgrade tier on tier anniversary.
   */
  public enum DowngradeStrategyEnum {
    REAL_TIME(String.valueOf("real_time")),
    
    MEMBERSHIP_ANNIVERSARY(String.valueOf("membership_anniversary")),
    
    TIER_ANNIVERSARY(String.valueOf("tier_anniversary"));

    private String value;

    DowngradeStrategyEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DowngradeStrategyEnum fromValue(String value) {
      for (DowngradeStrategyEnum b : DowngradeStrategyEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DOWNGRADE_STRATEGY = "downgradeStrategy";
  @jakarta.annotation.Nullable
  private DowngradeStrategyEnum downgradeStrategy = DowngradeStrategyEnum.REAL_TIME;

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  @jakarta.annotation.Nullable
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
  @jakarta.annotation.Nullable
  private OffsetDateTime updatedAt;

  public TierGroup() {
  }

  public TierGroup id(@jakarta.annotation.Nullable UUID id) {
    
    this.id = id;
    return this;
  }

  /**
   * Tier group unique identifier
   * @return id
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(@jakarta.annotation.Nullable UUID id) {
    this.id = id;
  }

  public TierGroup name(@jakarta.annotation.Nullable String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Tier group name
   * @return name
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(@jakarta.annotation.Nullable String name) {
    this.name = name;
  }

  public TierGroup tierOrder(@jakarta.annotation.Nullable List<UUID> tierOrder) {
    
    this.tierOrder = tierOrder;
    return this;
  }

  public TierGroup addTierOrderItem(UUID tierOrderItem) {
    if (this.tierOrder == null) {
      this.tierOrder = new ArrayList<>();
    }
    this.tierOrder.add(tierOrderItem);
    return this;
  }

  /**
   * Order of the tiers in the group in ascending order
   * @return tierOrder
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TIER_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<UUID> getTierOrder() {
    return tierOrder;
  }


  @JsonProperty(JSON_PROPERTY_TIER_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTierOrder(@jakarta.annotation.Nullable List<UUID> tierOrder) {
    this.tierOrder = tierOrder;
  }

  public TierGroup loyaltyProgramId(@jakarta.annotation.Nullable UUID loyaltyProgramId) {
    
    this.loyaltyProgramId = loyaltyProgramId;
    return this;
  }

  /**
   * Associated loyalty program Id
   * @return loyaltyProgramId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LOYALTY_PROGRAM_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getLoyaltyProgramId() {
    return loyaltyProgramId;
  }


  @JsonProperty(JSON_PROPERTY_LOYALTY_PROGRAM_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLoyaltyProgramId(@jakarta.annotation.Nullable UUID loyaltyProgramId) {
    this.loyaltyProgramId = loyaltyProgramId;
  }

  public TierGroup upgradeStrategy(@jakarta.annotation.Nullable UpgradeStrategyEnum upgradeStrategy) {
    
    this.upgradeStrategy = upgradeStrategy;
    return this;
  }

  /**
   * Select real_time to upgrade tier on real time balance updates. Select membership_anniversary to upgrade tier on subscription anniversary. Select tier_anniversary to upgrade tier on tier anniversary.
   * @return upgradeStrategy
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UPGRADE_STRATEGY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UpgradeStrategyEnum getUpgradeStrategy() {
    return upgradeStrategy;
  }


  @JsonProperty(JSON_PROPERTY_UPGRADE_STRATEGY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpgradeStrategy(@jakarta.annotation.Nullable UpgradeStrategyEnum upgradeStrategy) {
    this.upgradeStrategy = upgradeStrategy;
  }

  public TierGroup downgradeStrategy(@jakarta.annotation.Nullable DowngradeStrategyEnum downgradeStrategy) {
    
    this.downgradeStrategy = downgradeStrategy;
    return this;
  }

  /**
   * Select real_time to downgrade tier on real time balance updates. Select membership_anniversary to downgrade tier on subscription anniversary. Select tier_anniversary to downgrade tier on tier anniversary.
   * @return downgradeStrategy
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DOWNGRADE_STRATEGY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DowngradeStrategyEnum getDowngradeStrategy() {
    return downgradeStrategy;
  }


  @JsonProperty(JSON_PROPERTY_DOWNGRADE_STRATEGY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDowngradeStrategy(@jakarta.annotation.Nullable DowngradeStrategyEnum downgradeStrategy) {
    this.downgradeStrategy = downgradeStrategy;
  }

  public TierGroup createdAt(@jakarta.annotation.Nullable OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Timestamp when the tier group was created
   * @return createdAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedAt(@jakarta.annotation.Nullable OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public TierGroup updatedAt(@jakarta.annotation.Nullable OffsetDateTime updatedAt) {
    
    this.updatedAt = updatedAt;
    return this;
  }

  /**
   * Timestamp when the tier group was last updated
   * @return updatedAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedAt(@jakarta.annotation.Nullable OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TierGroup tierGroup = (TierGroup) o;
    return Objects.equals(this.id, tierGroup.id) &&
        Objects.equals(this.name, tierGroup.name) &&
        Objects.equals(this.tierOrder, tierGroup.tierOrder) &&
        Objects.equals(this.loyaltyProgramId, tierGroup.loyaltyProgramId) &&
        Objects.equals(this.upgradeStrategy, tierGroup.upgradeStrategy) &&
        Objects.equals(this.downgradeStrategy, tierGroup.downgradeStrategy) &&
        Objects.equals(this.createdAt, tierGroup.createdAt) &&
        Objects.equals(this.updatedAt, tierGroup.updatedAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, tierOrder, loyaltyProgramId, upgradeStrategy, downgradeStrategy, createdAt, updatedAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TierGroup {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    tierOrder: ").append(toIndentedString(tierOrder)).append("\n");
    sb.append("    loyaltyProgramId: ").append(toIndentedString(loyaltyProgramId)).append("\n");
    sb.append("    upgradeStrategy: ").append(toIndentedString(upgradeStrategy)).append("\n");
    sb.append("    downgradeStrategy: ").append(toIndentedString(downgradeStrategy)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `name` to the URL query string
    if (getName() != null) {
      try {
        joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tierOrder` to the URL query string
    if (getTierOrder() != null) {
      for (int i = 0; i < getTierOrder().size(); i++) {
        if (getTierOrder().get(i) != null) {
          try {
            joiner.add(String.format("%stierOrder%s%s=%s", prefix, suffix,
                "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
                URLEncoder.encode(String.valueOf(getTierOrder().get(i)), "UTF-8").replaceAll("\\+", "%20")));
          } catch (UnsupportedEncodingException e) {
            // Should never happen, UTF-8 is always supported
            throw new RuntimeException(e);
          }
        }
      }
    }

    // add `loyaltyProgramId` to the URL query string
    if (getLoyaltyProgramId() != null) {
      try {
        joiner.add(String.format("%sloyaltyProgramId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getLoyaltyProgramId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `upgradeStrategy` to the URL query string
    if (getUpgradeStrategy() != null) {
      try {
        joiner.add(String.format("%supgradeStrategy%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUpgradeStrategy()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `downgradeStrategy` to the URL query string
    if (getDowngradeStrategy() != null) {
      try {
        joiner.add(String.format("%sdowngradeStrategy%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDowngradeStrategy()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `createdAt` to the URL query string
    if (getCreatedAt() != null) {
      try {
        joiner.add(String.format("%screatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreatedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `updatedAt` to the URL query string
    if (getUpdatedAt() != null) {
      try {
        joiner.add(String.format("%supdatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUpdatedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

