/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Task Details
 */
@JsonPropertyOrder({
  Task.JSON_PROPERTY_ID,
  Task.JSON_PROPERTY_TASK_TYPE_ID,
  Task.JSON_PROPERTY_NAME,
  Task.JSON_PROPERTY_CONTACTS_IDS,
  Task.JSON_PROPERTY_DEALS_IDS,
  Task.JSON_PROPERTY_COMPANIES_IDS
})
public class Task {
  public static final String JSON_PROPERTY_ID = "id";
  @jakarta.annotation.Nullable
  private String id;

  public static final String JSON_PROPERTY_TASK_TYPE_ID = "taskTypeId";
  @jakarta.annotation.Nonnull
  private String taskTypeId;

  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nonnull
  private String name;

  public static final String JSON_PROPERTY_CONTACTS_IDS = "contactsIds";
  @jakarta.annotation.Nullable
  private List<Integer> contactsIds = new ArrayList<>();

  public static final String JSON_PROPERTY_DEALS_IDS = "dealsIds";
  @jakarta.annotation.Nullable
  private List<String> dealsIds = new ArrayList<>();

  public static final String JSON_PROPERTY_COMPANIES_IDS = "companiesIds";
  @jakarta.annotation.Nullable
  private List<String> companiesIds = new ArrayList<>();

  public Task() {
  }

  public Task id(@jakarta.annotation.Nullable String id) {
    
    this.id = id;
    return this;
  }

  /**
   * Unique task id
   * @return id
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(@jakarta.annotation.Nullable String id) {
    this.id = id;
  }

  public Task taskTypeId(@jakarta.annotation.Nonnull String taskTypeId) {
    
    this.taskTypeId = taskTypeId;
    return this;
  }

  /**
   * Id for type of task e.g Call / Email / Meeting etc.
   * @return taskTypeId
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TASK_TYPE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTaskTypeId() {
    return taskTypeId;
  }


  @JsonProperty(JSON_PROPERTY_TASK_TYPE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTaskTypeId(@jakarta.annotation.Nonnull String taskTypeId) {
    this.taskTypeId = taskTypeId;
  }

  public Task name(@jakarta.annotation.Nonnull String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Name of task
   * @return name
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(@jakarta.annotation.Nonnull String name) {
    this.name = name;
  }

  public Task contactsIds(@jakarta.annotation.Nullable List<Integer> contactsIds) {
    
    this.contactsIds = contactsIds;
    return this;
  }

  public Task addContactsIdsItem(Integer contactsIdsItem) {
    if (this.contactsIds == null) {
      this.contactsIds = new ArrayList<>();
    }
    this.contactsIds.add(contactsIdsItem);
    return this;
  }

  /**
   * Contact ids for contacts linked to this task
   * @return contactsIds
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTACTS_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Integer> getContactsIds() {
    return contactsIds;
  }


  @JsonProperty(JSON_PROPERTY_CONTACTS_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContactsIds(@jakarta.annotation.Nullable List<Integer> contactsIds) {
    this.contactsIds = contactsIds;
  }

  public Task dealsIds(@jakarta.annotation.Nullable List<String> dealsIds) {
    
    this.dealsIds = dealsIds;
    return this;
  }

  public Task addDealsIdsItem(String dealsIdsItem) {
    if (this.dealsIds == null) {
      this.dealsIds = new ArrayList<>();
    }
    this.dealsIds.add(dealsIdsItem);
    return this;
  }

  /**
   * Deal ids for deals a task is linked to
   * @return dealsIds
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DEALS_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getDealsIds() {
    return dealsIds;
  }


  @JsonProperty(JSON_PROPERTY_DEALS_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDealsIds(@jakarta.annotation.Nullable List<String> dealsIds) {
    this.dealsIds = dealsIds;
  }

  public Task companiesIds(@jakarta.annotation.Nullable List<String> companiesIds) {
    
    this.companiesIds = companiesIds;
    return this;
  }

  public Task addCompaniesIdsItem(String companiesIdsItem) {
    if (this.companiesIds == null) {
      this.companiesIds = new ArrayList<>();
    }
    this.companiesIds.add(companiesIdsItem);
    return this;
  }

  /**
   * Companies ids for companies a task is linked to
   * @return companiesIds
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_COMPANIES_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getCompaniesIds() {
    return companiesIds;
  }


  @JsonProperty(JSON_PROPERTY_COMPANIES_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCompaniesIds(@jakarta.annotation.Nullable List<String> companiesIds) {
    this.companiesIds = companiesIds;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Task task = (Task) o;
    return Objects.equals(this.id, task.id) &&
        Objects.equals(this.taskTypeId, task.taskTypeId) &&
        Objects.equals(this.name, task.name) &&
        Objects.equals(this.contactsIds, task.contactsIds) &&
        Objects.equals(this.dealsIds, task.dealsIds) &&
        Objects.equals(this.companiesIds, task.companiesIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, taskTypeId, name, contactsIds, dealsIds, companiesIds);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Task {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    taskTypeId: ").append(toIndentedString(taskTypeId)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    contactsIds: ").append(toIndentedString(contactsIds)).append("\n");
    sb.append("    dealsIds: ").append(toIndentedString(dealsIds)).append("\n");
    sb.append("    companiesIds: ").append(toIndentedString(companiesIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskTypeId` to the URL query string
    if (getTaskTypeId() != null) {
      try {
        joiner.add(String.format("%staskTypeId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskTypeId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `name` to the URL query string
    if (getName() != null) {
      try {
        joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `contactsIds` to the URL query string
    if (getContactsIds() != null) {
      for (int i = 0; i < getContactsIds().size(); i++) {
        try {
          joiner.add(String.format("%scontactsIds%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getContactsIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `dealsIds` to the URL query string
    if (getDealsIds() != null) {
      for (int i = 0; i < getDealsIds().size(); i++) {
        try {
          joiner.add(String.format("%sdealsIds%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getDealsIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `companiesIds` to the URL query string
    if (getCompaniesIds() != null) {
      for (int i = 0; i < getCompaniesIds().size(); i++) {
        try {
          joiner.add(String.format("%scompaniesIds%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getCompaniesIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    return joiner.toString();
  }

}

