/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import software.xdev.brevo.model.SendWhatsappMessageTemplate;
import software.xdev.brevo.model.SendWhatsappMessageText;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * SendWhatsappMessageRequest
 */
@JsonPropertyOrder({
  SendWhatsappMessageRequest.JSON_PROPERTY_TEMPLATE_ID,
  SendWhatsappMessageRequest.JSON_PROPERTY_SENDER_NUMBER,
  SendWhatsappMessageRequest.JSON_PROPERTY_PARAMS,
  SendWhatsappMessageRequest.JSON_PROPERTY_CONTACT_NUMBERS,
  SendWhatsappMessageRequest.JSON_PROPERTY_TEXT
})
@JsonTypeName("sendWhatsappMessage_request")
public class SendWhatsappMessageRequest {
  public static final String JSON_PROPERTY_TEMPLATE_ID = "templateId";
  @jakarta.annotation.Nonnull
  private Integer templateId;

  public static final String JSON_PROPERTY_SENDER_NUMBER = "senderNumber";
  @jakarta.annotation.Nonnull
  private String senderNumber;

  public static final String JSON_PROPERTY_PARAMS = "params";
  @jakarta.annotation.Nullable
  private Object params;

  public static final String JSON_PROPERTY_CONTACT_NUMBERS = "contactNumbers";
  @jakarta.annotation.Nonnull
  private List<String> contactNumbers = new ArrayList<>();

  public static final String JSON_PROPERTY_TEXT = "text";
  @jakarta.annotation.Nonnull
  private String text;

  public SendWhatsappMessageRequest() {
  }

  public SendWhatsappMessageRequest templateId(@jakarta.annotation.Nonnull Integer templateId) {
    
    this.templateId = templateId;
    return this;
  }

  /**
   * ID of the template to send
   * @return templateId
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TEMPLATE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getTemplateId() {
    return templateId;
  }


  @JsonProperty(JSON_PROPERTY_TEMPLATE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTemplateId(@jakarta.annotation.Nonnull Integer templateId) {
    this.templateId = templateId;
  }

  public SendWhatsappMessageRequest senderNumber(@jakarta.annotation.Nonnull String senderNumber) {
    
    this.senderNumber = senderNumber;
    return this;
  }

  /**
   * WhatsApp Number with country code. Example, 85264318721
   * @return senderNumber
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SENDER_NUMBER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSenderNumber() {
    return senderNumber;
  }


  @JsonProperty(JSON_PROPERTY_SENDER_NUMBER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSenderNumber(@jakarta.annotation.Nonnull String senderNumber) {
    this.senderNumber = senderNumber;
  }

  public SendWhatsappMessageRequest params(@jakarta.annotation.Nullable Object params) {
    
    this.params = params;
    return this;
  }

  /**
   * Pass the set of attributes to customize the template. For example, {\&quot;FNAME\&quot;:\&quot;Joe\&quot;, \&quot;LNAME\&quot;:\&quot;Doe\&quot;}.
   * @return params
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PARAMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getParams() {
    return params;
  }


  @JsonProperty(JSON_PROPERTY_PARAMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setParams(@jakarta.annotation.Nullable Object params) {
    this.params = params;
  }

  public SendWhatsappMessageRequest contactNumbers(@jakarta.annotation.Nonnull List<String> contactNumbers) {
    
    this.contactNumbers = contactNumbers;
    return this;
  }

  public SendWhatsappMessageRequest addContactNumbersItem(String contactNumbersItem) {
    if (this.contactNumbers == null) {
      this.contactNumbers = new ArrayList<>();
    }
    this.contactNumbers.add(contactNumbersItem);
    return this;
  }

  /**
   * List of phone numbers of the contacts
   * @return contactNumbers
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CONTACT_NUMBERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getContactNumbers() {
    return contactNumbers;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT_NUMBERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContactNumbers(@jakarta.annotation.Nonnull List<String> contactNumbers) {
    this.contactNumbers = contactNumbers;
  }

  public SendWhatsappMessageRequest text(@jakarta.annotation.Nonnull String text) {
    
    this.text = text;
    return this;
  }

  /**
   * Text to be sent as message body (will be overridden if templateId is passed in the same request)
   * @return text
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getText() {
    return text;
  }


  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setText(@jakarta.annotation.Nonnull String text) {
    this.text = text;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SendWhatsappMessageRequest sendWhatsappMessageRequest = (SendWhatsappMessageRequest) o;
    return Objects.equals(this.templateId, sendWhatsappMessageRequest.templateId) &&
        Objects.equals(this.senderNumber, sendWhatsappMessageRequest.senderNumber) &&
        Objects.equals(this.params, sendWhatsappMessageRequest.params) &&
        Objects.equals(this.contactNumbers, sendWhatsappMessageRequest.contactNumbers) &&
        Objects.equals(this.text, sendWhatsappMessageRequest.text);
  }

  @Override
  public int hashCode() {
    return Objects.hash(templateId, senderNumber, params, contactNumbers, text);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SendWhatsappMessageRequest {\n");
    sb.append("    templateId: ").append(toIndentedString(templateId)).append("\n");
    sb.append("    senderNumber: ").append(toIndentedString(senderNumber)).append("\n");
    sb.append("    params: ").append(toIndentedString(params)).append("\n");
    sb.append("    contactNumbers: ").append(toIndentedString(contactNumbers)).append("\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `templateId` to the URL query string
    if (getTemplateId() != null) {
      try {
        joiner.add(String.format("%stemplateId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTemplateId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `senderNumber` to the URL query string
    if (getSenderNumber() != null) {
      try {
        joiner.add(String.format("%ssenderNumber%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSenderNumber()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `params` to the URL query string
    if (getParams() != null) {
      try {
        joiner.add(String.format("%sparams%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getParams()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `contactNumbers` to the URL query string
    if (getContactNumbers() != null) {
      for (int i = 0; i < getContactNumbers().size(); i++) {
        try {
          joiner.add(String.format("%scontactNumbers%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getContactNumbers().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `text` to the URL query string
    if (getText() != null) {
      try {
        joiner.add(String.format("%stext%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getText()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

