/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.xdev.brevo.model.SendSmtpEmailAttachmentInner;
import software.xdev.brevo.model.SendSmtpEmailBccInner;
import software.xdev.brevo.model.SendSmtpEmailCcInner;
import software.xdev.brevo.model.SendSmtpEmailMessageVersionsInner;
import software.xdev.brevo.model.SendSmtpEmailReplyTo;
import software.xdev.brevo.model.SendSmtpEmailSender;
import software.xdev.brevo.model.SendSmtpEmailToInner;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * SendSmtpEmail
 */
@JsonPropertyOrder({
  SendSmtpEmail.JSON_PROPERTY_SENDER,
  SendSmtpEmail.JSON_PROPERTY_TO,
  SendSmtpEmail.JSON_PROPERTY_BCC,
  SendSmtpEmail.JSON_PROPERTY_CC,
  SendSmtpEmail.JSON_PROPERTY_HTML_CONTENT,
  SendSmtpEmail.JSON_PROPERTY_TEXT_CONTENT,
  SendSmtpEmail.JSON_PROPERTY_SUBJECT,
  SendSmtpEmail.JSON_PROPERTY_REPLY_TO,
  SendSmtpEmail.JSON_PROPERTY_ATTACHMENT,
  SendSmtpEmail.JSON_PROPERTY_HEADERS,
  SendSmtpEmail.JSON_PROPERTY_TEMPLATE_ID,
  SendSmtpEmail.JSON_PROPERTY_PARAMS,
  SendSmtpEmail.JSON_PROPERTY_MESSAGE_VERSIONS,
  SendSmtpEmail.JSON_PROPERTY_TAGS,
  SendSmtpEmail.JSON_PROPERTY_SCHEDULED_AT,
  SendSmtpEmail.JSON_PROPERTY_BATCH_ID,
  SendSmtpEmail.JSON_PROPERTY_PREHEADER
})
@JsonTypeName("sendSmtpEmail")
public class SendSmtpEmail {
  public static final String JSON_PROPERTY_SENDER = "sender";
  @jakarta.annotation.Nullable
  private SendSmtpEmailSender sender;

  public static final String JSON_PROPERTY_TO = "to";
  @jakarta.annotation.Nullable
  private List<SendSmtpEmailToInner> to = new ArrayList<>();

  public static final String JSON_PROPERTY_BCC = "bcc";
  @jakarta.annotation.Nullable
  private List<SendSmtpEmailBccInner> bcc = new ArrayList<>();

  public static final String JSON_PROPERTY_CC = "cc";
  @jakarta.annotation.Nullable
  private List<SendSmtpEmailCcInner> cc = new ArrayList<>();

  public static final String JSON_PROPERTY_HTML_CONTENT = "htmlContent";
  @jakarta.annotation.Nullable
  private String htmlContent;

  public static final String JSON_PROPERTY_TEXT_CONTENT = "textContent";
  @jakarta.annotation.Nullable
  private String textContent;

  public static final String JSON_PROPERTY_SUBJECT = "subject";
  @jakarta.annotation.Nullable
  private String subject;

  public static final String JSON_PROPERTY_REPLY_TO = "replyTo";
  @jakarta.annotation.Nullable
  private SendSmtpEmailReplyTo replyTo;

  public static final String JSON_PROPERTY_ATTACHMENT = "attachment";
  @jakarta.annotation.Nullable
  private List<SendSmtpEmailAttachmentInner> attachment = new ArrayList<>();

  public static final String JSON_PROPERTY_HEADERS = "headers";
  @jakarta.annotation.Nullable
  private Map<String, Object> headers = new HashMap<>();

  public static final String JSON_PROPERTY_TEMPLATE_ID = "templateId";
  @jakarta.annotation.Nullable
  private Long templateId;

  public static final String JSON_PROPERTY_PARAMS = "params";
  @jakarta.annotation.Nullable
  private Map<String, Object> params = new HashMap<>();

  public static final String JSON_PROPERTY_MESSAGE_VERSIONS = "messageVersions";
  @jakarta.annotation.Nullable
  private List<SendSmtpEmailMessageVersionsInner> messageVersions = new ArrayList<>();

  public static final String JSON_PROPERTY_TAGS = "tags";
  @jakarta.annotation.Nullable
  private List<String> tags = new ArrayList<>();

  public static final String JSON_PROPERTY_SCHEDULED_AT = "scheduledAt";
  @jakarta.annotation.Nullable
  private OffsetDateTime scheduledAt;

  public static final String JSON_PROPERTY_BATCH_ID = "batchId";
  @jakarta.annotation.Nullable
  private String batchId;

  public static final String JSON_PROPERTY_PREHEADER = "preheader";
  @jakarta.annotation.Nullable
  private String preheader;

  public SendSmtpEmail() {
  }

  public SendSmtpEmail sender(@jakarta.annotation.Nullable SendSmtpEmailSender sender) {
    
    this.sender = sender;
    return this;
  }

  /**
   * Get sender
   * @return sender
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SENDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SendSmtpEmailSender getSender() {
    return sender;
  }


  @JsonProperty(JSON_PROPERTY_SENDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSender(@jakarta.annotation.Nullable SendSmtpEmailSender sender) {
    this.sender = sender;
  }

  public SendSmtpEmail to(@jakarta.annotation.Nullable List<SendSmtpEmailToInner> to) {
    
    this.to = to;
    return this;
  }

  public SendSmtpEmail addToItem(SendSmtpEmailToInner toItem) {
    if (this.to == null) {
      this.to = new ArrayList<>();
    }
    this.to.add(toItem);
    return this;
  }

  /**
   * **Mandatory if messageVersions are not passed, ignored if messageVersions are passed** List of email addresses and names (_optional_) of the recipients. For example, **[{\&quot;name\&quot;:\&quot;Jimmy\&quot;, \&quot;email\&quot;:\&quot;jimmy98@example.com\&quot;}, {\&quot;name\&quot;:\&quot;Joe\&quot;, \&quot;email\&quot;:\&quot;joe@example.com\&quot;}]** 
   * @return to
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SendSmtpEmailToInner> getTo() {
    return to;
  }


  @JsonProperty(JSON_PROPERTY_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTo(@jakarta.annotation.Nullable List<SendSmtpEmailToInner> to) {
    this.to = to;
  }

  public SendSmtpEmail bcc(@jakarta.annotation.Nullable List<SendSmtpEmailBccInner> bcc) {
    
    this.bcc = bcc;
    return this;
  }

  public SendSmtpEmail addBccItem(SendSmtpEmailBccInner bccItem) {
    if (this.bcc == null) {
      this.bcc = new ArrayList<>();
    }
    this.bcc.add(bccItem);
    return this;
  }

  /**
   * List of email addresses and names (_optional_) of the recipients in bcc 
   * @return bcc
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BCC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SendSmtpEmailBccInner> getBcc() {
    return bcc;
  }


  @JsonProperty(JSON_PROPERTY_BCC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBcc(@jakarta.annotation.Nullable List<SendSmtpEmailBccInner> bcc) {
    this.bcc = bcc;
  }

  public SendSmtpEmail cc(@jakarta.annotation.Nullable List<SendSmtpEmailCcInner> cc) {
    
    this.cc = cc;
    return this;
  }

  public SendSmtpEmail addCcItem(SendSmtpEmailCcInner ccItem) {
    if (this.cc == null) {
      this.cc = new ArrayList<>();
    }
    this.cc.add(ccItem);
    return this;
  }

  /**
   * List of email addresses and names (_optional_) of the recipients in cc 
   * @return cc
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SendSmtpEmailCcInner> getCc() {
    return cc;
  }


  @JsonProperty(JSON_PROPERTY_CC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCc(@jakarta.annotation.Nullable List<SendSmtpEmailCcInner> cc) {
    this.cc = cc;
  }

  public SendSmtpEmail htmlContent(@jakarta.annotation.Nullable String htmlContent) {
    
    this.htmlContent = htmlContent;
    return this;
  }

  /**
   * HTML body of the message. **Mandatory if &#39;templateId&#39; is not passed, ignored if &#39;templateId&#39; is passed** 
   * @return htmlContent
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HTML_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHtmlContent() {
    return htmlContent;
  }


  @JsonProperty(JSON_PROPERTY_HTML_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHtmlContent(@jakarta.annotation.Nullable String htmlContent) {
    this.htmlContent = htmlContent;
  }

  public SendSmtpEmail textContent(@jakarta.annotation.Nullable String textContent) {
    
    this.textContent = textContent;
    return this;
  }

  /**
   * Plain Text body of the message. **Ignored if &#39;templateId&#39; is passed** 
   * @return textContent
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TEXT_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTextContent() {
    return textContent;
  }


  @JsonProperty(JSON_PROPERTY_TEXT_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTextContent(@jakarta.annotation.Nullable String textContent) {
    this.textContent = textContent;
  }

  public SendSmtpEmail subject(@jakarta.annotation.Nullable String subject) {
    
    this.subject = subject;
    return this;
  }

  /**
   * Subject of the message. **Mandatory if &#39;templateId&#39; is not passed** 
   * @return subject
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubject() {
    return subject;
  }


  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubject(@jakarta.annotation.Nullable String subject) {
    this.subject = subject;
  }

  public SendSmtpEmail replyTo(@jakarta.annotation.Nullable SendSmtpEmailReplyTo replyTo) {
    
    this.replyTo = replyTo;
    return this;
  }

  /**
   * Get replyTo
   * @return replyTo
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REPLY_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SendSmtpEmailReplyTo getReplyTo() {
    return replyTo;
  }


  @JsonProperty(JSON_PROPERTY_REPLY_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReplyTo(@jakarta.annotation.Nullable SendSmtpEmailReplyTo replyTo) {
    this.replyTo = replyTo;
  }

  public SendSmtpEmail attachment(@jakarta.annotation.Nullable List<SendSmtpEmailAttachmentInner> attachment) {
    
    this.attachment = attachment;
    return this;
  }

  public SendSmtpEmail addAttachmentItem(SendSmtpEmailAttachmentInner attachmentItem) {
    if (this.attachment == null) {
      this.attachment = new ArrayList<>();
    }
    this.attachment.add(attachmentItem);
    return this;
  }

  /**
   * Pass the _absolute URL_ (**no local file**) or the _base64 content_ of the attachment along with the attachment name. **Mandatory if attachment content is passed**. For example, **[{\&quot;url\&quot;:\&quot;https://attachment.domain.com/myAttachmentFromUrl.jpg\&quot;, \&quot;name\&quot;:\&quot;myAttachmentFromUrl.jpg\&quot;}, {\&quot;content\&quot;:\&quot;base64 example content\&quot;, \&quot;name\&quot;:\&quot;myAttachmentFromBase64.jpg\&quot;}]**. Allowed extensions for attachment file: #### xlsx, xls, ods, docx, docm, doc, csv, pdf, txt, gif, jpg, jpeg, png, tif, tiff, rtf, bmp, cgm, css, shtml, html, htm, zip, xml, ppt, pptx, tar, ez, ics, mobi, msg, pub, eps, odt, mp3, m4a, m4v, wma, ogg, flac, wav, aif, aifc, aiff, mp4, mov, avi, mkv, mpeg, mpg, wmv, pkpass and xlsm. If &#x60;templateId&#x60; is passed and is in New Template Language format then both attachment url and content are accepted. If template is in Old template Language format, then &#x60;attachment&#x60; is ignored 
   * @return attachment
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ATTACHMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SendSmtpEmailAttachmentInner> getAttachment() {
    return attachment;
  }


  @JsonProperty(JSON_PROPERTY_ATTACHMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttachment(@jakarta.annotation.Nullable List<SendSmtpEmailAttachmentInner> attachment) {
    this.attachment = attachment;
  }

  public SendSmtpEmail headers(@jakarta.annotation.Nullable Map<String, Object> headers) {
    
    this.headers = headers;
    return this;
  }

  public SendSmtpEmail putHeadersItem(String key, Object headersItem) {
    if (this.headers == null) {
      this.headers = new HashMap<>();
    }
    this.headers.put(key, headersItem);
    return this;
  }

  /**
   * Pass the set of custom headers (_not the standard headers_) that shall be sent along the mail headers in the original email. **&#39;sender.ip&#39;** header can be set (**only for dedicated ip users**) to mention the IP to be used for sending transactional emails. Headers are allowed in &#x60;This-Case-Only&#x60; (i.e. words separated by hyphen with first letter of each word in capital letter), they will be converted to such case styling if not in this format in the request payload. For example, **{\&quot;sender.ip\&quot;:\&quot;1.2.3.4\&quot;, \&quot;X-Mailin-custom\&quot;:\&quot;some_custom_header\&quot;, \&quot;idempotencyKey\&quot;:\&quot;abc-123\&quot;}**. 
   * @return headers
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HEADERS)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getHeaders() {
    return headers;
  }


  @JsonProperty(JSON_PROPERTY_HEADERS)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setHeaders(@jakarta.annotation.Nullable Map<String, Object> headers) {
    this.headers = headers;
  }

  public SendSmtpEmail templateId(@jakarta.annotation.Nullable Long templateId) {
    
    this.templateId = templateId;
    return this;
  }

  /**
   * Id of the template.
   * @return templateId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TEMPLATE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTemplateId() {
    return templateId;
  }


  @JsonProperty(JSON_PROPERTY_TEMPLATE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTemplateId(@jakarta.annotation.Nullable Long templateId) {
    this.templateId = templateId;
  }

  public SendSmtpEmail params(@jakarta.annotation.Nullable Map<String, Object> params) {
    
    this.params = params;
    return this;
  }

  public SendSmtpEmail putParamsItem(String key, Object paramsItem) {
    if (this.params == null) {
      this.params = new HashMap<>();
    }
    this.params.put(key, paramsItem);
    return this;
  }

  /**
   * Pass the set of attributes to customize the template. For example, **{\&quot;FNAME\&quot;:\&quot;Joe\&quot;, \&quot;LNAME\&quot;:\&quot;Doe\&quot;}**. It&#39;s **considered only if template is in New Template Language format**. 
   * @return params
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PARAMS)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getParams() {
    return params;
  }


  @JsonProperty(JSON_PROPERTY_PARAMS)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setParams(@jakarta.annotation.Nullable Map<String, Object> params) {
    this.params = params;
  }

  public SendSmtpEmail messageVersions(@jakarta.annotation.Nullable List<SendSmtpEmailMessageVersionsInner> messageVersions) {
    
    this.messageVersions = messageVersions;
    return this;
  }

  public SendSmtpEmail addMessageVersionsItem(SendSmtpEmailMessageVersionsInner messageVersionsItem) {
    if (this.messageVersions == null) {
      this.messageVersions = new ArrayList<>();
    }
    this.messageVersions.add(messageVersionsItem);
    return this;
  }

  /**
   * You can customize and send out multiple versions of a mail. **templateId** can be customized only if global parameter contains templateId. **htmlContent and textContent** can be customized only if any of the two, htmlContent or textContent, is present in global parameters. Some global parameters such as **to(mandatory), bcc, cc, replyTo, subject** can also be customized specific to each version. Total number of recipients in one API request must not exceed 2000. However, you can still pass upto 99 recipients maximum in one message version. The size of individual params in all the messageVersions shall not exceed **100 KB** limit and that of cumulative params shall not exceed **1000 KB**. You can follow this **step-by-step guide** on how to use **messageVersions** to batch send emails - **https://developers.brevo.com/docs/batch-send-transactional-emails** 
   * @return messageVersions
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MESSAGE_VERSIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SendSmtpEmailMessageVersionsInner> getMessageVersions() {
    return messageVersions;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGE_VERSIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessageVersions(@jakarta.annotation.Nullable List<SendSmtpEmailMessageVersionsInner> messageVersions) {
    this.messageVersions = messageVersions;
  }

  public SendSmtpEmail tags(@jakarta.annotation.Nullable List<String> tags) {
    
    this.tags = tags;
    return this;
  }

  public SendSmtpEmail addTagsItem(String tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

  /**
   * Tag your emails to find them more easily
   * @return tags
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getTags() {
    return tags;
  }


  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(@jakarta.annotation.Nullable List<String> tags) {
    this.tags = tags;
  }

  public SendSmtpEmail scheduledAt(@jakarta.annotation.Nullable OffsetDateTime scheduledAt) {
    
    this.scheduledAt = scheduledAt;
    return this;
  }

  /**
   * UTC date-time on which the email has to schedule (YYYY-MM-DDTHH:mm:ss.SSSZ). Prefer to pass your timezone in date-time format for scheduling. There can be an expected delay of +5 minutes in scheduled email delivery.
   * @return scheduledAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SCHEDULED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getScheduledAt() {
    return scheduledAt;
  }


  @JsonProperty(JSON_PROPERTY_SCHEDULED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScheduledAt(@jakarta.annotation.Nullable OffsetDateTime scheduledAt) {
    this.scheduledAt = scheduledAt;
  }

  public SendSmtpEmail batchId(@jakarta.annotation.Nullable String batchId) {
    
    this.batchId = batchId;
    return this;
  }

  /**
   * Valid UUIDv4 batch id to identify the scheduled batches transactional email. If not passed we will create a valid UUIDv4 batch id at our end.
   * @return batchId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BATCH_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBatchId() {
    return batchId;
  }


  @JsonProperty(JSON_PROPERTY_BATCH_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBatchId(@jakarta.annotation.Nullable String batchId) {
    this.batchId = batchId;
  }

  public SendSmtpEmail preheader(@jakarta.annotation.Nullable String preheader) {
    
    this.preheader = preheader;
    return this;
  }

  /**
   * A short summary that appears next to the subject line in the recipient’s inbox. This preview text gives recipients a quick idea of what the email is about before they open it. 
   * @return preheader
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PREHEADER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPreheader() {
    return preheader;
  }


  @JsonProperty(JSON_PROPERTY_PREHEADER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPreheader(@jakarta.annotation.Nullable String preheader) {
    this.preheader = preheader;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SendSmtpEmail sendSmtpEmail = (SendSmtpEmail) o;
    return Objects.equals(this.sender, sendSmtpEmail.sender) &&
        Objects.equals(this.to, sendSmtpEmail.to) &&
        Objects.equals(this.bcc, sendSmtpEmail.bcc) &&
        Objects.equals(this.cc, sendSmtpEmail.cc) &&
        Objects.equals(this.htmlContent, sendSmtpEmail.htmlContent) &&
        Objects.equals(this.textContent, sendSmtpEmail.textContent) &&
        Objects.equals(this.subject, sendSmtpEmail.subject) &&
        Objects.equals(this.replyTo, sendSmtpEmail.replyTo) &&
        Objects.equals(this.attachment, sendSmtpEmail.attachment) &&
        Objects.equals(this.headers, sendSmtpEmail.headers) &&
        Objects.equals(this.templateId, sendSmtpEmail.templateId) &&
        Objects.equals(this.params, sendSmtpEmail.params) &&
        Objects.equals(this.messageVersions, sendSmtpEmail.messageVersions) &&
        Objects.equals(this.tags, sendSmtpEmail.tags) &&
        Objects.equals(this.scheduledAt, sendSmtpEmail.scheduledAt) &&
        Objects.equals(this.batchId, sendSmtpEmail.batchId) &&
        Objects.equals(this.preheader, sendSmtpEmail.preheader);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sender, to, bcc, cc, htmlContent, textContent, subject, replyTo, attachment, headers, templateId, params, messageVersions, tags, scheduledAt, batchId, preheader);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SendSmtpEmail {\n");
    sb.append("    sender: ").append(toIndentedString(sender)).append("\n");
    sb.append("    to: ").append(toIndentedString(to)).append("\n");
    sb.append("    bcc: ").append(toIndentedString(bcc)).append("\n");
    sb.append("    cc: ").append(toIndentedString(cc)).append("\n");
    sb.append("    htmlContent: ").append(toIndentedString(htmlContent)).append("\n");
    sb.append("    textContent: ").append(toIndentedString(textContent)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("    replyTo: ").append(toIndentedString(replyTo)).append("\n");
    sb.append("    attachment: ").append(toIndentedString(attachment)).append("\n");
    sb.append("    headers: ").append(toIndentedString(headers)).append("\n");
    sb.append("    templateId: ").append(toIndentedString(templateId)).append("\n");
    sb.append("    params: ").append(toIndentedString(params)).append("\n");
    sb.append("    messageVersions: ").append(toIndentedString(messageVersions)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    scheduledAt: ").append(toIndentedString(scheduledAt)).append("\n");
    sb.append("    batchId: ").append(toIndentedString(batchId)).append("\n");
    sb.append("    preheader: ").append(toIndentedString(preheader)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `sender` to the URL query string
    if (getSender() != null) {
      joiner.add(getSender().toUrlQueryString(prefix + "sender" + suffix));
    }

    // add `to` to the URL query string
    if (getTo() != null) {
      for (int i = 0; i < getTo().size(); i++) {
        if (getTo().get(i) != null) {
          joiner.add(getTo().get(i).toUrlQueryString(String.format("%sto%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `bcc` to the URL query string
    if (getBcc() != null) {
      for (int i = 0; i < getBcc().size(); i++) {
        if (getBcc().get(i) != null) {
          joiner.add(getBcc().get(i).toUrlQueryString(String.format("%sbcc%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `cc` to the URL query string
    if (getCc() != null) {
      for (int i = 0; i < getCc().size(); i++) {
        if (getCc().get(i) != null) {
          joiner.add(getCc().get(i).toUrlQueryString(String.format("%scc%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `htmlContent` to the URL query string
    if (getHtmlContent() != null) {
      try {
        joiner.add(String.format("%shtmlContent%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getHtmlContent()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `textContent` to the URL query string
    if (getTextContent() != null) {
      try {
        joiner.add(String.format("%stextContent%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTextContent()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `subject` to the URL query string
    if (getSubject() != null) {
      try {
        joiner.add(String.format("%ssubject%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSubject()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `replyTo` to the URL query string
    if (getReplyTo() != null) {
      joiner.add(getReplyTo().toUrlQueryString(prefix + "replyTo" + suffix));
    }

    // add `attachment` to the URL query string
    if (getAttachment() != null) {
      for (int i = 0; i < getAttachment().size(); i++) {
        if (getAttachment().get(i) != null) {
          joiner.add(getAttachment().get(i).toUrlQueryString(String.format("%sattachment%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `headers` to the URL query string
    if (getHeaders() != null) {
      for (String _key : getHeaders().keySet()) {
        try {
          joiner.add(String.format("%sheaders%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
              getHeaders().get(_key), URLEncoder.encode(String.valueOf(getHeaders().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `templateId` to the URL query string
    if (getTemplateId() != null) {
      try {
        joiner.add(String.format("%stemplateId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTemplateId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `params` to the URL query string
    if (getParams() != null) {
      for (String _key : getParams().keySet()) {
        try {
          joiner.add(String.format("%sparams%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
              getParams().get(_key), URLEncoder.encode(String.valueOf(getParams().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `messageVersions` to the URL query string
    if (getMessageVersions() != null) {
      for (int i = 0; i < getMessageVersions().size(); i++) {
        if (getMessageVersions().get(i) != null) {
          joiner.add(getMessageVersions().get(i).toUrlQueryString(String.format("%smessageVersions%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `tags` to the URL query string
    if (getTags() != null) {
      for (int i = 0; i < getTags().size(); i++) {
        try {
          joiner.add(String.format("%stags%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getTags().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `scheduledAt` to the URL query string
    if (getScheduledAt() != null) {
      try {
        joiner.add(String.format("%sscheduledAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getScheduledAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `batchId` to the URL query string
    if (getBatchId() != null) {
      try {
        joiner.add(String.format("%sbatchId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBatchId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `preheader` to the URL query string
    if (getPreheader() != null) {
      try {
        joiner.add(String.format("%spreheader%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPreheader()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

