/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import software.xdev.brevo.model.RequestContactImportJsonBodyInner;
import software.xdev.brevo.model.RequestContactImportNewList;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * RequestContactImport
 */
@JsonPropertyOrder({
  RequestContactImport.JSON_PROPERTY_FILE_URL,
  RequestContactImport.JSON_PROPERTY_FILE_BODY,
  RequestContactImport.JSON_PROPERTY_JSON_BODY,
  RequestContactImport.JSON_PROPERTY_LIST_IDS,
  RequestContactImport.JSON_PROPERTY_NOTIFY_URL,
  RequestContactImport.JSON_PROPERTY_NEW_LIST,
  RequestContactImport.JSON_PROPERTY_EMAIL_BLACKLIST,
  RequestContactImport.JSON_PROPERTY_DISABLE_NOTIFICATION,
  RequestContactImport.JSON_PROPERTY_SMS_BLACKLIST,
  RequestContactImport.JSON_PROPERTY_UPDATE_EXISTING_CONTACTS,
  RequestContactImport.JSON_PROPERTY_EMPTY_CONTACTS_ATTRIBUTES
})
@JsonTypeName("requestContactImport")
public class RequestContactImport {
  public static final String JSON_PROPERTY_FILE_URL = "fileUrl";
  @jakarta.annotation.Nullable
  private String fileUrl;

  public static final String JSON_PROPERTY_FILE_BODY = "fileBody";
  @jakarta.annotation.Nullable
  private String fileBody;

  public static final String JSON_PROPERTY_JSON_BODY = "jsonBody";
  @jakarta.annotation.Nullable
  private List<RequestContactImportJsonBodyInner> jsonBody = new ArrayList<>();

  public static final String JSON_PROPERTY_LIST_IDS = "listIds";
  @jakarta.annotation.Nullable
  private List<Long> listIds = new ArrayList<>();

  public static final String JSON_PROPERTY_NOTIFY_URL = "notifyUrl";
  @jakarta.annotation.Nullable
  private String notifyUrl;

  public static final String JSON_PROPERTY_NEW_LIST = "newList";
  @jakarta.annotation.Nullable
  private RequestContactImportNewList newList;

  public static final String JSON_PROPERTY_EMAIL_BLACKLIST = "emailBlacklist";
  @jakarta.annotation.Nullable
  private Boolean emailBlacklist = false;

  public static final String JSON_PROPERTY_DISABLE_NOTIFICATION = "disableNotification";
  @jakarta.annotation.Nullable
  private Boolean disableNotification = false;

  public static final String JSON_PROPERTY_SMS_BLACKLIST = "smsBlacklist";
  @jakarta.annotation.Nullable
  private Boolean smsBlacklist = false;

  public static final String JSON_PROPERTY_UPDATE_EXISTING_CONTACTS = "updateExistingContacts";
  @jakarta.annotation.Nullable
  private Boolean updateExistingContacts = true;

  public static final String JSON_PROPERTY_EMPTY_CONTACTS_ATTRIBUTES = "emptyContactsAttributes";
  @jakarta.annotation.Nullable
  private Boolean emptyContactsAttributes = false;

  public RequestContactImport() {
  }

  public RequestContactImport fileUrl(@jakarta.annotation.Nullable String fileUrl) {
    
    this.fileUrl = fileUrl;
    return this;
  }

  /**
   * **Mandatory if fileBody and jsonBody is not defined.** URL of the file to be imported (**no local file**). Possible file formats: #### .txt, .csv, .json 
   * @return fileUrl
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FILE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFileUrl() {
    return fileUrl;
  }


  @JsonProperty(JSON_PROPERTY_FILE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFileUrl(@jakarta.annotation.Nullable String fileUrl) {
    this.fileUrl = fileUrl;
  }

  public RequestContactImport fileBody(@jakarta.annotation.Nullable String fileBody) {
    
    this.fileBody = fileBody;
    return this;
  }

  /**
   * **Mandatory if fileUrl and jsonBody is not defined.** CSV content to be imported. Use semicolon to separate multiple attributes. **Maximum allowed file body size is 10MB** . However we recommend a safe limit of around 8 MB to avoid the issues caused due to increase of file body size while parsing. Please use fileUrl instead to import bigger files. 
   * @return fileBody
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FILE_BODY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFileBody() {
    return fileBody;
  }


  @JsonProperty(JSON_PROPERTY_FILE_BODY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFileBody(@jakarta.annotation.Nullable String fileBody) {
    this.fileBody = fileBody;
  }

  public RequestContactImport jsonBody(@jakarta.annotation.Nullable List<RequestContactImportJsonBodyInner> jsonBody) {
    
    this.jsonBody = jsonBody;
    return this;
  }

  public RequestContactImport addJsonBodyItem(RequestContactImportJsonBodyInner jsonBodyItem) {
    if (this.jsonBody == null) {
      this.jsonBody = new ArrayList<>();
    }
    this.jsonBody.add(jsonBodyItem);
    return this;
  }

  /**
   * **Mandatory if fileUrl and fileBody is not defined.** JSON content to be imported. **Maximum allowed json body size is 10MB** . However we recommend a safe limit of around 8 MB to avoid the issues caused due to increase of json body size while parsing. Please use fileUrl instead to import bigger files. 
   * @return jsonBody
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_JSON_BODY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RequestContactImportJsonBodyInner> getJsonBody() {
    return jsonBody;
  }


  @JsonProperty(JSON_PROPERTY_JSON_BODY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJsonBody(@jakarta.annotation.Nullable List<RequestContactImportJsonBodyInner> jsonBody) {
    this.jsonBody = jsonBody;
  }

  public RequestContactImport listIds(@jakarta.annotation.Nullable List<Long> listIds) {
    
    this.listIds = listIds;
    return this;
  }

  public RequestContactImport addListIdsItem(Long listIdsItem) {
    if (this.listIds == null) {
      this.listIds = new ArrayList<>();
    }
    this.listIds.add(listIdsItem);
    return this;
  }

  /**
   * **Mandatory if newList is not defined.** Ids of the lists in which the contacts shall be imported. For example, **[2, 4, 7]**. 
   * @return listIds
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LIST_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Long> getListIds() {
    return listIds;
  }


  @JsonProperty(JSON_PROPERTY_LIST_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setListIds(@jakarta.annotation.Nullable List<Long> listIds) {
    this.listIds = listIds;
  }

  public RequestContactImport notifyUrl(@jakarta.annotation.Nullable String notifyUrl) {
    
    this.notifyUrl = notifyUrl;
    return this;
  }

  /**
   * URL that will be called once the import process is finished. For reference, https://help.brevo.com/hc/en-us/articles/360007666479
   * @return notifyUrl
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NOTIFY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNotifyUrl() {
    return notifyUrl;
  }


  @JsonProperty(JSON_PROPERTY_NOTIFY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNotifyUrl(@jakarta.annotation.Nullable String notifyUrl) {
    this.notifyUrl = notifyUrl;
  }

  public RequestContactImport newList(@jakarta.annotation.Nullable RequestContactImportNewList newList) {
    
    this.newList = newList;
    return this;
  }

  /**
   * Get newList
   * @return newList
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NEW_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RequestContactImportNewList getNewList() {
    return newList;
  }


  @JsonProperty(JSON_PROPERTY_NEW_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNewList(@jakarta.annotation.Nullable RequestContactImportNewList newList) {
    this.newList = newList;
  }

  public RequestContactImport emailBlacklist(@jakarta.annotation.Nullable Boolean emailBlacklist) {
    
    this.emailBlacklist = emailBlacklist;
    return this;
  }

  /**
   * To blacklist all the contacts for email
   * @return emailBlacklist
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EMAIL_BLACKLIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEmailBlacklist() {
    return emailBlacklist;
  }


  @JsonProperty(JSON_PROPERTY_EMAIL_BLACKLIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmailBlacklist(@jakarta.annotation.Nullable Boolean emailBlacklist) {
    this.emailBlacklist = emailBlacklist;
  }

  public RequestContactImport disableNotification(@jakarta.annotation.Nullable Boolean disableNotification) {
    
    this.disableNotification = disableNotification;
    return this;
  }

  /**
   * To disable email notification
   * @return disableNotification
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DISABLE_NOTIFICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDisableNotification() {
    return disableNotification;
  }


  @JsonProperty(JSON_PROPERTY_DISABLE_NOTIFICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisableNotification(@jakarta.annotation.Nullable Boolean disableNotification) {
    this.disableNotification = disableNotification;
  }

  public RequestContactImport smsBlacklist(@jakarta.annotation.Nullable Boolean smsBlacklist) {
    
    this.smsBlacklist = smsBlacklist;
    return this;
  }

  /**
   * To blacklist all the contacts for sms
   * @return smsBlacklist
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SMS_BLACKLIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSmsBlacklist() {
    return smsBlacklist;
  }


  @JsonProperty(JSON_PROPERTY_SMS_BLACKLIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSmsBlacklist(@jakarta.annotation.Nullable Boolean smsBlacklist) {
    this.smsBlacklist = smsBlacklist;
  }

  public RequestContactImport updateExistingContacts(@jakarta.annotation.Nullable Boolean updateExistingContacts) {
    
    this.updateExistingContacts = updateExistingContacts;
    return this;
  }

  /**
   * To facilitate the choice to update the existing contacts
   * @return updateExistingContacts
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UPDATE_EXISTING_CONTACTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getUpdateExistingContacts() {
    return updateExistingContacts;
  }


  @JsonProperty(JSON_PROPERTY_UPDATE_EXISTING_CONTACTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdateExistingContacts(@jakarta.annotation.Nullable Boolean updateExistingContacts) {
    this.updateExistingContacts = updateExistingContacts;
  }

  public RequestContactImport emptyContactsAttributes(@jakarta.annotation.Nullable Boolean emptyContactsAttributes) {
    
    this.emptyContactsAttributes = emptyContactsAttributes;
    return this;
  }

  /**
   * To facilitate the choice to erase any attribute of the existing contacts with empty value. emptyContactsAttributes &#x3D; true means the empty fields in your import will erase any attribute that currently contain data in Brevo, &amp; emptyContactsAttributes &#x3D; false means the empty fields will not affect your existing data ( **only available if &#x60;updateExistingContacts&#x60; set to true **) 
   * @return emptyContactsAttributes
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EMPTY_CONTACTS_ATTRIBUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEmptyContactsAttributes() {
    return emptyContactsAttributes;
  }


  @JsonProperty(JSON_PROPERTY_EMPTY_CONTACTS_ATTRIBUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmptyContactsAttributes(@jakarta.annotation.Nullable Boolean emptyContactsAttributes) {
    this.emptyContactsAttributes = emptyContactsAttributes;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RequestContactImport requestContactImport = (RequestContactImport) o;
    return Objects.equals(this.fileUrl, requestContactImport.fileUrl) &&
        Objects.equals(this.fileBody, requestContactImport.fileBody) &&
        Objects.equals(this.jsonBody, requestContactImport.jsonBody) &&
        Objects.equals(this.listIds, requestContactImport.listIds) &&
        Objects.equals(this.notifyUrl, requestContactImport.notifyUrl) &&
        Objects.equals(this.newList, requestContactImport.newList) &&
        Objects.equals(this.emailBlacklist, requestContactImport.emailBlacklist) &&
        Objects.equals(this.disableNotification, requestContactImport.disableNotification) &&
        Objects.equals(this.smsBlacklist, requestContactImport.smsBlacklist) &&
        Objects.equals(this.updateExistingContacts, requestContactImport.updateExistingContacts) &&
        Objects.equals(this.emptyContactsAttributes, requestContactImport.emptyContactsAttributes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fileUrl, fileBody, jsonBody, listIds, notifyUrl, newList, emailBlacklist, disableNotification, smsBlacklist, updateExistingContacts, emptyContactsAttributes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RequestContactImport {\n");
    sb.append("    fileUrl: ").append(toIndentedString(fileUrl)).append("\n");
    sb.append("    fileBody: ").append(toIndentedString(fileBody)).append("\n");
    sb.append("    jsonBody: ").append(toIndentedString(jsonBody)).append("\n");
    sb.append("    listIds: ").append(toIndentedString(listIds)).append("\n");
    sb.append("    notifyUrl: ").append(toIndentedString(notifyUrl)).append("\n");
    sb.append("    newList: ").append(toIndentedString(newList)).append("\n");
    sb.append("    emailBlacklist: ").append(toIndentedString(emailBlacklist)).append("\n");
    sb.append("    disableNotification: ").append(toIndentedString(disableNotification)).append("\n");
    sb.append("    smsBlacklist: ").append(toIndentedString(smsBlacklist)).append("\n");
    sb.append("    updateExistingContacts: ").append(toIndentedString(updateExistingContacts)).append("\n");
    sb.append("    emptyContactsAttributes: ").append(toIndentedString(emptyContactsAttributes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `fileUrl` to the URL query string
    if (getFileUrl() != null) {
      try {
        joiner.add(String.format("%sfileUrl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFileUrl()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `fileBody` to the URL query string
    if (getFileBody() != null) {
      try {
        joiner.add(String.format("%sfileBody%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFileBody()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `jsonBody` to the URL query string
    if (getJsonBody() != null) {
      for (int i = 0; i < getJsonBody().size(); i++) {
        if (getJsonBody().get(i) != null) {
          joiner.add(getJsonBody().get(i).toUrlQueryString(String.format("%sjsonBody%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `listIds` to the URL query string
    if (getListIds() != null) {
      for (int i = 0; i < getListIds().size(); i++) {
        try {
          joiner.add(String.format("%slistIds%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getListIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `notifyUrl` to the URL query string
    if (getNotifyUrl() != null) {
      try {
        joiner.add(String.format("%snotifyUrl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getNotifyUrl()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `newList` to the URL query string
    if (getNewList() != null) {
      joiner.add(getNewList().toUrlQueryString(prefix + "newList" + suffix));
    }

    // add `emailBlacklist` to the URL query string
    if (getEmailBlacklist() != null) {
      try {
        joiner.add(String.format("%semailBlacklist%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEmailBlacklist()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `disableNotification` to the URL query string
    if (getDisableNotification() != null) {
      try {
        joiner.add(String.format("%sdisableNotification%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDisableNotification()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `smsBlacklist` to the URL query string
    if (getSmsBlacklist() != null) {
      try {
        joiner.add(String.format("%ssmsBlacklist%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSmsBlacklist()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `updateExistingContacts` to the URL query string
    if (getUpdateExistingContacts() != null) {
      try {
        joiner.add(String.format("%supdateExistingContacts%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUpdateExistingContacts()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `emptyContactsAttributes` to the URL query string
    if (getEmptyContactsAttributes() != null) {
      try {
        joiner.add(String.format("%semptyContactsAttributes%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEmptyContactsAttributes()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

