/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Identifies the contact associated with the order.
 */
@JsonPropertyOrder({
  OrderIdentifiers.JSON_PROPERTY_EXT_ID,
  OrderIdentifiers.JSON_PROPERTY_LOYALTY_SUBSCRIPTION_ID,
  OrderIdentifiers.JSON_PROPERTY_PHONE_ID,
  OrderIdentifiers.JSON_PROPERTY_EMAIL_ID
})
@JsonTypeName("order_identifiers")
public class OrderIdentifiers {
  public static final String JSON_PROPERTY_EXT_ID = "ext_id";
  @jakarta.annotation.Nullable
  private String extId;

  public static final String JSON_PROPERTY_LOYALTY_SUBSCRIPTION_ID = "loyalty_subscription_id";
  @jakarta.annotation.Nullable
  private String loyaltySubscriptionId;

  public static final String JSON_PROPERTY_PHONE_ID = "phone_id";
  @jakarta.annotation.Nullable
  private String phoneId;

  public static final String JSON_PROPERTY_EMAIL_ID = "email_id";
  @jakarta.annotation.Nullable
  private String emailId;

  public OrderIdentifiers() {
  }

  public OrderIdentifiers extId(@jakarta.annotation.Nullable String extId) {
    
    this.extId = extId;
    return this;
  }

  /**
   * ext_id associated with the order
   * @return extId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EXT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExtId() {
    return extId;
  }


  @JsonProperty(JSON_PROPERTY_EXT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtId(@jakarta.annotation.Nullable String extId) {
    this.extId = extId;
  }

  public OrderIdentifiers loyaltySubscriptionId(@jakarta.annotation.Nullable String loyaltySubscriptionId) {
    
    this.loyaltySubscriptionId = loyaltySubscriptionId;
    return this;
  }

  /**
   * loyalty_subscription_id associated with the order
   * @return loyaltySubscriptionId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LOYALTY_SUBSCRIPTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLoyaltySubscriptionId() {
    return loyaltySubscriptionId;
  }


  @JsonProperty(JSON_PROPERTY_LOYALTY_SUBSCRIPTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLoyaltySubscriptionId(@jakarta.annotation.Nullable String loyaltySubscriptionId) {
    this.loyaltySubscriptionId = loyaltySubscriptionId;
  }

  public OrderIdentifiers phoneId(@jakarta.annotation.Nullable String phoneId) {
    
    this.phoneId = phoneId;
    return this;
  }

  /**
   * Phone number of the contact associated with the order
   * @return phoneId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PHONE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPhoneId() {
    return phoneId;
  }


  @JsonProperty(JSON_PROPERTY_PHONE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhoneId(@jakarta.annotation.Nullable String phoneId) {
    this.phoneId = phoneId;
  }

  public OrderIdentifiers emailId(@jakarta.annotation.Nullable String emailId) {
    
    this.emailId = emailId;
    return this;
  }

  /**
   * Email of the contact associated with the order
   * @return emailId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EMAIL_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEmailId() {
    return emailId;
  }


  @JsonProperty(JSON_PROPERTY_EMAIL_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmailId(@jakarta.annotation.Nullable String emailId) {
    this.emailId = emailId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OrderIdentifiers orderIdentifiers = (OrderIdentifiers) o;
    return Objects.equals(this.extId, orderIdentifiers.extId) &&
        Objects.equals(this.loyaltySubscriptionId, orderIdentifiers.loyaltySubscriptionId) &&
        Objects.equals(this.phoneId, orderIdentifiers.phoneId) &&
        Objects.equals(this.emailId, orderIdentifiers.emailId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(extId, loyaltySubscriptionId, phoneId, emailId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrderIdentifiers {\n");
    sb.append("    extId: ").append(toIndentedString(extId)).append("\n");
    sb.append("    loyaltySubscriptionId: ").append(toIndentedString(loyaltySubscriptionId)).append("\n");
    sb.append("    phoneId: ").append(toIndentedString(phoneId)).append("\n");
    sb.append("    emailId: ").append(toIndentedString(emailId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `ext_id` to the URL query string
    if (getExtId() != null) {
      try {
        joiner.add(String.format("%sext_id%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExtId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `loyalty_subscription_id` to the URL query string
    if (getLoyaltySubscriptionId() != null) {
      try {
        joiner.add(String.format("%sloyalty_subscription_id%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getLoyaltySubscriptionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `phone_id` to the URL query string
    if (getPhoneId() != null) {
      try {
        joiner.add(String.format("%sphone_id%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPhoneId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `email_id` to the URL query string
    if (getEmailId() != null) {
      try {
        joiner.add(String.format("%semail_id%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEmailId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

