/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Billing details of an order.
 */
@JsonPropertyOrder({
  OrderBilling.JSON_PROPERTY_ADDRESS,
  OrderBilling.JSON_PROPERTY_CITY,
  OrderBilling.JSON_PROPERTY_COUNTRY_CODE,
  OrderBilling.JSON_PROPERTY_COUNTRY,
  OrderBilling.JSON_PROPERTY_PHONE,
  OrderBilling.JSON_PROPERTY_POST_CODE,
  OrderBilling.JSON_PROPERTY_PAYMENT_METHOD,
  OrderBilling.JSON_PROPERTY_REGION
})
@JsonTypeName("order_billing")
public class OrderBilling {
  public static final String JSON_PROPERTY_ADDRESS = "address";
  @jakarta.annotation.Nullable
  private String address;

  public static final String JSON_PROPERTY_CITY = "city";
  @jakarta.annotation.Nullable
  private String city;

  public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
  @jakarta.annotation.Nullable
  private String countryCode;

  public static final String JSON_PROPERTY_COUNTRY = "country";
  @jakarta.annotation.Nullable
  private String country;

  public static final String JSON_PROPERTY_PHONE = "phone";
  @jakarta.annotation.Nullable
  private String phone;

  public static final String JSON_PROPERTY_POST_CODE = "postCode";
  @jakarta.annotation.Nullable
  private String postCode;

  public static final String JSON_PROPERTY_PAYMENT_METHOD = "paymentMethod";
  @jakarta.annotation.Nullable
  private String paymentMethod;

  public static final String JSON_PROPERTY_REGION = "region";
  @jakarta.annotation.Nullable
  private String region;

  public OrderBilling() {
  }

  public OrderBilling address(@jakarta.annotation.Nullable String address) {
    
    this.address = address;
    return this;
  }

  /**
   * Full billing address.
   * @return address
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress(@jakarta.annotation.Nullable String address) {
    this.address = address;
  }

  public OrderBilling city(@jakarta.annotation.Nullable String city) {
    
    this.city = city;
    return this;
  }

  /**
   * Exact city of the address.
   * @return city
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCity() {
    return city;
  }


  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCity(@jakarta.annotation.Nullable String city) {
    this.city = city;
  }

  public OrderBilling countryCode(@jakarta.annotation.Nullable String countryCode) {
    
    this.countryCode = countryCode;
    return this;
  }

  /**
   * Billing country 2-letter ISO code.
   * @return countryCode
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryCode() {
    return countryCode;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryCode(@jakarta.annotation.Nullable String countryCode) {
    this.countryCode = countryCode;
  }

  public OrderBilling country(@jakarta.annotation.Nullable String country) {
    
    this.country = country;
    return this;
  }

  /**
   * Billing country name.
   * @return country
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountry() {
    return country;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountry(@jakarta.annotation.Nullable String country) {
    this.country = country;
  }

  public OrderBilling phone(@jakarta.annotation.Nullable String phone) {
    
    this.phone = phone;
    return this;
  }

  /**
   * Billing phone number.
   * @return phone
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PHONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPhone() {
    return phone;
  }


  @JsonProperty(JSON_PROPERTY_PHONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhone(@jakarta.annotation.Nullable String phone) {
    this.phone = phone;
  }

  public OrderBilling postCode(@jakarta.annotation.Nullable String postCode) {
    
    this.postCode = postCode;
    return this;
  }

  /**
   * Postcode for delivery and billing.
   * @return postCode
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_POST_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPostCode() {
    return postCode;
  }


  @JsonProperty(JSON_PROPERTY_POST_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPostCode(@jakarta.annotation.Nullable String postCode) {
    this.postCode = postCode;
  }

  public OrderBilling paymentMethod(@jakarta.annotation.Nullable String paymentMethod) {
    
    this.paymentMethod = paymentMethod;
    return this;
  }

  /**
   * How the visitor will pay for the item(s), e.g. paypal, check, etc.
   * @return paymentMethod
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPaymentMethod() {
    return paymentMethod;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentMethod(@jakarta.annotation.Nullable String paymentMethod) {
    this.paymentMethod = paymentMethod;
  }

  public OrderBilling region(@jakarta.annotation.Nullable String region) {
    
    this.region = region;
    return this;
  }

  /**
   * Exact region (state/province) for delivery and billing.
   * @return region
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REGION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRegion() {
    return region;
  }


  @JsonProperty(JSON_PROPERTY_REGION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRegion(@jakarta.annotation.Nullable String region) {
    this.region = region;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OrderBilling orderBilling = (OrderBilling) o;
    return Objects.equals(this.address, orderBilling.address) &&
        Objects.equals(this.city, orderBilling.city) &&
        Objects.equals(this.countryCode, orderBilling.countryCode) &&
        Objects.equals(this.country, orderBilling.country) &&
        Objects.equals(this.phone, orderBilling.phone) &&
        Objects.equals(this.postCode, orderBilling.postCode) &&
        Objects.equals(this.paymentMethod, orderBilling.paymentMethod) &&
        Objects.equals(this.region, orderBilling.region);
  }

  @Override
  public int hashCode() {
    return Objects.hash(address, city, countryCode, country, phone, postCode, paymentMethod, region);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrderBilling {\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    phone: ").append(toIndentedString(phone)).append("\n");
    sb.append("    postCode: ").append(toIndentedString(postCode)).append("\n");
    sb.append("    paymentMethod: ").append(toIndentedString(paymentMethod)).append("\n");
    sb.append("    region: ").append(toIndentedString(region)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `address` to the URL query string
    if (getAddress() != null) {
      try {
        joiner.add(String.format("%saddress%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAddress()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `city` to the URL query string
    if (getCity() != null) {
      try {
        joiner.add(String.format("%scity%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCity()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `countryCode` to the URL query string
    if (getCountryCode() != null) {
      try {
        joiner.add(String.format("%scountryCode%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCountryCode()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `country` to the URL query string
    if (getCountry() != null) {
      try {
        joiner.add(String.format("%scountry%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCountry()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `phone` to the URL query string
    if (getPhone() != null) {
      try {
        joiner.add(String.format("%sphone%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPhone()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `postCode` to the URL query string
    if (getPostCode() != null) {
      try {
        joiner.add(String.format("%spostCode%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPostCode()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `paymentMethod` to the URL query string
    if (getPaymentMethod() != null) {
      try {
        joiner.add(String.format("%spaymentMethod%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPaymentMethod()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `region` to the URL query string
    if (getRegion() != null) {
      try {
        joiner.add(String.format("%sregion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRegion()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

