/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import software.xdev.brevo.model.Order;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * OrderBatch
 */
@JsonPropertyOrder({
  OrderBatch.JSON_PROPERTY_ORDERS,
  OrderBatch.JSON_PROPERTY_NOTIFY_URL,
  OrderBatch.JSON_PROPERTY_HISTORICAL
})
@JsonTypeName("orderBatch")
public class OrderBatch {
  public static final String JSON_PROPERTY_ORDERS = "orders";
  @jakarta.annotation.Nonnull
  private List<Order> orders = new ArrayList<>();

  public static final String JSON_PROPERTY_NOTIFY_URL = "notifyUrl";
  @jakarta.annotation.Nullable
  private String notifyUrl;

  public static final String JSON_PROPERTY_HISTORICAL = "historical";
  @jakarta.annotation.Nullable
  private Boolean historical = true;

  public OrderBatch() {
  }

  public OrderBatch orders(@jakarta.annotation.Nonnull List<Order> orders) {
    
    this.orders = orders;
    return this;
  }

  public OrderBatch addOrdersItem(Order ordersItem) {
    if (this.orders == null) {
      this.orders = new ArrayList<>();
    }
    this.orders.add(ordersItem);
    return this;
  }

  /**
   * array of order objects
   * @return orders
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ORDERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<Order> getOrders() {
    return orders;
  }


  @JsonProperty(JSON_PROPERTY_ORDERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOrders(@jakarta.annotation.Nonnull List<Order> orders) {
    this.orders = orders;
  }

  public OrderBatch notifyUrl(@jakarta.annotation.Nullable String notifyUrl) {
    
    this.notifyUrl = notifyUrl;
    return this;
  }

  /**
   * Notify Url provided by client to get the status of batch request
   * @return notifyUrl
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NOTIFY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNotifyUrl() {
    return notifyUrl;
  }


  @JsonProperty(JSON_PROPERTY_NOTIFY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNotifyUrl(@jakarta.annotation.Nullable String notifyUrl) {
    this.notifyUrl = notifyUrl;
  }

  public OrderBatch historical(@jakarta.annotation.Nullable Boolean historical) {
    
    this.historical = historical;
    return this;
  }

  /**
   * Defines wether you want your orders to be considered as live data or as historical data (import of past data, synchronising data). True: orders will not trigger any automation workflows. False: orders will trigger workflows as usual.
   * @return historical
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HISTORICAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHistorical() {
    return historical;
  }


  @JsonProperty(JSON_PROPERTY_HISTORICAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHistorical(@jakarta.annotation.Nullable Boolean historical) {
    this.historical = historical;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OrderBatch orderBatch = (OrderBatch) o;
    return Objects.equals(this.orders, orderBatch.orders) &&
        Objects.equals(this.notifyUrl, orderBatch.notifyUrl) &&
        Objects.equals(this.historical, orderBatch.historical);
  }

  @Override
  public int hashCode() {
    return Objects.hash(orders, notifyUrl, historical);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrderBatch {\n");
    sb.append("    orders: ").append(toIndentedString(orders)).append("\n");
    sb.append("    notifyUrl: ").append(toIndentedString(notifyUrl)).append("\n");
    sb.append("    historical: ").append(toIndentedString(historical)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `orders` to the URL query string
    if (getOrders() != null) {
      for (int i = 0; i < getOrders().size(); i++) {
        if (getOrders().get(i) != null) {
          joiner.add(getOrders().get(i).toUrlQueryString(String.format("%sorders%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `notifyUrl` to the URL query string
    if (getNotifyUrl() != null) {
      try {
        joiner.add(String.format("%snotifyUrl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getNotifyUrl()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `historical` to the URL query string
    if (getHistorical() != null) {
      try {
        joiner.add(String.format("%shistorical%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getHistorical()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

