/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.xdev.brevo.model.OrderBilling;
import software.xdev.brevo.model.OrderIdentifiers;
import software.xdev.brevo.model.OrderMetaInfoValue;
import software.xdev.brevo.model.OrderProductsInner;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Order
 */
@JsonPropertyOrder({
  Order.JSON_PROPERTY_ID,
  Order.JSON_PROPERTY_CREATED_AT,
  Order.JSON_PROPERTY_UPDATED_AT,
  Order.JSON_PROPERTY_STATUS,
  Order.JSON_PROPERTY_AMOUNT,
  Order.JSON_PROPERTY_STORE_ID,
  Order.JSON_PROPERTY_IDENTIFIERS,
  Order.JSON_PROPERTY_PRODUCTS,
  Order.JSON_PROPERTY_BILLING,
  Order.JSON_PROPERTY_COUPONS,
  Order.JSON_PROPERTY_META_INFO
})
@JsonTypeName("order")
public class Order {
  public static final String JSON_PROPERTY_ID = "id";
  @jakarta.annotation.Nonnull
  private String id;

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  @jakarta.annotation.Nonnull
  private String createdAt;

  public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
  @jakarta.annotation.Nonnull
  private String updatedAt;

  public static final String JSON_PROPERTY_STATUS = "status";
  @jakarta.annotation.Nonnull
  private String status;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  @jakarta.annotation.Nonnull
  private BigDecimal amount;

  public static final String JSON_PROPERTY_STORE_ID = "storeId";
  @jakarta.annotation.Nullable
  private String storeId;

  public static final String JSON_PROPERTY_IDENTIFIERS = "identifiers";
  @jakarta.annotation.Nullable
  private OrderIdentifiers identifiers;

  public static final String JSON_PROPERTY_PRODUCTS = "products";
  @jakarta.annotation.Nonnull
  private List<OrderProductsInner> products = new ArrayList<>();

  public static final String JSON_PROPERTY_BILLING = "billing";
  @jakarta.annotation.Nullable
  private OrderBilling billing;

  public static final String JSON_PROPERTY_COUPONS = "coupons";
  @jakarta.annotation.Nullable
  private List<String> coupons = new ArrayList<>();

  public static final String JSON_PROPERTY_META_INFO = "metaInfo";
  @jakarta.annotation.Nullable
  private Map<String, OrderMetaInfoValue> metaInfo = new HashMap<>();

  public Order() {
  }

  public Order id(@jakarta.annotation.Nonnull String id) {
    
    this.id = id;
    return this;
  }

  /**
   * Unique ID of the order.
   * @return id
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(@jakarta.annotation.Nonnull String id) {
    this.id = id;
  }

  public Order createdAt(@jakarta.annotation.Nonnull String createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Event occurrence UTC date-time (YYYY-MM-DDTHH:mm:ssZ), when order is actually created.
   * @return createdAt
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCreatedAt(@jakarta.annotation.Nonnull String createdAt) {
    this.createdAt = createdAt;
  }

  public Order updatedAt(@jakarta.annotation.Nonnull String updatedAt) {
    
    this.updatedAt = updatedAt;
    return this;
  }

  /**
   * Event updated UTC date-time (YYYY-MM-DDTHH:mm:ssZ), when the status of the order is actually changed/updated.
   * @return updatedAt
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getUpdatedAt() {
    return updatedAt;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUpdatedAt(@jakarta.annotation.Nonnull String updatedAt) {
    this.updatedAt = updatedAt;
  }

  public Order status(@jakarta.annotation.Nonnull String status) {
    
    this.status = status;
    return this;
  }

  /**
   * State of the order.
   * @return status
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatus(@jakarta.annotation.Nonnull String status) {
    this.status = status;
  }

  public Order amount(@jakarta.annotation.Nonnull BigDecimal amount) {
    
    this.amount = amount;
    return this;
  }

  /**
   * Total amount of the order, including all shipping expenses, tax and the price of items.
   * @return amount
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmount(@jakarta.annotation.Nonnull BigDecimal amount) {
    this.amount = amount;
  }

  public Order storeId(@jakarta.annotation.Nullable String storeId) {
    
    this.storeId = storeId;
    return this;
  }

  /**
   * ID of store where the order is placed
   * @return storeId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STORE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStoreId() {
    return storeId;
  }


  @JsonProperty(JSON_PROPERTY_STORE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStoreId(@jakarta.annotation.Nullable String storeId) {
    this.storeId = storeId;
  }

  public Order identifiers(@jakarta.annotation.Nullable OrderIdentifiers identifiers) {
    
    this.identifiers = identifiers;
    return this;
  }

  /**
   * Get identifiers
   * @return identifiers
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OrderIdentifiers getIdentifiers() {
    return identifiers;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifiers(@jakarta.annotation.Nullable OrderIdentifiers identifiers) {
    this.identifiers = identifiers;
  }

  public Order products(@jakarta.annotation.Nonnull List<OrderProductsInner> products) {
    
    this.products = products;
    return this;
  }

  public Order addProductsItem(OrderProductsInner productsItem) {
    if (this.products == null) {
      this.products = new ArrayList<>();
    }
    this.products.add(productsItem);
    return this;
  }

  /**
   * Get products
   * @return products
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<OrderProductsInner> getProducts() {
    return products;
  }


  @JsonProperty(JSON_PROPERTY_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProducts(@jakarta.annotation.Nonnull List<OrderProductsInner> products) {
    this.products = products;
  }

  public Order billing(@jakarta.annotation.Nullable OrderBilling billing) {
    
    this.billing = billing;
    return this;
  }

  /**
   * Get billing
   * @return billing
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BILLING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OrderBilling getBilling() {
    return billing;
  }


  @JsonProperty(JSON_PROPERTY_BILLING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBilling(@jakarta.annotation.Nullable OrderBilling billing) {
    this.billing = billing;
  }

  public Order coupons(@jakarta.annotation.Nullable List<String> coupons) {
    
    this.coupons = coupons;
    return this;
  }

  public Order addCouponsItem(String couponsItem) {
    if (this.coupons == null) {
      this.coupons = new ArrayList<>();
    }
    this.coupons.add(couponsItem);
    return this;
  }

  /**
   * Coupons applied to the order. Stored case insensitive.
   * @return coupons
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_COUPONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getCoupons() {
    return coupons;
  }


  @JsonProperty(JSON_PROPERTY_COUPONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCoupons(@jakarta.annotation.Nullable List<String> coupons) {
    this.coupons = coupons;
  }

  public Order metaInfo(@jakarta.annotation.Nullable Map<String, OrderMetaInfoValue> metaInfo) {
    
    this.metaInfo = metaInfo;
    return this;
  }

  public Order putMetaInfoItem(String key, OrderMetaInfoValue metaInfoItem) {
    if (this.metaInfo == null) {
      this.metaInfo = new HashMap<>();
    }
    this.metaInfo.put(key, metaInfoItem);
    return this;
  }

  /**
   * Meta data of order to store additional detal such as custom message, customer type, source.
   * @return metaInfo
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_META_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, OrderMetaInfoValue> getMetaInfo() {
    return metaInfo;
  }


  @JsonProperty(JSON_PROPERTY_META_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetaInfo(@jakarta.annotation.Nullable Map<String, OrderMetaInfoValue> metaInfo) {
    this.metaInfo = metaInfo;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Order order = (Order) o;
    return Objects.equals(this.id, order.id) &&
        Objects.equals(this.createdAt, order.createdAt) &&
        Objects.equals(this.updatedAt, order.updatedAt) &&
        Objects.equals(this.status, order.status) &&
        Objects.equals(this.amount, order.amount) &&
        Objects.equals(this.storeId, order.storeId) &&
        Objects.equals(this.identifiers, order.identifiers) &&
        Objects.equals(this.products, order.products) &&
        Objects.equals(this.billing, order.billing) &&
        Objects.equals(this.coupons, order.coupons) &&
        Objects.equals(this.metaInfo, order.metaInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdAt, updatedAt, status, amount, storeId, identifiers, products, billing, coupons, metaInfo);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Order {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    storeId: ").append(toIndentedString(storeId)).append("\n");
    sb.append("    identifiers: ").append(toIndentedString(identifiers)).append("\n");
    sb.append("    products: ").append(toIndentedString(products)).append("\n");
    sb.append("    billing: ").append(toIndentedString(billing)).append("\n");
    sb.append("    coupons: ").append(toIndentedString(coupons)).append("\n");
    sb.append("    metaInfo: ").append(toIndentedString(metaInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `createdAt` to the URL query string
    if (getCreatedAt() != null) {
      try {
        joiner.add(String.format("%screatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreatedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `updatedAt` to the URL query string
    if (getUpdatedAt() != null) {
      try {
        joiner.add(String.format("%supdatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUpdatedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `status` to the URL query string
    if (getStatus() != null) {
      try {
        joiner.add(String.format("%sstatus%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStatus()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `amount` to the URL query string
    if (getAmount() != null) {
      try {
        joiner.add(String.format("%samount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAmount()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `storeId` to the URL query string
    if (getStoreId() != null) {
      try {
        joiner.add(String.format("%sstoreId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStoreId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `identifiers` to the URL query string
    if (getIdentifiers() != null) {
      joiner.add(getIdentifiers().toUrlQueryString(prefix + "identifiers" + suffix));
    }

    // add `products` to the URL query string
    if (getProducts() != null) {
      for (int i = 0; i < getProducts().size(); i++) {
        if (getProducts().get(i) != null) {
          joiner.add(getProducts().get(i).toUrlQueryString(String.format("%sproducts%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `billing` to the URL query string
    if (getBilling() != null) {
      joiner.add(getBilling().toUrlQueryString(prefix + "billing" + suffix));
    }

    // add `coupons` to the URL query string
    if (getCoupons() != null) {
      for (int i = 0; i < getCoupons().size(); i++) {
        try {
          joiner.add(String.format("%scoupons%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getCoupons().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `metaInfo` to the URL query string
    if (getMetaInfo() != null) {
      for (String _key : getMetaInfo().keySet()) {
        if (getMetaInfo().get(_key) != null) {
          joiner.add(getMetaInfo().get(_key).toUrlQueryString(String.format("%smetaInfo%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

